/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.util.FileUtils;
import flash.util.LRUCache;
import flash.util.Trace;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcDirectoryArchive;
import flex2.compiler.swc.SwcDynamicArchive;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcGroup;
import flex2.compiler.swc.SwcLazyReadArchive;
import flex2.compiler.swc.SwcWriteOnlyArchive;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwcCache {
    public static int CACHE_INITIAL_SIZE = 20;
    public static int CACHE_MAX_SIZE = 66;
    public static final String SWC_EXTENSION = ".swc";
    public static final String GENSWC_EXTENSION = "-generated.swc";
    protected SwcLRUCache swcLRUCache = new SwcLRUCache();
    protected boolean useCache = true;
    protected boolean lazyRead = true;

    public SwcGroup getSwcGroup(VirtualFile[] paths) {
        String[] urls = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            urls[i] = paths[i].getName();
        }
        return this.getSwcGroup(urls);
    }

    public synchronized SwcGroup getSwcGroup(String[] paths) {
        LinkedHashMap<String, Swc> swcs = new LinkedHashMap<String, Swc>();
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            swcs.putAll(this.getSwcs(path));
        }
        SwcGroup group = new SwcGroup(swcs);
        return group;
    }

    public synchronized SwcGroup getSwcGroup(List<SwcGroup> groups, SwcGroup rslGroup) {
        LinkedHashMap<String, Swc> swcs = new LinkedHashMap<String, Swc>();
        for (SwcGroup g : groups) {
            if (g == null) continue;
            swcs.putAll(g.getSwcs());
        }
        SwcGroup group = null;
        if (swcs.size() > 0) {
            group = new SwcGroup(swcs, rslGroup);
        }
        return group;
    }

    public synchronized boolean export(Swc swc) throws FileNotFoundException, IOException {
        try {
            if (!swc.save()) {
                return false;
            }
            if (Trace.swc) {
                Trace.trace((String)("Exported SWC " + swc.getLocation() + "(" + swc.getLastModified() + ")"));
            }
            if (!(swc.getArchive() instanceof SwcWriteOnlyArchive)) {
                this.swcLRUCache.put(swc.getLocation(), swc);
            }
        }
        catch (Exception e) {
            if (Trace.error) {
                e.printStackTrace();
            }
            if (e instanceof SwcException) {
                throw (SwcException)e;
            }
            SwcException.SwcNotExported ex = new SwcException.SwcNotExported(swc.getLocation(), e);
            ThreadLocalToolkit.log(ex);
            throw ex;
        }
        return true;
    }

    protected Map<String, Swc> getSwcs(String path) {
        LinkedHashMap<String, Swc> map = new LinkedHashMap<String, Swc>();
        File f = new File(path);
        if (!f.exists()) {
            throw new SwcException.SwcNotFound(path);
        }
        File catalog = new File(FileUtils.addPathComponents((String)path, (String)Swc.CATALOG_XML, (char)File.separatorChar));
        if (!f.isDirectory() || catalog.exists()) {
            Swc swc = this.getSwc(f);
            if (swc != null) {
                map.put(swc.getLocation(), swc);
            }
        } else {
            File[] files = FileUtils.listFiles((File)f);
            for (int i = 0; i < files.length; ++i) {
                Swc swc;
                String lowerCase;
                File file = files[i];
                if (file.isDirectory() || !file.canRead() || (lowerCase = file.getName().toLowerCase()).endsWith(GENSWC_EXTENSION) || !lowerCase.endsWith(SWC_EXTENSION) || (swc = this.getSwc(file)) == null) continue;
                map.put(swc.getLocation(), swc);
            }
        }
        return map;
    }

    protected Swc getSwc(File file) {
        Swc swc;
        try {
            String location = FileUtils.canonicalPath((File)file);
            swc = (Swc)this.swcLRUCache.get(location);
            long fileLastModified = file.lastModified();
            if (swc == null || fileLastModified != swc.getLastModified()) {
                if (Trace.swc) {
                    if (swc != null) {
                        Trace.trace((String)("Reloading: location = " + location + ", fileLastModified = " + fileLastModified + ", swc.getLastModified() = " + swc.getLastModified() + ", swc = " + swc.hashCode()));
                    } else {
                        Trace.trace((String)("Loading " + location));
                    }
                }
                SwcArchive archive = file.isDirectory() ? new SwcDirectoryArchive(location) : (this.lazyRead ? new SwcLazyReadArchive(location) : new SwcDynamicArchive(location));
                swc = new Swc(archive, true);
                swc.setLastModified(fileLastModified);
                if (ThreadLocalToolkit.errorCount() > 0) {
                    swc = null;
                } else if (this.useCache) {
                    this.swcLRUCache.put(location, swc);
                }
            } else if (Trace.swc) {
                Trace.trace((String)("Using cached version of " + location));
            }
        }
        catch (Exception e) {
            if (Trace.error) {
                e.printStackTrace();
            }
            SwcException.SwcNotLoaded ex = new SwcException.SwcNotLoaded(file.getName(), e);
            ThreadLocalToolkit.log(ex);
            throw ex;
        }
        return swc;
    }

    public void setLastModified(String location, long lastModified) {
        Swc swc = (Swc)this.swcLRUCache.get(location);
        if (swc != null) {
            swc.setLastModified(lastModified);
        }
    }

    public void setLazyRead(boolean lazyRead) {
        this.lazyRead = lazyRead;
    }

    public void remove(String swcLocation) {
        this.swcLRUCache.remove(swcLocation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SwcLRUCache
    extends LRUCache {
        private static final long serialVersionUID = 1867582701366939733L;

        SwcLRUCache() {
            super(CACHE_INITIAL_SIZE, CACHE_MAX_SIZE);
        }

        protected Object fetch(Object key) {
            return null;
        }

        public List<Swc> getSwcs() {
            ArrayList<Swc> swcs = new ArrayList<Swc>(this.size());
            for (Map.Entry entry : this.entrySet()) {
                LRUCache.LRUListEntry lruEntry = (LRUCache.LRUListEntry)entry.getValue();
                swcs.add((Swc)lruEntry.getValue());
            }
            return swcs;
        }
    }
}

