/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.util.base64;

import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.FilterByteWriter;
import com.adobe.internal.util.base64.Base64Engine;
import java.io.IOException;

public class ToBase64ByteWriter
extends FilterByteWriter {
    protected int dataBytesPerBlock = 3;
    protected int base64BytesPerBlock = 4;
    protected int blocksPerLine;
    protected static final int linesPerBuffer = 10;
    protected byte[] buffer;
    protected int dataBytesPerBuffer;
    protected int base64BytesPerBuffer;
    protected byte[] partialConversionBuffer = new byte[6];
    protected int dataLineLength;
    protected int base64DataLineLength;
    protected int base64TotalLineLength;
    protected int fillerBytes;
    protected Base64Engine base64Engine;

    public ToBase64ByteWriter(ByteWriter byteWriter) throws IOException {
        this(byteWriter, 19, Base64Engine.LineEnding.CR);
    }

    public ToBase64ByteWriter(ByteWriter byteWriter, int n, Base64Engine.LineEnding lineEnding) throws IOException {
        super(byteWriter);
        this.base64Engine = new Base64Engine(n * this.base64BytesPerBlock, lineEnding, true);
        this.blocksPerLine = n;
        this.dataLineLength = this.blocksPerLine * this.dataBytesPerBlock;
        this.base64DataLineLength = this.blocksPerLine * this.base64BytesPerBlock;
        this.base64TotalLineLength = this.base64DataLineLength + lineEnding.length();
        this.buffer = new byte[this.base64TotalLineLength * 10];
        this.dataBytesPerBuffer = this.dataLineLength * 10;
        this.base64BytesPerBuffer = this.base64DataLineLength * 10;
        this.fillerBytes = this.countFillerBytes();
    }

    private int countFillerBytes() throws IOException {
        int n = 0;
        long l = super.length() - 1L;
        while (super.read(l) == 61) {
            ++n;
            --l;
        }
        return n;
    }

    public long length() throws IOException {
        long l = super.length();
        long l2 = l / (long)this.base64TotalLineLength;
        long l3 = l % (long)this.base64TotalLineLength;
        long l4 = l2 * (long)this.dataLineLength + l3 / (long)this.base64BytesPerBlock * (long)this.dataBytesPerBlock;
        return l4 - (long)this.fillerBytes;
    }

    public int read(long l, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        long l2 = this.dataPositionToBase64BlockPosition(l);
        int n5 = 0;
        int n6 = (int)(l % (long)this.dataBytesPerBlock);
        for (n4 = 0; n4 < n2 && (n3 = super.read(l2, this.buffer, 0, this.buffer.length)) != -1; n4 += n5) {
            n5 = this.base64Engine.decode(this.buffer, 0, n3, byArray, n4, Math.min(n2 - n4, byArray.length - n4), n6);
            if (n5 == 0) break;
            l2 = this.dataPositionToBase64BlockPosition(l + (long)n4);
            n6 = (int)((l + (long)n4) % (long)this.dataBytesPerBlock);
        }
        return n4;
    }

    private long dataPositionToDataBlockPosition(long l) {
        return l / (long)this.dataBytesPerBlock * (long)this.dataBytesPerBlock;
    }

    private long dataPositionToBase64BlockPosition(long l) {
        long l2 = l / (long)this.dataLineLength;
        long l3 = l % (long)this.dataLineLength / (long)this.dataBytesPerBlock * (long)this.base64BytesPerBlock;
        return l2 * (long)this.base64TotalLineLength + l3;
    }

    private void fillEmptySpace(long l, long l2) throws IOException {
        int n;
        byte[] byArray = new byte[this.dataLineLength];
        long l3 = this.dataPositionToBase64BlockPosition(l);
        int n2 = (int)(l % (long)this.dataBytesPerBlock);
        int n3 = (int)Math.min(l2, (long)((this.dataBytesPerBlock - n2) % this.dataBytesPerBlock));
        int n4 = (int)((l2 - (long)n3) / (long)this.dataBytesPerBlock * (long)this.dataBytesPerBlock % (long)this.dataLineLength);
        long l4 = (l2 - (long)n3 - (long)n4) / (long)this.dataLineLength;
        int n5 = (int)((l2 - (long)n3 - (long)n4) % (long)this.dataLineLength);
        if (n3 > 0) {
            super.read(l3, this.partialConversionBuffer, 0, this.base64BytesPerBlock);
            this.base64Engine.decode(this.partialConversionBuffer, 0, this.base64BytesPerBlock, this.buffer, 0);
            switch (n2) {
                case 1: {
                    this.buffer[1] = 0;
                }
                case 2: {
                    this.buffer[2] = 0;
                }
            }
            n = this.base64Engine.encode(this.buffer, 0, n2 + n3, this.partialConversionBuffer, 0, (int)(l3 % (long)this.base64TotalLineLength));
            super.write(l3, this.partialConversionBuffer, 0, n);
            l3 += (long)n;
        }
        if (n4 > 0) {
            n = this.base64Engine.encode(byArray, 0, n4, this.buffer, 0, (int)(l3 % (long)this.base64TotalLineLength));
            super.write(l3, this.buffer, 0, n);
            l3 += (long)n;
        }
        if (l4 > 0L) {
            n = this.base64Engine.encode(byArray, 0, this.dataLineLength, this.buffer, 0, 0);
            while (l4 > 0L) {
                super.write(l3, this.buffer, 0, n);
                l3 += (long)n;
                --l4;
            }
        }
        if (n5 > 0) {
            n = this.base64Engine.encode(byArray, 0, n5, this.buffer, 0, (int)(l3 % (long)this.base64TotalLineLength));
            super.write(l3, this.buffer, 0, n);
            l3 += (long)n;
        }
    }

    public int read(long l) throws IOException {
        long l2 = this.dataPositionToBase64BlockPosition(l);
        int n = (int)(l % (long)this.dataBytesPerBlock);
        int n2 = super.read(l2, this.buffer, 0, this.base64BytesPerBlock);
        this.base64Engine.decode(this.buffer, 0, n2, this.partialConversionBuffer, 0);
        return this.partialConversionBuffer[n] & 0xFF;
    }

    public void write(long l, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        byte[] byArray2;
        long l2 = this.dataPositionToBase64BlockPosition(l);
        int n4 = 0;
        int n5 = (int)(l % (long)this.dataBytesPerBlock);
        int n6 = Math.min((this.dataBytesPerBlock - n5) % this.dataBytesPerBlock, n2);
        int n7 = Math.max(n2 - n6, 0) % this.dataBytesPerBlock;
        int n8 = n2 - n6 - n7;
        long l3 = this.length();
        this.fillerBytes = n7 == 0 && n8 == 0 ? this.dataBytesPerBlock - n5 - n6 : (this.dataBytesPerBlock - n7) % this.dataBytesPerBlock;
        if (l > l3) {
            this.fillEmptySpace(l3, l - l3);
        }
        if (l >= l3) {
            n8 += n7;
            n7 = 0;
        }
        if (n6 > 0) {
            super.read(l2, this.partialConversionBuffer, 0, this.base64BytesPerBlock);
            byArray2 = new byte[this.base64BytesPerBlock];
            this.base64Engine.decode(this.partialConversionBuffer, 0, this.base64BytesPerBlock, byArray2, 0);
            System.arraycopy(byArray, 0, byArray2, n5, Math.min(n6, byArray.length));
            n3 = this.base64Engine.encode(byArray2, 0, this.dataBytesPerBlock, this.partialConversionBuffer, 0, (int)(l2 % (long)this.base64TotalLineLength));
            super.write(l2, this.partialConversionBuffer, 0, n3);
            l2 += (long)n3;
            n4 += n6;
        }
        while (n8 > 0) {
            int n9 = Math.min(this.dataBytesPerBuffer, n8);
            n3 = this.base64Engine.encode(byArray, n4, n9, this.buffer, 0, (int)(l2 % (long)this.base64TotalLineLength));
            super.write(l2, this.buffer, 0, n3);
            n8 -= n9;
            n4 += n9;
            l2 += (long)n3;
        }
        if (n7 > 0) {
            super.read(l2, this.partialConversionBuffer, 0, this.base64BytesPerBlock);
            byArray2 = new byte[this.base64BytesPerBlock];
            this.base64Engine.decode(this.partialConversionBuffer, 0, this.base64BytesPerBlock, byArray2, 0);
            System.arraycopy(byArray, n4, byArray2, 0, n7);
            n3 = this.base64Engine.encode(byArray2, 0, this.dataBytesPerBlock, this.buffer, 0, (int)(l2 % (long)this.base64TotalLineLength));
            super.write(l2, this.buffer, 0, n3);
            l2 += (long)n3;
            n4 += n6;
        }
    }

    public void write(long l, int n) throws IOException {
        long l2 = this.dataPositionToBase64BlockPosition(l);
        int n2 = (int)(l % (long)this.dataBytesPerBlock);
        int n3 = this.dataBytesPerBlock - (n2 + 1);
        long l3 = this.length();
        if (l > l3) {
            this.fillEmptySpace(l3, l - l3);
        }
        if (l >= l3) {
            this.fillerBytes = n3;
        }
        int n4 = super.read(l2, this.partialConversionBuffer, 0, this.base64BytesPerBlock);
        n4 = Math.max(n4, 0);
        byte[] byArray = new byte[this.base64BytesPerBlock];
        this.base64Engine.decode(this.partialConversionBuffer, 0, n4, byArray, 0);
        byArray[n2] = (byte)(0xFF & n);
        int n5 = Math.max(n2 + 1, (int)Math.min((long)this.dataBytesPerBlock, l3 - this.dataPositionToDataBlockPosition(l)));
        int n6 = this.base64Engine.encode(byArray, 0, n5, this.partialConversionBuffer, 0, (int)(l2 % (long)this.base64TotalLineLength));
        super.write(l2, this.partialConversionBuffer, 0, n6);
    }
}

