/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import com.adobe.internal.io.ByteWriter;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class RandomAccessFileByteWriter
implements ByteWriter {
    private boolean closed = false;
    private long fileLength = -1L;
    private static final int DEFAULT_BUFFERSIZE = 4096;
    private static final int DEFAULT_NUMBERBUFFERS = 4;
    private int numberOfBuffers;
    private int bufferSize;
    private RandomAccessFile file;
    private Buffer[] buffers;
    private long counter;
    private Buffer mru;

    public RandomAccessFileByteWriter(RandomAccessFile randomAccessFile, int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("Invalid buffer size or number of buffers.");
        }
        this.numberOfBuffers = n;
        this.bufferSize = n2;
        this.file = randomAccessFile;
        this.buffers = new Buffer[this.numberOfBuffers];
        for (int i = 0; i < this.numberOfBuffers; ++i) {
            this.buffers[i] = new Buffer();
        }
        this.mru = this.buffers[0];
    }

    public RandomAccessFileByteWriter(RandomAccessFile randomAccessFile) {
        this(randomAccessFile, 4, 4096);
    }

    public void write(long l, int n) throws IOException {
        if (this.closed) {
            throw new IOException("ByteReader was closed");
        }
        boolean bl = false;
        if (this.fileLength == -1L) {
            this.fileLength = this.file.length();
        }
        if (l < 0L) {
            throw new IOException("Position is less than zero.");
        }
        if (l >= this.mru.base && l < this.mru.base + (long)this.bufferSize) {
            bl = true;
        } else {
            for (int i = 0; i < this.numberOfBuffers; ++i) {
                Buffer buffer = this.buffers[i];
                if (l < buffer.base || l >= buffer.base + (long)this.bufferSize) continue;
                this.mru = buffer;
                bl = true;
                break;
            }
        }
        if (!bl) {
            this.mru = this.loadLRU(l);
            bl = true;
        }
        this.mru.references = ++this.counter;
        ((Buffer)this.mru).data[(int)(l - ((Buffer)this.mru).base)] = (byte)(n & 0xFF);
        this.mru.bytesUsed = (int)Math.max((long)this.mru.bytesUsed, l - this.mru.base + 1L);
        this.mru.isDirty = true;
        this.fileLength = Math.max(this.fileLength, l + 1L);
    }

    public void write(long l, byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("ByteReader was closed");
        }
        boolean bl = false;
        if (this.fileLength == -1L) {
            this.fileLength = this.file.length();
        }
        if (l < 0L) {
            throw new IOException("Position is less than zero.");
        }
        if (l >= this.mru.base && l + (long)n2 <= this.mru.base + (long)this.bufferSize) {
            bl = true;
        } else {
            for (int i = 0; i < this.numberOfBuffers; ++i) {
                Buffer buffer = this.buffers[i];
                if (l < buffer.base || l + (long)n2 > buffer.base + (long)this.bufferSize) continue;
                this.mru = buffer;
                bl = true;
                break;
            }
        }
        if (!bl) {
            if (this.mru.buffersRequiredForRequest(l, n2) != 1) {
                this.flush();
                this.file.seek(l);
                this.file.write(byArray, n, n2);
                this.fileLength = this.file.length();
                return;
            }
            this.mru = this.loadLRU(l);
            bl = true;
        }
        this.mru.references = ++this.counter;
        System.arraycopy(byArray, n, this.mru.data, (int)(l - this.mru.base), n2);
        this.mru.bytesUsed = (int)Math.max((long)this.mru.bytesUsed, l - this.mru.base + (long)n2);
        this.mru.isDirty = true;
        this.fileLength = Math.max(this.fileLength, l + (long)n2);
    }

    public long length() throws IOException {
        if (this.closed) {
            throw new IOException("ByteReader was closed");
        }
        if (this.fileLength == -1L) {
            this.fileLength = this.file.length();
        }
        return this.fileLength;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("ByteReader was closed");
        }
        for (int i = 0; i < this.numberOfBuffers; ++i) {
            if (this.buffers[i].isDirty) {
                this.buffers[i].flushBuffer();
            }
            this.buffers[i].resetBuffer();
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        this.closed = true;
        this.file.close();
    }

    public int read(long l) throws IOException {
        if (this.closed) {
            throw new IOException("ByteReader was closed");
        }
        boolean bl = false;
        if (this.fileLength == -1L) {
            this.fileLength = this.file.length();
        }
        if (l < 0L || l >= this.fileLength) {
            return -1;
        }
        if (l >= this.mru.base && l < this.mru.base + (long)this.bufferSize) {
            bl = true;
        } else {
            for (int i = 0; i < this.numberOfBuffers; ++i) {
                Buffer buffer = this.buffers[i];
                if (l < buffer.base || l >= buffer.base + (long)this.bufferSize) continue;
                this.mru = buffer;
                bl = true;
                break;
            }
        }
        if (!bl) {
            this.mru = this.loadLRU(l);
            bl = true;
        }
        this.mru.references = ++this.counter;
        return this.mru.data[(int)(l - this.mru.base)] & 0xFF;
    }

    public int read(long l, byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("ByteReader was closed");
        }
        boolean bl = false;
        if (this.fileLength == -1L) {
            this.fileLength = this.file.length();
        }
        if (l < 0L || l >= this.fileLength) {
            return -1;
        }
        n2 = (int)Math.min((long)n2, this.fileLength - l);
        if (l >= this.mru.base && l + (long)n2 <= this.mru.base + (long)this.bufferSize) {
            bl = true;
        } else {
            for (int i = 0; i < this.numberOfBuffers; ++i) {
                Buffer buffer = this.buffers[i];
                if (l < buffer.base || l + (long)n2 > buffer.base + (long)this.bufferSize) continue;
                this.mru = buffer;
                bl = true;
                break;
            }
        }
        if (!bl) {
            if (this.mru.buffersRequiredForRequest(l, n2) != 1) {
                this.flush();
                this.file.seek(l);
                this.file.read(byArray, n, n2);
                return n2;
            }
            this.mru = this.loadLRU(l);
            bl = true;
        }
        this.mru.references = ++this.counter;
        System.arraycopy(this.mru.data, (int)(l - this.mru.base), byArray, n, n2);
        return n2;
    }

    private Buffer loadLRU(long l) throws IOException {
        Buffer buffer = null;
        long l2 = Long.MAX_VALUE;
        for (int i = 0; i < this.numberOfBuffers; ++i) {
            if (this.buffers[i].references >= l2) continue;
            buffer = this.buffers[i];
            l2 = buffer.references;
        }
        if (buffer.isDirty) {
            buffer.flushBuffer();
        }
        buffer.loadBuffer(l);
        return buffer;
    }

    public String toString() {
        return this.file.toString();
    }

    private class Buffer {
        private long base = Long.MAX_VALUE;
        private long references;
        private boolean isDirty = false;
        private int bytesUsed;
        private byte[] data;

        Buffer() {
            this.data = new byte[RandomAccessFileByteWriter.this.bufferSize];
        }

        void loadBuffer(long l) throws IOException {
            this.base = this.calculateBufferBase(l);
            this.references = ++RandomAccessFileByteWriter.this.counter;
            this.bytesUsed = (int)Math.min((long)RandomAccessFileByteWriter.this.bufferSize, Math.max(RandomAccessFileByteWriter.this.fileLength - this.base, 0L));
            if (this.base >= RandomAccessFileByteWriter.this.fileLength) {
                return;
            }
            RandomAccessFileByteWriter.this.file.seek(this.base);
            long l2 = RandomAccessFileByteWriter.this.file.read(this.data, 0, this.bytesUsed);
            if (l2 != (long)this.bytesUsed && (l2 != -1L || this.bytesUsed != 0)) {
                throw new IOException("Didn't read enough bytes from the file.  Expected = " + this.bytesUsed + ", Actual = " + l2);
            }
        }

        void flushBuffer() throws IOException {
            RandomAccessFileByteWriter.this.file.seek(this.base);
            RandomAccessFileByteWriter.this.file.write(this.data, 0, this.bytesUsed);
            this.isDirty = false;
        }

        void resetBuffer() {
            this.base = Long.MAX_VALUE;
        }

        int buffersRequiredForRequest(long l, int n) {
            long l2 = this.calculateBufferBase(l);
            long l3 = (long)RandomAccessFileByteWriter.this.bufferSize - (l - l2);
            long l4 = Math.max((long)n - l3, 0L);
            int n2 = (int)Math.ceil((float)l4 / (float)RandomAccessFileByteWriter.this.bufferSize);
            return (n != 0 ? 1 : 0) + n2;
        }

        private long calculateBufferBase(long l) {
            return l / (long)RandomAccessFileByteWriter.this.bufferSize * (long)RandomAccessFileByteWriter.this.bufferSize;
        }
    }
}

