/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IO {
    private IO() {
    }

    public static final long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[32768];
        long l = 0L;
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static final long copy(InputByteStream inputByteStream, OutputByteStream outputByteStream) throws IOException {
        return IO.copy(inputByteStream, 0L, inputByteStream.length(), outputByteStream);
    }

    public static final long copy(InputByteStream inputByteStream, OutputStream outputStream) throws IOException {
        return IO.copy(inputByteStream, 0L, inputByteStream.length(), outputStream);
    }

    public static final long copy(InputByteStream inputByteStream, long l, long l2, OutputByteStream outputByteStream) throws IOException {
        int n = 32768;
        byte[] byArray = new byte[n];
        inputByteStream.seek(l);
        long l3 = l2;
        int n2 = 0;
        long l4 = 0L;
        while ((n2 = inputByteStream.read(byArray)) != -1 && l3 > 0L) {
            if ((long)n2 < l3) {
                outputByteStream.write(byArray, 0, n2);
                l3 -= (long)n2;
                l4 += (long)n2;
                continue;
            }
            outputByteStream.write(byArray, 0, (int)l3);
            l3 = 0L;
            l4 += (long)n2;
        }
        return l4;
    }

    public static final long copy(InputByteStream inputByteStream, long l, long l2, OutputStream outputStream, int n) throws IOException {
        if (n < 1) {
            throw new IOException("Block size can't be smaller than 1 byte.");
        }
        byte[] byArray = new byte[n];
        inputByteStream.seek(l);
        long l3 = l2;
        int n2 = 0;
        long l4 = 0L;
        while ((n2 = inputByteStream.read(byArray)) != -1 && l3 > 0L) {
            if ((long)n2 < l3) {
                outputStream.write(byArray, 0, n2);
                l3 -= (long)n2;
                l4 += (long)n2;
                continue;
            }
            outputStream.write(byArray, 0, (int)l3);
            l3 = 0L;
            l4 += (long)n2;
        }
        return l4;
    }

    public static final long copy(InputByteStream inputByteStream, long l, long l2, OutputStream outputStream) throws IOException {
        return IO.copy(inputByteStream, l, l2, outputStream, 32768);
    }

    public static final byte[] longToByteArray(long l, int n) {
        byte[] byArray = new byte[n];
        while (--n >= 0) {
            byArray[n] = (byte)l;
            l >>= 8;
        }
        return byArray;
    }

    public static final byte[] inputByteStreamToArray(InputByteStream inputByteStream) throws IOException {
        int n = (int)inputByteStream.length();
        byte[] byArray = new byte[n];
        long l = inputByteStream.read(byArray);
        return (byte[])(l > 0L ? byArray : null);
    }

    public static long copy(InputStream inputStream, OutputByteStream outputByteStream) throws IOException {
        byte[] byArray = new byte[32768];
        int n = 0;
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputByteStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static int compareInputByteStreams(InputByteStream inputByteStream, InputByteStream inputByteStream2) throws IOException {
        int n;
        int n2;
        do {
            if ((n2 = inputByteStream.read()) == (n = inputByteStream2.read())) continue;
            return n2 - n;
        } while (n2 != -1);
        return n2 - n;
    }
}

