/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AlignmentUtils;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.Input;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Item<T extends Item>
implements Comparable<T> {
    protected int offset = -1;
    protected int index = -1;
    protected final DexFile dexFile;

    protected Item(DexFile dexFile) {
        assert (dexFile != null);
        this.dexFile = dexFile;
    }

    protected void readFrom(Input in, int index, ReadContext readContext) {
        try {
            assert (AlignmentUtils.isAligned(in.getCursor(), this.getItemType().ItemAlignment));
            this.offset = in.getCursor();
            this.index = index;
            this.readItem(in, readContext);
        }
        catch (Exception ex) {
            throw this.addExceptionContext(ex);
        }
    }

    protected int placeAt(int offset, int index) {
        try {
            assert (AlignmentUtils.isAligned(offset, this.getItemType().ItemAlignment));
            assert (!this.dexFile.getInplace() || offset == this.offset && this.index == index);
            this.offset = offset;
            this.index = index;
            return this.placeItem(offset);
        }
        catch (Exception ex) {
            throw this.addExceptionContext(ex);
        }
    }

    protected void writeTo(AnnotatedOutput out) {
        try {
            assert (AlignmentUtils.isAligned(this.offset, this.getItemType().ItemAlignment));
            assert (out.getCursor() == this.offset);
            if (out.annotates()) {
                out.annotate(0, "[" + this.index + "] " + this.getItemType().TypeName);
            }
            out.indent();
            this.writeItem(out);
            out.deindent();
        }
        catch (Exception ex) {
            throw this.addExceptionContext(ex);
        }
    }

    public String toString() {
        return this.getConciseIdentity();
    }

    protected abstract void readItem(Input var1, ReadContext var2);

    protected abstract int placeItem(int var1);

    protected abstract void writeItem(AnnotatedOutput var1);

    protected final RuntimeException addExceptionContext(Exception ex) {
        return ExceptionWithContext.withContext(ex, this.getConciseIdentity());
    }

    public abstract ItemType getItemType();

    public abstract String getConciseIdentity();

    public int getOffset() {
        return this.offset;
    }

    public int getIndex() {
        return this.index;
    }

    public DexFile getDexFile() {
        return this.dexFile;
    }
}

