/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.FileStoreController;
import com.adobe.testing.s3mock.KMSValidationFilter;
import com.adobe.testing.s3mock.domain.Bucket;
import com.adobe.testing.s3mock.domain.FileStore;
import com.adobe.testing.s3mock.domain.KMSKeyStore;
import com.adobe.testing.s3mock.dto.BatchDeleteRequest;
import com.adobe.testing.s3mock.dto.BatchDeleteResponse;
import com.adobe.testing.s3mock.dto.CompleteMultipartUploadResult;
import com.adobe.testing.s3mock.dto.CopyObjectResult;
import com.adobe.testing.s3mock.dto.CopyPartResult;
import com.adobe.testing.s3mock.dto.ErrorResponse;
import com.adobe.testing.s3mock.dto.InitiateMultipartUploadResult;
import com.adobe.testing.s3mock.dto.ListAllMyBucketsResult;
import com.adobe.testing.s3mock.dto.ListBucketResult;
import com.adobe.testing.s3mock.dto.ListMultipartUploadsResult;
import com.adobe.testing.s3mock.dto.ListPartsResult;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.util.ObjectRefConverter;
import com.adobe.testing.s3mock.util.RangeConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Connector;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.web.filter.OrderedHttpPutFormContentFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.http.converter.xml.MarshallingHttpMessageConverter;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.xstream.XStreamMarshaller;
import org.springframework.util.SocketUtils;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableAutoConfiguration
@ComponentScan
public class S3MockApplication
extends WebMvcConfigurerAdapter {
    private static final Logger LOG = Logger.getLogger(FileStoreController.class);
    private static final KMSKeyStore KEY_STORE = new KMSKeyStore();
    @Autowired
    private ConfigurableApplicationContext context;
    @Autowired
    private FileStore fileStore;
    @Value(value="${http.port}")
    private int httpPort;
    @Autowired
    private Environment environment;
    @Value(value="${initialBuckets:}")
    private String initialBuckets;

    public static void main(String[] args) {
        S3MockApplication.start(new String[0]);
    }

    @PostConstruct
    public void initBuckets() throws IOException {
        List buckets = Arrays.stream(this.initialBuckets.trim().split("[,; ]")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        LOG.info((Object)("Creating initial buckets: " + buckets));
        for (String bucketName : buckets) {
            LOG.info((Object)("Creating bucket: " + bucketName));
            this.fileStore.createBucket(bucketName);
        }
    }

    @Bean
    public EmbeddedServletContainerFactory servletContainer() {
        TomcatEmbeddedServletContainerFactory tomcat = new TomcatEmbeddedServletContainerFactory();
        tomcat.addAdditionalTomcatConnectors(new Connector[]{this.createHttpConnector()});
        return tomcat;
    }

    @Bean
    public KMSKeyStore kmsKeyStore() {
        return KEY_STORE;
    }

    @Bean
    public RangeConverter rangeConverter() {
        return new RangeConverter();
    }

    @Bean
    public ObjectRefConverter objectRefConverter() {
        return new ObjectRefConverter();
    }

    private Connector createHttpConnector() {
        Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        connector.setPort(this.getHttpPort());
        return connector;
    }

    public static S3MockApplication start(String ... args) {
        ConfigurableApplicationContext appCtxt = SpringApplication.run(S3MockApplication.class, (String[])args);
        return (S3MockApplication)((Object)appCtxt.getBean(S3MockApplication.class));
    }

    public void stop() {
        SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
    }

    public int getPort() {
        return Integer.parseInt(this.environment.getProperty("local.server.port"));
    }

    public synchronized int getHttpPort() {
        if (this.httpPort == 0) {
            this.httpPort = SocketUtils.findAvailableTcpPort();
        }
        return this.httpPort;
    }

    @Bean
    public Filter kmsFilter() {
        return new KMSValidationFilter(this.kmsKeyStore());
    }

    public void registerKMSKeyRef(String keyRef) {
        this.kmsKeyStore().registerKMSKeyRef(keyRef);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.defaultContentType(MediaType.APPLICATION_FORM_URLENCODED);
        configurer.favorPathExtension(false);
        configurer.mediaType("xml", MediaType.TEXT_XML);
    }

    @Bean
    public MarshallingHttpMessageConverter getMessageConverter(XStreamMarshaller xstreamMarshaller) {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaType.APPLICATION_XML);
        mediaTypes.add(MediaType.APPLICATION_FORM_URLENCODED);
        MarshallingHttpMessageConverter xmlConverter = new MarshallingHttpMessageConverter();
        xmlConverter.setSupportedMediaTypes(mediaTypes);
        xmlConverter.setMarshaller((Marshaller)xstreamMarshaller);
        xmlConverter.setUnmarshaller((Unmarshaller)xstreamMarshaller);
        return xmlConverter;
    }

    @Bean
    public XStreamMarshaller getXStreamMarshaller() {
        XStreamMarshaller xstreamMarshaller = new XStreamMarshaller();
        xstreamMarshaller.setSupportedClasses(new Class[]{Bucket.class, Owner.class, ListAllMyBucketsResult.class, CopyPartResult.class, CopyObjectResult.class, ListBucketResult.class, InitiateMultipartUploadResult.class, ListMultipartUploadsResult.class, ListPartsResult.class, CompleteMultipartUploadResult.class, BatchDeleteRequest.class, BatchDeleteResponse.class, ErrorResponse.class});
        xstreamMarshaller.setAnnotatedClasses(new Class[]{Bucket.class, Owner.class, CopyPartResult.class, ListAllMyBucketsResult.class, CopyObjectResult.class, ListBucketResult.class, InitiateMultipartUploadResult.class, ListMultipartUploadsResult.class, ListPartsResult.class, CompleteMultipartUploadResult.class, BatchDeleteRequest.class, BatchDeleteResponse.class, ErrorResponse.class});
        return xstreamMarshaller;
    }

    @Bean
    public OrderedHttpPutFormContentFilter httpPutFormContentFilter() {
        return new OrderedHttpPutFormContentFilter(){

            protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
                return true;
            }
        };
    }
}

