/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.S3MockApplication;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.junit.rules.ExternalResource;

public class S3MockRule
extends ExternalResource {
    private S3MockApplication s3MockFileStore;

    public AmazonS3 createS3Client() {
        BasicAWSCredentials credentials = new BasicAWSCredentials("foo", "bar");
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).withClientConfiguration(this.configureClientToIgnoreInvalidSslCertificates(new ClientConfiguration()))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration("https://localhost:" + this.getPort(), "us-east-1"))).enablePathStyleAccess()).build();
    }

    public int getPort() {
        return this.s3MockFileStore.getPort();
    }

    public int getHttpPort() {
        return this.s3MockFileStore.getHttpPort();
    }

    public void registerKMSKeyRef(String keyRef) {
        this.s3MockFileStore.registerKMSKeyRef(keyRef);
    }

    public ClientConfiguration configureClientToIgnoreInvalidSslCertificates(ClientConfiguration clientConfiguration) {
        clientConfiguration.getApacheHttpClientConfig().withSslSocketFactory((ConnectionSocketFactory)new SSLConnectionSocketFactory(this.createBlindlyTrustingSSLContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
        return clientConfiguration;
    }

    protected void before() {
        this.s3MockFileStore = S3MockApplication.start(new String[0]);
    }

    protected void after() {
        this.s3MockFileStore.stop();
    }

    private SSLContext createBlindlyTrustingSSLContext() {
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new X509ExtendedTrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1, Socket arg2) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1, SSLEngine arg2) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1, Socket arg2) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1, SSLEngine arg2) throws CertificateException {
                }
            }}, new SecureRandom());
            return sc;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }
}

