/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import java.util.Objects;

public final class ObjectRef {
    public static final String DELIMITER = "/";
    private final String bucket;
    private final String key;

    private ObjectRef(String bucket, String key) {
        this.bucket = bucket;
        this.key = key;
    }

    public static ObjectRef from(String copySource) {
        Objects.requireNonNull(copySource, "copySource == null");
        String[] bucketAndKey = ObjectRef.extractBucketAndKeyArray(copySource);
        return new ObjectRef(bucketAndKey[0], bucketAndKey[1]);
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ObjectRef{");
        sb.append("bucket='").append(this.bucket).append('\'');
        sb.append(", key='").append(this.key).append('\'');
        sb.append('}');
        return sb.toString();
    }

    private static String[] extractBucketAndKeyArray(String copySource) {
        String source = ObjectRef.normalizeCopySource(copySource);
        String[] bucketAndKey = source.split(DELIMITER, 2);
        if (bucketAndKey.length != 2) {
            throw new IllegalArgumentException("Expected a copySource as '/{bucket}/{key}' but got: " + copySource);
        }
        return bucketAndKey;
    }

    private static String normalizeCopySource(String copySource) {
        if (copySource.startsWith(DELIMITER)) {
            return copySource.substring(1);
        }
        return copySource;
    }
}

