/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import com.adobe.testing.s3mock.util.AbstractAwsInputStream;
import java.io.IOException;
import java.io.InputStream;

public class AwsUnsignedChunkedDecodingChecksumInputStream
extends AbstractAwsInputStream {
    public AwsUnsignedChunkedDecodingChecksumInputStream(InputStream source, long decodedLength) {
        super(source, decodedLength);
    }

    @Override
    public int read() throws IOException {
        if (this.chunkLength == 0L) {
            byte[] hexLengthBytes = this.readHexlength();
            if (hexLengthBytes.length == 0) {
                return -1;
            }
            this.setChunkLength(hexLengthBytes);
            if (this.chunkLength == 0L) {
                this.extractAlgorithmAndChecksum();
                return -1;
            }
            ++this.chunks;
        }
        ++this.readDecodedLength;
        --this.chunkLength;
        return this.source.read();
    }

    private byte[] readHexlength() throws IOException {
        byte[] hexLengthBytes = this.readUntil(CRLF);
        if (hexLengthBytes.length == 0) {
            hexLengthBytes = this.readUntil(CRLF);
        }
        return hexLengthBytes;
    }
}

