/*
 * Copyright (c) 2005 Aetrion LLC.
 */
package com.aetrion.flickr.photosets;

import java.lang.StringBuffer;

import com.aetrion.flickr.people.User;
import com.aetrion.flickr.photos.Photo;

/**
 * Meta information about a photoset.  To retrieve the photos in the photoset use PhotosetsInterface.getPhotos().
 *
 * @author Anthony Eden
 * @version $Id: Photoset.java,v 1.6 2007/03/13 22:57:43 x-mago Exp $
 */
public class Photoset {

    private String id;
    private String url;
    private User owner;
    private Photo primaryPhoto;
    private String secret;
    private String server;
    private String farm;
    private int photoCount;
    private String title;
    private String description;

    public Photoset() {

    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUrl() {
    	if(url == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("http://www.flickr.com/photos/");
            sb.append(getOwner().getId());
            sb.append("/sets/");
            sb.append(getId());
            sb.append("/");
            return sb.toString();
        } else {
            return url;
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public User getOwner() {
        return owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public Photo getPrimaryPhoto() {
        return primaryPhoto;
    }

    public void setPrimaryPhoto(Photo primaryPhoto) {
        this.primaryPhoto = primaryPhoto;
    }

    public String getSecret() {
        return secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getServer() {
        return server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getFarm() {
        return farm;
    }

    public void setFarm(String farm) {
        this.farm = farm;
    }

    public int getPhotoCount() {
        return photoCount;
    }

    public void setPhotoCount(int photoCount) {
        this.photoCount = photoCount;
    }

    public void setPhotoCount(String photoCount) {
        if (photoCount != null) {
            setPhotoCount(Integer.parseInt(photoCount));
        }
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

}
