/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Buffer;
import com.persistit.Exchange;
import com.persistit.IOTaskRunnable;
import com.persistit.JournalManager;
import com.persistit.Key;
import com.persistit.Management;
import com.persistit.Persistit;
import com.persistit.Value;
import com.persistit.Volume;
import com.persistit.exception.InUseException;
import com.persistit.exception.InvalidPageAddressException;
import com.persistit.exception.InvalidPageStructureException;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitIOException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.exception.VolumeClosedException;
import com.persistit.util.Debug;
import com.persistit.util.Util;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.locks.ReentrantLock;

public class BufferPool {
    private static final long DEFAULT_WRITER_POLL_INTERVAL = 5000L;
    private static final int PAGE_WRITER_TRANCHE_SIZE = 5000;
    private static final long RETRY_SLEEP_TIME = 50L;
    private static final int HASH_MULTIPLE = 3;
    public static final int MINIMUM_POOL_COUNT = 7;
    public static final int MAXIMUM_POOL_COUNT = Integer.MAX_VALUE;
    private static final int HASH_LOCKS = 4096;
    private static final float SMALL_VOLUME_RATIO = 0.1f;
    private static final int WRITE_AGE_THRESHOLD_RATIO = 4;
    private static final String INVENTORY_TREE_NAME = "_buffers";
    private static final int INVENTORY_VERSIONS = 3;
    private static final long INVENTORY_PRELOAD_LOG_MESSAGE_NS = 60000000000L;
    private final Persistit _persistit;
    private final Buffer[] _hashTable;
    private final ReentrantLock[] _hashLocks;
    private final Buffer[] _buffers;
    private final int _bufferCount;
    private final int _bufferSize;
    private final AtomicLongArray _availablePagesBits;
    private final AtomicBoolean _availablePages = new AtomicBoolean();
    private final int _maxKeys;
    private final AtomicInteger _clock = new AtomicInteger();
    private final AtomicLong _missCounter = new AtomicLong();
    private final AtomicLong _hitCounter = new AtomicLong();
    private final AtomicLong _newCounter = new AtomicLong();
    private final AtomicLong _evictCounter = new AtomicLong();
    private final AtomicInteger _dirtyPageCount = new AtomicInteger();
    private final AtomicLong _writeCounter = new AtomicLong();
    private final AtomicLong _forcedWriteCounter = new AtomicLong();
    private final AtomicLong _forcedCheckpointWriteCounter = new AtomicLong();
    private final AtomicBoolean _closed = new AtomicBoolean(false);
    private volatile long _earliestDirtyTimestamp = Long.MIN_VALUE;
    private final AtomicLong _flushTimestamp = new AtomicLong();
    private volatile long _writerPollInterval = 5000L;
    private volatile int _pageWriterTrancheSize = 5000;
    private PageWriter _writer;

    BufferPool(int count, int size, Persistit persistit) {
        this._persistit = persistit;
        if (count < 7) {
            throw new IllegalArgumentException("Buffer pool count too small: " + count);
        }
        if (count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Buffer pool count too large: " + count);
        }
        int possibleSize = 1024;
        boolean ok = false;
        while (!ok && possibleSize <= 16384) {
            if (size == possibleSize) {
                ok = true;
                continue;
            }
            possibleSize *= 2;
        }
        if (!ok) {
            throw new IllegalArgumentException("Invalid buffer size requested: " + size);
        }
        this._bufferCount = count;
        this._bufferSize = size;
        this._buffers = new Buffer[this._bufferCount];
        this._availablePagesBits = new AtomicLongArray((count + 63) / 64);
        this._hashTable = new Buffer[this._bufferCount * 3];
        this._hashLocks = new ReentrantLock[4096];
        this._maxKeys = (this._bufferSize - 32) / 16;
        for (int index = 0; index < 4096; ++index) {
            this._hashLocks[index] = new ReentrantLock();
        }
        int buffers = 0;
        byte[] reserve = new byte[0x100000];
        try {
            for (int index = 0; index < this._bufferCount; ++index) {
                Buffer buffer;
                this._buffers[index] = buffer = new Buffer(size, index, this, this._persistit);
                ++buffers;
            }
        }
        catch (OutOfMemoryError e) {
            reserve = null;
            System.err.print("Out of memory with ");
            System.err.print(Runtime.getRuntime().freeMemory());
            System.err.print(" bytes free after creating ");
            System.err.print(buffers);
            System.err.print("/");
            System.err.print(this._bufferCount);
            System.err.print(" buffers from maximum heap ");
            System.err.println(this._persistit.getAvailableHeap());
            throw e;
        }
        this._writer = new PageWriter();
    }

    void startThreads() throws PersistitException {
        this._writer.start();
    }

    void close() {
        this._closed.set(true);
        this._persistit.waitForIOTaskStop(this._writer);
        this._writer = null;
    }

    void crash() {
        IOTaskRunnable.crash(this._writer);
    }

    void flush(long timestamp) throws PersistitInterruptedException {
        this.setFlushTimestamp(timestamp);
        this._writer.kick();
        while (this.isFlushing()) {
            Util.sleep(50L);
        }
    }

    boolean isFlushing() {
        return this._flushTimestamp.get() != 0L;
    }

    int hashIndex(Volume vol, long page) {
        return (int)(((page ^ (long)vol.hashCode()) & Integer.MAX_VALUE) % (long)this._hashTable.length);
    }

    int countInUse(Volume vol, boolean writer) {
        int count = 0;
        for (int i = 0; i < this._bufferCount; ++i) {
            Buffer buffer = this._buffers[i];
            if (vol != null && buffer.getVolume() != vol || (buffer.getStatus() & Short.MAX_VALUE) == 0 || writer && (buffer.getStatus() & 0x8000) == 0) continue;
            ++count;
        }
        return count;
    }

    void populateBufferPoolInfo(Management.BufferPoolInfo info) {
        info.bufferCount = this._bufferCount;
        info.bufferSize = this._bufferSize;
        info.missCount = this._missCounter.get();
        info.hitCount = this._hitCounter.get();
        info.newCount = this._newCounter.get();
        info.evictCount = this._evictCounter.get();
        info.dirtyPageCount = this._dirtyPageCount.get();
        info.writeCount = this._writeCounter.get();
        info.forcedCheckpointWriteCount = this._forcedCheckpointWriteCounter.get();
        info.forcedWriteCount = this._forcedWriteCounter.get();
        int validPages = 0;
        int readerClaimedPages = 0;
        int writerClaimedPages = 0;
        for (int index = 0; index < this._bufferCount; ++index) {
            Buffer buffer = this._buffers[index];
            int status = buffer.getStatus();
            if ((status & 0x20000) != 0) {
                ++validPages;
            }
            if ((status & 0x8000) != 0) {
                ++writerClaimedPages;
                continue;
            }
            if ((status & Short.MAX_VALUE) == 0) continue;
            ++readerClaimedPages;
        }
        info.validPageCount = validPages;
        info.readerClaimedPageCount = readerClaimedPages;
        info.writerClaimedPageCount = writerClaimedPages;
        info.earliestDirtyTimestamp = this.getEarliestDirtyTimestamp();
        info.updateAcquisitonTime();
    }

    int populateInfo(Management.BufferInfo[] array, int traveralType, int includeMask, int excludeMask) {
        int index = 0;
        switch (traveralType) {
            case 0: {
                for (int i = 0; i < this._bufferCount; ++i) {
                    Buffer buffer = this._buffers[i];
                    if (!this.selected(buffer, includeMask, excludeMask)) continue;
                    BufferPool.populateInfo1(array, index, buffer);
                    ++index;
                }
                break;
            }
            default: {
                index = -1;
            }
        }
        return index;
    }

    private static void populateInfo1(Management.BufferInfo[] array, int index, Buffer buffer) {
        if (index < array.length) {
            if (array[index] == null) {
                array[index] = new Management.BufferInfo();
            }
            buffer.populateInfo(array[index]);
        }
    }

    private boolean selected(Buffer buffer, int includeMask, int excludeMask) {
        return (includeMask == 0 || (buffer.getStatus() & includeMask) != 0) && (buffer.getStatus() & excludeMask) == 0;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public int getBufferCount() {
        return this._bufferCount;
    }

    public long getMissCounter() {
        return this._missCounter.get();
    }

    public long getHitCounter() {
        return this._hitCounter.get();
    }

    public long getNewCounter() {
        return this._newCounter.get();
    }

    public long getForcedWriteCounter() {
        return this._forcedWriteCounter.get();
    }

    public long getForcedCheckpointWriteCounter() {
        return this._forcedCheckpointWriteCounter.get();
    }

    public void resetCounters() {
        this._missCounter.set(0L);
        this._hitCounter.set(0L);
        this._newCounter.set(0L);
        this._evictCounter.set(0L);
    }

    int getMaxKeys() {
        return this._maxKeys;
    }

    private void bumpHitCounter() {
        this._hitCounter.incrementAndGet();
    }

    private void bumpMissCounter() {
        this._missCounter.incrementAndGet();
    }

    private void bumpNewCounter() {
        this._newCounter.incrementAndGet();
    }

    void bumpWriteCounter() {
        this._writeCounter.incrementAndGet();
    }

    void bumpForcedCheckpointWrites() {
        this._forcedCheckpointWriteCounter.incrementAndGet();
    }

    public double getHitRatio() {
        long hitCounter = this._hitCounter.get();
        long getCounter = hitCounter + this._missCounter.get() + this._newCounter.get();
        if (getCounter == 0L) {
            return 0.0;
        }
        return (double)hitCounter / (double)getCounter;
    }

    void incrementDirtyPageCount() {
        this._dirtyPageCount.incrementAndGet();
    }

    void decrementDirtyPageCount() {
        this._dirtyPageCount.decrementAndGet();
    }

    int getDirtyPageCount() {
        return this._dirtyPageCount.get();
    }

    boolean invalidate(Volume volume) throws PersistitException {
        float ratio = (float)volume.getStorage().getNextAvailablePage() / (float)this._bufferCount;
        if (ratio < 0.1f) {
            return this.invalidateSmallVolume(volume, false);
        }
        return this.invalidateLargeVolume(volume, false);
    }

    boolean evict(Volume volume) throws PersistitException {
        return this.invalidateSmallVolume(volume, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean invalidateSmallVolume(Volume volume, boolean mustWrite) throws PersistitException {
        boolean result = true;
        int markedAvailable = 0;
        for (long page = 1L; page < volume.getStorage().getNextAvailablePage(); ++page) {
            int hashIndex = this.hashIndex(volume, page);
            this._hashLocks[hashIndex % 4096].lock();
            try {
                for (Buffer buffer = this._hashTable[hashIndex]; buffer != null; buffer = buffer.getNext()) {
                    if (buffer.getVolume() != volume && volume != null || buffer.isFixed() || !buffer.isValid()) continue;
                    if (buffer.claim(true, 0L)) {
                        boolean invalidated = false;
                        try {
                            if ((buffer.getVolume() == volume || volume == null) && !buffer.isFixed() && buffer.isValid()) {
                                if (mustWrite && buffer.isDirty()) {
                                    buffer.writePage();
                                }
                                this.invalidate(buffer);
                                invalidated = true;
                            }
                        }
                        finally {
                            buffer.release();
                        }
                        if (!invalidated) continue;
                        int q = buffer.getIndex() / 64;
                        int p = buffer.getIndex() % 64;
                        long bits = this._availablePagesBits.get(q);
                        if (!this._availablePagesBits.compareAndSet(q, bits, bits | 1L << p)) continue;
                        ++markedAvailable;
                        continue;
                    }
                    result = false;
                }
                continue;
            }
            finally {
                this._hashLocks[hashIndex % 4096].unlock();
            }
        }
        if (markedAvailable > 0) {
            this._availablePages.set(true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean invalidateLargeVolume(Volume volume, boolean mustWrite) throws PersistitException {
        boolean result = true;
        int markedAvailable = 0;
        for (int index = 0; index < this._bufferCount; ++index) {
            Buffer buffer = this._buffers[index];
            if (buffer.getVolume() != volume && volume != null || buffer.isFixed() || !buffer.isValid()) continue;
            if (buffer.claim(true, 0L)) {
                boolean invalidated = false;
                try {
                    if ((buffer.getVolume() == volume || volume == null) && !buffer.isFixed() && buffer.isValid()) {
                        if (mustWrite && buffer.isDirty()) {
                            buffer.writePage();
                        }
                        this.invalidate(buffer);
                        invalidated = true;
                    }
                }
                finally {
                    buffer.release();
                }
                if (!invalidated) continue;
                int q = buffer.getIndex() / 64;
                int p = buffer.getIndex() % 64;
                long bits = this._availablePagesBits.get(q);
                if (!this._availablePagesBits.compareAndSet(q, bits, bits | 1L << p)) continue;
                ++markedAvailable;
                continue;
            }
            result = false;
        }
        if (markedAvailable > 0) {
            this._availablePages.set(true);
        }
        return result;
    }

    private void invalidate(Buffer buffer) {
        Debug.$assert0.t(buffer.isValid() && buffer.isOwnedAsWriterByMe());
        while (!this.detach(buffer)) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        buffer.clearValid();
        buffer.clearDirty();
        buffer.setPageAddressAndVolume(0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detach(Buffer buffer) {
        block8: {
            int hash = this.hashIndex(buffer.getVolume(), buffer.getPageAddress());
            if (!this._hashLocks[hash % 4096].tryLock()) {
                return false;
            }
            try {
                if (this._hashTable[hash] == buffer) {
                    this._hashTable[hash] = buffer.getNext();
                    break block8;
                }
                Buffer prev = this._hashTable[hash];
                Buffer next = prev.getNext();
                while (true) {
                    assert (next != null) : "Attempting to detach an unattached Buffer";
                    if (next == buffer) {
                        prev.setNext(next.getNext());
                        break;
                    }
                    prev = next;
                    next = prev.getNext();
                }
            }
            finally {
                this._hashLocks[hash % 4096].unlock();
            }
        }
        return true;
    }

    Buffer get(Volume vol, long page, boolean writer, boolean wantRead) throws PersistitException {
        return this.get(vol, page, writer, wantRead, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Buffer get(Volume vol, long page, boolean writer, boolean wantRead, long timeout) throws PersistitException {
        int hash = this.hashIndex(vol, page);
        Buffer buffer = null;
        while (true) {
            boolean mustClaim = false;
            this._hashLocks[hash % 4096].lock();
            try {
                for (buffer = this._hashTable[hash]; buffer != null; buffer = buffer.getNext()) {
                    Debug.$assert0.t(buffer.getNext() != buffer);
                    if (buffer.getPageAddress() != page || buffer.getVolume() != vol) continue;
                    if (buffer.claim(writer, 0L)) {
                        vol.getStatistics().bumpGetCounter();
                        this.bumpHitCounter();
                        assert (!buffer.isOwnedAsWriterByOther());
                        Buffer buffer2 = buffer;
                        return buffer2;
                    }
                    mustClaim = true;
                    break;
                }
                if (buffer == null) {
                    buffer = this.allocBuffer();
                    Debug.$assert1.t(!buffer.isDirty());
                    Debug.$assert0.t(buffer != this._hashTable[hash]);
                    Debug.$assert0.t(buffer.getNext() != buffer);
                    buffer.setPageAddressAndVolume(page, vol);
                    buffer.setNext(this._hashTable[hash]);
                    this._hashTable[hash] = buffer;
                    buffer.setValid();
                    if (vol.isTemporary() || vol.isLockVolume()) {
                        buffer.setTemporary();
                    } else {
                        buffer.clearTemporary();
                    }
                    Debug.$assert0.t(buffer.getNext() != buffer);
                }
            }
            finally {
                this._hashLocks[hash % 4096].unlock();
            }
            if (!mustClaim) break;
            boolean claimed = false;
            boolean same = true;
            long start = System.currentTimeMillis();
            while (same && !claimed && System.currentTimeMillis() - start < timeout) {
                claimed = buffer.claim(writer, 500L);
                same = buffer.isValid() && buffer.getPageAddress() == page && buffer.getVolume() == vol;
            }
            if (same) {
                if (claimed) {
                    vol.getStatistics().bumpGetCounter();
                    this.bumpHitCounter();
                    assert (!buffer.isOwnedAsWriterByOther());
                    return buffer;
                }
                throw new InUseException("Thread " + Thread.currentThread().getName() + " failed to acquire " + (writer ? "writer" : "reader") + " claim on " + buffer);
            }
            if (!claimed) continue;
            buffer.release();
        }
        if (wantRead) {
            boolean loaded = false;
            try {
                Debug.$assert0.t(buffer.getPageAddress() == page && buffer.getVolume() == vol && this.hashIndex(buffer.getVolume(), buffer.getPageAddress()) == hash);
                buffer.load(vol, page);
                loaded = true;
                vol.getStatistics().bumpGetCounter();
                this.bumpMissCounter();
            }
            finally {
                if (!loaded) {
                    this.invalidate(buffer);
                    buffer.release();
                }
            }
        } else {
            buffer.clear();
            buffer.init(0);
            this.bumpNewCounter();
        }
        if (!writer) {
            buffer.releaseWriterClaim();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer getBufferCopy(Volume vol, long page) throws InvalidPageAddressException, InvalidPageStructureException, VolumeClosedException, InUseException, PersistitIOException, PersistitInterruptedException {
        int hash = this.hashIndex(vol, page);
        Buffer buffer = null;
        this._hashLocks[hash % 4096].lock();
        try {
            for (buffer = this._hashTable[hash]; buffer != null; buffer = buffer.getNext()) {
                Debug.$assert0.t(buffer.getNext() != buffer);
                if (buffer.getPageAddress() != page || buffer.getVolume() != vol) continue;
                Debug.$assert0.t(buffer.isValid());
                Buffer buffer2 = new Buffer(buffer);
                return buffer2;
            }
        }
        finally {
            this._hashLocks[hash % 4096].unlock();
        }
        buffer = new Buffer(this._bufferSize, -1, this, this._persistit);
        boolean acquired = buffer.claim(true);
        assert (acquired) : "buffer not unavailable";
        buffer.load(vol, page);
        buffer.setValid();
        buffer.release();
        return buffer;
    }

    public Buffer getBufferCopy(int index) throws IllegalArgumentException {
        if (index < 0 || index >= this._bufferCount) {
            throw new IllegalArgumentException("Index " + index + " is out of range in " + this);
        }
        return new Buffer(this._buffers[index]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Buffer allocBuffer() throws PersistitException {
        if (this._availablePages.get()) {
            q = start = this._clock.get() / 64 * 64;
            do {
                if ((q += 64) >= this._bufferCount) {
                    q = 0;
                }
                if ((bits = this._availablePagesBits.get(q / 64)) == 0L) continue;
                for (p = 0; p < 64; ++p) {
                    if ((bits & 1L << p) == 0L || ((buffer = this._buffers[q + p]).getStatus() & 32767) != 0 || !buffer.claim(true, 0L)) continue;
                    if (!buffer.isValid() && this._availablePagesBits.compareAndSet(q / 64, bits = this._availablePagesBits.get(q / 64), bits & (1L << p ^ -1L))) {
                        buffer.clearDirty();
                        return buffer;
                    }
                    buffer.release();
                }
            } while (q != start);
            this._availablePages.set(false);
        }
        retry = 0;
        while (retry < this._bufferCount * 2) {
            clock = this._clock.get();
            if (!BufferPool.$assertionsDisabled && clock >= this._bufferCount) {
                throw new AssertionError();
            }
            if (!this._clock.compareAndSet(clock, (clock + 1) % this._bufferCount)) continue;
            buffer = this._buffers[clock];
            if (buffer.isTouched()) {
                buffer.clearTouched();
            } else if (!buffer.isFixed() && (buffer.getStatus() & 32767) == 0 && buffer.claim(true, 0L)) {
                if (buffer.isDirty()) {
                    if (!buffer.isValid()) {
                        buffer.clearDirty();
                        return buffer;
                    }
                    try {
                        buffer.writePage(false);
                        if (!this.detach(buffer)) ** GOTO lbl56
                        buffer.clearValid();
                        this._forcedWriteCounter.incrementAndGet();
                        this._evictCounter.incrementAndGet();
                        this._persistit.getIOMeter().chargeEvictPageFromPool(buffer.getVolume(), buffer.getPageAddress(), buffer.getBufferSize(), buffer.getIndex());
                    }
                    finally {
                        if (!buffer.isValid()) {
                            return buffer;
                        }
                        buffer.release();
                    }
                } else {
                    if (buffer.isValid() && this.detach(buffer)) {
                        buffer.clearValid();
                        this._evictCounter.incrementAndGet();
                        this._persistit.getIOMeter().chargeEvictPageFromPool(buffer.getVolume(), buffer.getPageAddress(), buffer.getBufferSize(), buffer.getIndex());
                    }
                    if (!buffer.isValid()) {
                        return buffer;
                    }
                    buffer.release();
                }
            }
lbl56:
            // 6 sources

            ++retry;
        }
        throw new IllegalStateException("No available Buffers");
    }

    public long getEarliestDirtyTimestamp() {
        return this._earliestDirtyTimestamp;
    }

    void setFlushTimestamp(long timestamp) {
        long current;
        while (timestamp > (current = this._flushTimestamp.get()) && !this._flushTimestamp.compareAndSet(current, timestamp)) {
        }
    }

    boolean shouldWritePages() {
        int cleanCount = this._bufferCount - this._dirtyPageCount.get();
        if (this.getEarliestDirtyTimestamp() < this._flushTimestamp.get()) {
            return true;
        }
        if (this.getEarliestDirtyTimestamp() <= this._persistit.getCurrentCheckpoint().getTimestamp()) {
            return true;
        }
        if (cleanCount < this._pageWriterTrancheSize * 2) {
            return true;
        }
        return cleanCount < this._bufferCount / 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDirtyBuffers(int[] priorities, BufferHolder[] selectedBuffers) throws PersistitException {
        int count = this.selectDirtyBuffers(priorities, selectedBuffers);
        if (count > 0) {
            Arrays.sort(selectedBuffers, 0, count);
            for (int index = 0; index < count; ++index) {
                BufferHolder holder = selectedBuffers[index];
                Buffer buffer = holder._buffer;
                if (!buffer.claim(true, 0L)) continue;
                try {
                    if (!holder.matches(buffer) || !buffer.isDirty() || !buffer.isValid()) continue;
                    buffer.writePage();
                    continue;
                }
                finally {
                    buffer.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int selectDirtyBuffers(int[] priorities, BufferHolder[] holders) throws PersistitException {
        long currentTimestamp;
        Debug.suspend();
        int count = 0;
        int clock = this._clock.get();
        long checkpointTimestamp = this._persistit.getCurrentCheckpoint().getTimestamp();
        long earliestDirtyTimestamp = currentTimestamp = this._persistit.getCurrentTimestamp();
        long flushTimestamp = this._flushTimestamp.get();
        boolean flushed = true;
        for (int index = clock; index < clock + this._bufferCount; ++index) {
            Buffer buffer = this._buffers[index % this._bufferCount];
            long timestamp = buffer.getTimestamp();
            if (!buffer.claim(false, 0L)) {
                if (timestamp < earliestDirtyTimestamp) {
                    earliestDirtyTimestamp = timestamp;
                }
                if (timestamp >= flushTimestamp) continue;
                flushed = false;
                continue;
            }
            try {
                int priority;
                if (!buffer.isDirty() || (priority = this.writePriority(buffer, clock, checkpointTimestamp, currentTimestamp)) <= 0) continue;
                count = this.addSelectedBufferByPriority(buffer, priority, priorities, holders, count);
                if (buffer.isTemporary()) continue;
                timestamp = buffer.getTimestamp();
                if (timestamp < earliestDirtyTimestamp) {
                    earliestDirtyTimestamp = timestamp;
                }
                if (timestamp > flushTimestamp) continue;
                flushed = false;
                continue;
            }
            finally {
                buffer.release();
            }
        }
        this._earliestDirtyTimestamp = earliestDirtyTimestamp;
        if (flushed) {
            this._flushTimestamp.compareAndSet(flushTimestamp, 0L);
        }
        return count;
    }

    int addSelectedBufferByPriority(Buffer buffer, int priority, int[] priorities, BufferHolder[] holders, int initialCount) {
        int count = initialCount;
        if (priority > 0) {
            if (count == 0 || priorities[count - 1] > priority) {
                if (count < priorities.length) {
                    priorities[count] = priority;
                    holders[count].set(buffer);
                    ++count;
                }
            } else {
                int where;
                for (where = count = Math.min(count, priorities.length - 1); where > 0 && priorities[where - 1] < priority; --where) {
                }
                int move = count - where;
                if (move > 0) {
                    BufferHolder lastHolder = holders[count];
                    System.arraycopy(priorities, where, priorities, where + 1, move);
                    System.arraycopy(holders, where, holders, where + 1, move);
                    holders[where] = lastHolder;
                }
                priorities[where] = priority;
                holders[where].set(buffer);
                ++count;
            }
        }
        return count;
    }

    int writePriority(Buffer buffer, int clock, long checkpointTimestamp, long currentTimestamp) {
        int status = buffer.getStatus();
        if ((status & 0x20000) == 0 || (status & 0x10000) == 0) {
            return 0;
        }
        int distance = (buffer.getIndex() - this._clock.get() + this._bufferCount) % this._bufferCount;
        int age = 0;
        if ((status & 0x8000000) != 0) {
            distance += this._bufferCount;
        }
        if (!buffer.isTemporary()) {
            long timestampThreshold = (currentTimestamp * 4L + checkpointTimestamp) / 4L;
            if (this._flushTimestamp.get() > timestampThreshold) {
                timestampThreshold = this._flushTimestamp.get();
            }
            if (buffer.getTimestamp() < timestampThreshold) {
                age = (int)Math.min(timestampThreshold - buffer.getTimestamp(), 0x3FFFFFFFL);
                distance = 0;
            }
        } else if (distance > this._bufferCount) {
            return 0;
        }
        return this._bufferCount * 2 - distance + age;
    }

    public String toString() {
        return "BufferPool[" + this._bufferCount + "@" + this._bufferSize + (this._closed.get() ? ":closed" : "") + "]";
    }

    String toString(int i, boolean detail) {
        if (detail) {
            return this._buffers[i].toStringDetail();
        }
        return this._buffers[i].toString();
    }

    void dump(DataOutputStream stream, ByteBuffer bb, boolean secure, boolean verbose) throws Exception {
        String toString = this.toString();
        if (verbose) {
            System.out.println(toString);
        }
        HashSet<Volume> identifiedVolumes = new HashSet<Volume>();
        for (Buffer buffer : this._buffers) {
            buffer.dump(bb, secure, verbose, identifiedVolumes);
            if (bb.remaining() >= this._bufferSize * 2) continue;
            bb.flip();
            stream.write(bb.array(), 0, bb.limit());
            bb.clear();
        }
        if (bb.remaining() > 0) {
            bb.flip();
            stream.write(bb.array(), 0, bb.limit());
            bb.clear();
        }
        stream.flush();
    }

    void recordBufferInventory(long timestamp) throws PersistitException {
        Exchange exchange = this.getBufferInventoryExchange();
        exchange.ignoreTransactions();
        try {
            int total = 0;
            exchange.clear().append(this._bufferSize).append(timestamp).append(Key.BEFORE);
            Value value = exchange.getValue();
            int clockValueBefore = this._clock.get();
            for (int index = 0; index < this._buffers.length; ++index) {
                Buffer buffer = this._buffers[index];
                long page1 = -1L;
                long page2 = -1L;
                Volume volume1 = null;
                Volume volume2 = null;
                if (buffer == null || !buffer.isValid()) continue;
                while (true) {
                    page1 = buffer.getPageAddress();
                    volume1 = buffer.getVolume();
                    page2 = buffer.getPageAddress();
                    volume2 = buffer.getVolume();
                    if (page1 == page2 && volume1 == volume2) break;
                    Util.spinSleep();
                }
                if (volume1 == null || volume1.isTemporary() || volume1.isLockVolume()) continue;
                value.clear().setStreamMode(true);
                value.put(volume1.getHandle());
                value.put(page1);
                exchange.to(index).store();
                ++total;
            }
            int clockValueAfter = this._clock.get();
            exchange.cut();
            value.clear().setStreamMode(true);
            value.put(this._bufferCount);
            value.put(total);
            value.put(clockValueBefore);
            value.put(clockValueAfter);
            value.put(System.currentTimeMillis());
            exchange.store();
            int count = 0;
            while (exchange.previous()) {
                if (++count <= 3) continue;
                exchange.remove(Key.GTEQ);
            }
        }
        catch (PersistitException e) {
            this._persistit.getLogBase().bufferInventoryException.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preloadBufferInventory() {
        ArrayList<JournalManager.PageNode> pageNodes;
        Value value;
        Exchange exchange;
        JournalManager jman;
        long reportTime;
        int total;
        int count;
        block11: {
            long startTime;
            count = 0;
            total = 0;
            reportTime = startTime = System.nanoTime();
            jman = this._persistit.getJournalManager();
            exchange = this.getBufferInventoryExchange();
            value = exchange.getValue();
            pageNodes = new ArrayList<JournalManager.PageNode>();
            boolean foundInventory = false;
            exchange.clear().append(this._bufferSize).append(Key.AFTER);
            while (exchange.previous()) {
                if (!exchange.getValue().isDefined()) continue;
                foundInventory = true;
                break;
            }
            if (foundInventory) break block11;
            long now = System.nanoTime();
            this._persistit.getLogBase().bufferInventoryProgress.log(count, total, (now - reportTime) / 1000000000L);
            return;
        }
        try {
            value.setStreamMode(true);
            value.getInt();
            total = value.getInt();
            value.getInt();
            value.getInt();
            long systemTime = value.getLong();
            this._persistit.getLogBase().bufferInventoryLoad.log(systemTime);
            exchange.append(Key.BEFORE);
            while (exchange.next()) {
                value.setStreamMode(true);
                int volumeHandle = value.getInt();
                long pageAddress = value.getLong();
                JournalManager.PageNode pn = new JournalManager.PageNode(volumeHandle, pageAddress);
                pageNodes.add(pn);
            }
            Collections.sort(pageNodes, JournalManager.PageNode.READ_COMPARATOR);
            for (JournalManager.PageNode pn : pageNodes) {
                Volume vol = jman.volumeForHandle(pn.getVolumeHandle());
                if (vol == null) continue;
                try {
                    Buffer buff = this.get(vol, pn.getPageAddress(), false, true);
                    buff.release();
                    ++count;
                    long now = System.nanoTime();
                    if (now - reportTime >= 60000000000L) {
                        this._persistit.getLogBase().bufferInventoryProgress.log(count, total, (now - reportTime) / 1000000000L);
                        reportTime = now;
                    }
                    if (count < this._bufferCount) continue;
                    break;
                }
                catch (PersistitException e) {
                }
            }
        }
        catch (PersistitException e) {
            try {
                this._persistit.getLogBase().bufferInventoryException.log(e);
            }
            catch (Throwable throwable) {
                long now = System.nanoTime();
                this._persistit.getLogBase().bufferInventoryProgress.log(count, total, (now - reportTime) / 1000000000L);
                throw throwable;
            }
            long now = System.nanoTime();
            this._persistit.getLogBase().bufferInventoryProgress.log(count, total, (now - reportTime) / 1000000000L);
        }
        long now = System.nanoTime();
        this._persistit.getLogBase().bufferInventoryProgress.log(count, total, (now - reportTime) / 1000000000L);
    }

    private Exchange getBufferInventoryExchange() throws PersistitException {
        Volume sysvol = this._persistit.getSystemVolume();
        return this._persistit.getExchange(sysvol, INVENTORY_TREE_NAME, true);
    }

    class PageWriter
    extends IOTaskRunnable {
        int[] _priorities;
        BufferHolder[] _selectedBuffers;

        PageWriter() {
            super(BufferPool.this._persistit);
            this._priorities = new int[0];
            this._selectedBuffers = new BufferHolder[0];
        }

        void start() {
            this.start("PAGE_WRITER:" + BufferPool.this._bufferSize, BufferPool.this._writerPollInterval);
        }

        @Override
        public void runTask() throws PersistitException {
            int size = BufferPool.this._pageWriterTrancheSize;
            if (size != this._priorities.length) {
                this._priorities = new int[size];
                this._selectedBuffers = new BufferHolder[size];
                for (int index = 0; index < size; ++index) {
                    this._selectedBuffers[index] = new BufferHolder();
                }
            }
            if (BufferPool.this.shouldWritePages()) {
                BufferPool.this.writeDirtyBuffers(this._priorities, this._selectedBuffers);
            }
        }

        @Override
        protected boolean shouldStop() {
            return BufferPool.this._closed.get() && !BufferPool.this.isFlushing();
        }

        @Override
        protected long pollInterval() {
            return BufferPool.this.isFlushing() ? 0L : BufferPool.this._writerPollInterval;
        }
    }

    static class BufferHolder
    implements Comparable<BufferHolder> {
        long _page;
        long _volumeId;
        Buffer _buffer;

        BufferHolder() {
        }

        private void set(Buffer buffer) {
            this._page = buffer.getPageAddress();
            this._volumeId = buffer.getVolumeId();
            this._buffer = buffer;
        }

        long getPage() {
            return this._page;
        }

        long getVolumeId() {
            return this._volumeId;
        }

        Buffer getBuffer() {
            return this._buffer;
        }

        private boolean matches(Buffer buffer) {
            return buffer == this._buffer && buffer.getPageAddress() == this._page && buffer.getVolumeId() == this._volumeId;
        }

        @Override
        public int compareTo(BufferHolder buffer) {
            return this._volumeId > buffer._volumeId ? 1 : (this._volumeId < buffer._volumeId ? -1 : (this._page > buffer._page ? 1 : (this._page < buffer._page ? -1 : 0)));
        }

        public String toString() {
            Buffer buffer = this._buffer;
            return buffer == null ? null : buffer.toString();
        }
    }

    static enum Result {
        WRITTEN,
        UNAVAILABLE,
        ERROR;

    }
}

