/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.KeyState;
import com.persistit.Persistit;
import com.persistit.encoding.CoderContext;
import com.persistit.encoding.KeyCoder;
import com.persistit.encoding.KeyDisplayer;
import com.persistit.encoding.KeyRenderer;
import com.persistit.exception.ConversionException;
import com.persistit.exception.InvalidKeyException;
import com.persistit.exception.KeyTooLongException;
import com.persistit.exception.MissingKeySegmentException;
import com.persistit.util.Util;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Key
implements Comparable<Object> {
    public static final Direction GT = Direction.GT;
    public static final Direction GTEQ = Direction.GTEQ;
    public static final Direction EQ = Direction.EQ;
    public static final Direction LTEQ = Direction.LTEQ;
    public static final Direction LT = Direction.LT;
    public static final Key LEFT_GUARD_KEY = new Key(null, 1);
    public static final Key RIGHT_GUARD_KEY = new Key(null, 1);
    public static final int MAX_KEY_LENGTH = 2047;
    public static final int MAX_KEY_LENGTH_UPPER_BOUND = 0x400000;
    public static final EdgeValue BEFORE = new EdgeValue(false);
    public static final EdgeValue AFTER = new EdgeValue(true);
    public static final SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");
    public static final String PREFIX_BOOLEAN = "(boolean)";
    public static final String PREFIX_BYTE = "(byte)";
    public static final String PREFIX_SHORT = "(short)";
    public static final String PREFIX_CHAR = "(char)";
    public static final String PREFIX_INT = "(int)";
    public static final String PREFIX_LONG = "(long)";
    public static final String PREFIX_FLOAT = "(float)";
    public static final String PREFIX_DOUBLE = "(double)";
    public static final String PREFIX_STRING = "(java.lang.String)";
    public static final String PREFIX_STRING0 = "(String)";
    public static final String PREFIX_BIG_INTEGER = "(java.math.BigInteger)";
    public static final String PREFIX_BIG_INTEGER0 = "(BigInteger)";
    public static final String PREFIX_BIG_DECIMAL = "(java.math.BigDecimal)";
    public static final String PREFIX_BIG_DECIMAL0 = "(BigDecimal)";
    public static final String PREFIX_DATE = "(java.util.Date)";
    public static final String PREFIX_DATE0 = "(Date)";
    public static final String PREFIX_BYTE_ARRAY = "(byte[])";
    public static final Direction[] DIRECTIONS = new Direction[]{EQ, LT, LTEQ, GT, GTEQ};
    private static final int TYPE_LEFT_EDGE = 0;
    private static final int TYPE_BEFORE = 1;
    private static final int TYPE_NULL = 2;
    private static final int TYPE_BOOLEAN_FALSE = 3;
    private static final int TYPE_BOOLEAN_TRUE = 4;
    private static final int TYPE_BYTE = 6;
    private static final int TYPE_UBYTE = 10;
    private static final int TYPE_SHORT = 15;
    private static final int TYPE_USHORT = 22;
    private static final int TYPE_CHAR = 26;
    private static final int TYPE_INT = 31;
    private static final int TYPE_UINT = 43;
    private static final int TYPE_LONG = 55;
    private static final int TYPE_ULONG = 76;
    private static final int TYPE_DECIMAL = 97;
    private static final int TYPE_FLOAT = 98;
    private static final int TYPE_DOUBLE = 99;
    private static final int TYPE_BIG_INTEGER = 110;
    private static final int TYPE_BIG_DECIMAL = 111;
    private static final int TYPE_BYTE_ARRAY = 126;
    private static final int TYPE_CHAR_ARRAY = 127;
    static final int TYPE_STRING = 128;
    private static final int TYPE_DATE = 129;
    private static final int TYPE_CODER_MIN = 192;
    private static final int TYPE_CODER1 = 192;
    private static final int TYPE_CODER2 = 200;
    private static final int TYPE_CODER3 = 208;
    private static final int TYPE_CODER6 = 216;
    private static final int TYPE_CODER_MAX = 219;
    private static final int TYPE_AFTER = 254;
    private static final int TYPE_RIGHT_EDGE = 255;
    private static final int EWIDTH_BYTE = 1;
    private static final int EWIDTH_SHORT = 3;
    private static final int EWIDTH_CHAR = 3;
    private static final int EWIDTH_INT = 5;
    private static final int EWIDTH_UINT = 6;
    private static final int EWIDTH_LONG = 9;
    private static final int EWIDTH_ULONG = 10;
    private static final Class<?>[] CLASS_PER_TYPE = new Class[]{null, EdgeValue.class, Object.class, Boolean.class, Boolean.class, null, Byte.class, Byte.class, Byte.class, null, null, null, null, null, null, Short.class, Short.class, Short.class, Short.class, Short.class, Short.class, Short.class, null, null, null, null, Character.class, Character.class, Character.class, Character.class, null, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, null, null, null, null, null, null, null, null, null, null, null, null, null, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Float.class, Double.class, null, null, null, null, null, null, null, null, null, null, BigInteger.class, BigDecimal.class, null, null, null, null, null, null, null, null, null, null, null, null, null, null, byte[].class, char[].class, String.class, Date.class, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, EdgeValue.class, null};
    private static final BigInteger BIG_INT_DIVISOR = BigInteger.valueOf(10000000000000000L);
    private byte[] _bytes;
    private int _size;
    private int _index;
    private int _depth;
    private int _maxSize;
    private long _generation;
    private boolean _inKeyCoder;
    private Persistit _persistit;

    public void copyTo(Key key) {
        if (key == this) {
            return;
        }
        if (key._maxSize < this._maxSize) {
            key._bytes = new byte[this._maxSize + 1];
            key._maxSize = this._maxSize;
        }
        if (this._size > 0) {
            System.arraycopy(this._bytes, 0, key._bytes, 0, this._size);
        }
        key._size = this._size;
        key._index = this._index;
        key._depth = this._depth;
        key._persistit = this._persistit;
        key.bumpGeneration();
    }

    public Key(Persistit persistit) {
        this(persistit, 2047);
    }

    public Key(Persistit persistit, int maxLength) {
        this._persistit = persistit;
        if (maxLength <= 0) {
            throw new IllegalArgumentException("Key length must be positive");
        }
        if (maxLength > 2047) {
            throw new IllegalArgumentException("Key length must be less than 2047");
        }
        this._maxSize = maxLength;
        this._bytes = new byte[maxLength + 1];
        this._size = 0;
        this._depth = 0;
    }

    Key(Persistit persistit, KeyState keyState) {
        this(persistit, keyState.getBytes().length);
        keyState.copyTo(this);
    }

    public Key(Key source) {
        source.copyTo(this);
    }

    public int getMaximumSize() {
        return this._maxSize;
    }

    public byte[] getEncodedBytes() {
        return this._bytes;
    }

    public int getEncodedSize() {
        return this._size;
    }

    public void setEncodedSize(int size) {
        this.notLeftOrRightGuard();
        if (size < 0 || size > this._maxSize) {
            throw new IllegalArgumentException("Invalid size=" + size);
        }
        this._size = size;
        this._depth = -1;
        this._index = 0;
        this.bumpGeneration();
    }

    public int getDepth() {
        if (this._depth == -1) {
            this.recomputeCurrentDepth();
        }
        return this._depth;
    }

    public Key setIndex(int index) {
        this.notLeftOrRightGuard();
        if (index < 0 || index > this._size) {
            throw new IllegalArgumentException("index=" + index + " _size=" + this._size);
        }
        this._index = index;
        return this;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int index = 0; index < this._size; ++index) {
            hashCode = hashCode * 17 ^ this._bytes[index] & 0xFF;
        }
        return hashCode & Integer.MAX_VALUE;
    }

    public boolean equals(Object target) {
        if (target instanceof Key) {
            return this.compareTo(target) == 0;
        }
        if (target instanceof KeyState) {
            return ((KeyState)target).equals(this);
        }
        return false;
    }

    @Override
    public int compareTo(Object target) {
        Key key2 = (Key)target;
        if (key2 == this) {
            return 0;
        }
        int size1 = this._size;
        int size2 = key2.getEncodedSize();
        byte[] bytes1 = this._bytes;
        byte[] bytes2 = key2.getEncodedBytes();
        int size = size1;
        if (size2 < size1) {
            size = size2;
        }
        for (int i = 0; i < size; ++i) {
            int b1 = bytes1[i] & 0xFF;
            int b2 = bytes2[i] & 0xFF;
            if (b1 == b2) continue;
            return b1 - b2;
        }
        if (size1 > size) {
            return Integer.MAX_VALUE;
        }
        if (size2 > size1) {
            return Integer.MIN_VALUE;
        }
        return 0;
    }

    public int compareKeyFragment(Key key, int fragmentStart, int fragmentSize) {
        if (key == this) {
            return 0;
        }
        int size1 = this._size;
        int size2 = key.getEncodedSize();
        byte[] bytes1 = this.getEncodedBytes();
        byte[] bytes2 = key.getEncodedBytes();
        int size = size1;
        if (size2 < size) {
            size = size2;
        }
        if (size > fragmentSize + fragmentStart) {
            size = fragmentSize + fragmentStart;
        }
        for (int i = fragmentStart; i < size; ++i) {
            int b1 = bytes1[i] & 0xFF;
            int b2 = bytes2[i] & 0xFF;
            if (b1 == b2) continue;
            return b1 - b2;
        }
        if (size == fragmentSize + fragmentStart) {
            return 0;
        }
        if (size1 > size) {
            return Integer.MAX_VALUE;
        }
        if (size2 > size) {
            return Integer.MIN_VALUE;
        }
        return 0;
    }

    public int compareKeySegment(Key key) {
        if (key == this) {
            return 0;
        }
        byte[] bytes1 = this.getEncodedBytes();
        byte[] bytes2 = key.getEncodedBytes();
        int index1 = this.getIndex();
        int index2 = key.getIndex();
        int count1 = this.getEncodedSize() - this.getIndex();
        int count2 = key.getEncodedSize() - key.getIndex();
        int count = Math.min(count1, count2);
        for (int i = 0; i < count; ++i) {
            int b1 = bytes1[i + index1] & 0xFF;
            int b2 = bytes2[i + index2] & 0xFF;
            if (b1 != b2) {
                return b1 - b2;
            }
            if (b1 != 0) continue;
            return 0;
        }
        return count1 - count2;
    }

    public int firstUniqueByteIndex(Key key) {
        int end = this._size;
        if (end > key._size) {
            end = key._size;
        }
        for (int index = 0; index < end; ++index) {
            if (key._bytes[index] == this._bytes[index]) continue;
            return index;
        }
        return end;
    }

    public int firstUniqueSegmentDepth(Key key) {
        int depth = 0;
        int end = this._size;
        if (end > key._size) {
            end = key._size;
        }
        for (int index = 0; index < end && key._bytes[index] == this._bytes[index]; ++index) {
            if (key._bytes[index] != 0) continue;
            ++depth;
        }
        return depth;
    }

    public Key clear() {
        this._size = 0;
        this._depth = 0;
        this._index = 0;
        this.bumpGeneration();
        return this;
    }

    public void setMaximumSize(int size) {
        this.clear();
        if (size <= 0) {
            throw new IllegalArgumentException("Key length must be positive:" + size);
        }
        if (size > 0x400000) {
            throw new IllegalArgumentException("Key length must be less than 4194304: " + size);
        }
        this._bytes = new byte[size + 1];
        this._maxSize = size;
    }

    void clear(boolean secure) {
        if (secure) {
            Util.clearBytes(this._bytes, 0, this._bytes.length);
        }
        this.clear();
    }

    public Key setDepth(int depth) {
        if (depth == 0) {
            return this.clear();
        }
        this.indexTo(depth);
        this._size = this._index;
        this._index = 0;
        this._depth = -1;
        this.bumpGeneration();
        return this;
    }

    public Key reset() {
        this._index = 0;
        return this;
    }

    public Key indexTo(int depth) {
        int index = 0;
        if (depth < 0) {
            index = -1;
            for (int i = 0; i > depth && (index = this.previousElementIndex(index)) != -1; --i) {
            }
            this._index = index == -1 ? 0 : index;
        } else if (depth > 0) {
            for (int i = 0; i < depth && index != -1; ++i) {
                index = this.nextElementIndex(index);
            }
            this._index = index == -1 ? this._size : index;
        } else {
            this._index = 0;
        }
        return this;
    }

    public int getIndex() {
        return this._index;
    }

    public Key cut() {
        return this.cut(1);
    }

    public Key cut(int count) {
        int index = this._size;
        for (int i = 0; i < count && index > 0; ++i) {
            if ((index = this.previousElementIndex(index)) != -1) continue;
            throw new IllegalArgumentException("Attempting to remove missing elements");
        }
        if (index <= 0) {
            this.clear();
        } else {
            this._size = index;
            if (this._depth == -1) {
                this.recomputeCurrentDepth();
            } else {
                this._depth -= count;
            }
        }
        this.bumpGeneration();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this._size == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        int index = this._index;
        this._index = 0;
        byte save = 0;
        Nudged nudged = Nudged.NO;
        if (this._size >= 2) {
            byte z0 = this._bytes[this._size - 2];
            byte z1 = this._bytes[this._size - 1];
            if (z0 == 0 && z1 == 0) {
                nudged = Nudged.DOWN;
                --this._size;
            } else if (z0 != 0 && z1 == 1) {
                nudged = Nudged.RIGHT;
                this._bytes[this._size - 1] = 0;
            } else if (z0 != 0 && z1 != 0 && this._size < this._maxSize) {
                nudged = Nudged.LEFT;
                save = this._bytes[this._size];
                this._bytes[this._size] = 0;
                ++this._size;
            }
        }
        try {
            int depth22 = 0;
            while (this._index < this._size) {
                if (depth22 > 0) {
                    Util.append((Appendable)sb, ",");
                }
                this.decodeDisplayable(true, sb, null);
                ++depth22;
            }
            Util.append((Appendable)sb, "}");
            switch (nudged) {
                case LEFT: {
                    Util.append((Appendable)sb, '-');
                    break;
                }
                case RIGHT: {
                    Util.append((Appendable)sb, '+');
                    break;
                }
                case DOWN: {
                    Util.append((Appendable)sb, "*");
                    break;
                }
            }
            String depth22 = sb.toString();
            return depth22;
        }
        catch (Exception e) {
            String string = e + "(size=" + this._size + ") " + Util.hexDump(this._bytes, 0, this._size);
            return string;
        }
        finally {
            switch (nudged) {
                case LEFT: {
                    --this._size;
                    this._bytes[this._size] = save;
                    break;
                }
                case RIGHT: {
                    this._bytes[this._size - 1] = 1;
                    break;
                }
                case DOWN: {
                    ++this._size;
                    break;
                }
            }
            this._index = index;
        }
    }

    public Key append(boolean v) {
        int save = this._size;
        try {
            this.testValidForAppend();
            int size = this._size;
            this._bytes[size++] = v ? 4 : 3;
            return this.endSegment(size);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    public Key append(byte v) {
        int save = this._size;
        try {
            this.testValidForAppend();
            int size = this._size;
            if (v > 0) {
                this._bytes[size++] = 8;
                this._bytes[size++] = (byte)(0x80 | v);
            } else if (v < 0) {
                this._bytes[size++] = 6;
                this._bytes[size++] = (byte)(0x80 | v);
            } else {
                this._bytes[size++] = 7;
            }
            return this.endSegment(size);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    public Key append(short v) {
        int save = this._size;
        try {
            this.testValidForAppend();
            int size = this._size;
            if (v >= 0) {
                int scale = 3;
                if (v > 16383) {
                    scale = 0;
                } else if (v > 127) {
                    scale = 1;
                } else if (v > 0) {
                    scale = 2;
                }
                this._bytes[size++] = (byte)(21 - scale);
                switch (scale) {
                    case 0: {
                        this._bytes[size++] = (byte)(0x80 | v >>> 14);
                    }
                    case 1: {
                        this._bytes[size++] = (byte)(0x80 | v >>> 7);
                    }
                    case 2: {
                        this._bytes[size++] = (byte)(0x80 | v);
                    }
                }
            } else {
                int scale = 2;
                if (v < -16383) {
                    scale = 0;
                } else if (v < -127) {
                    scale = 1;
                }
                this._bytes[size++] = (byte)(15 + scale);
                switch (scale) {
                    case 0: {
                        this._bytes[size++] = (byte)(0x80 | v >>> 14);
                    }
                    case 1: {
                        this._bytes[size++] = (byte)(0x80 | v >>> 7);
                    }
                    case 2: {
                        this._bytes[size++] = (byte)(0x80 | v);
                    }
                }
            }
            return this.endSegment(size);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    public Key append(char v) {
        int save = this._size;
        try {
            this.testValidForAppend();
            int size = this._size;
            int scale = 3;
            if (v > '\u3fff') {
                scale = 0;
            } else if (v > '\u007f') {
                scale = 1;
            } else if (v > '\u0000') {
                scale = 2;
            }
            this._bytes[size++] = (byte)(29 - scale);
            switch (scale) {
                case 0: {
                    this._bytes[size++] = (byte)(0x80 | v >>> 14);
                }
                case 1: {
                    this._bytes[size++] = (byte)(0x80 | v >>> 7);
                }
                case 2: {
                    this._bytes[size++] = (byte)(0x80 | v);
                }
            }
            return this.endSegment(size);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    public Key append(int v) {
        int save = this._size;
        try {
            this.testValidForAppend();
            int size = this.appendIntInternal(v);
            return this.endSegment(size);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    private int appendIntInternal(int v) {
        int size = this._size;
        if (v >= 0) {
            int scale = v == 0 ? 5 : (v < 128 ? 4 : (v < 16384 ? 3 : (v < 0x200000 ? 2 : (v < 0x10000000 ? 1 : 0))));
            this._bytes[size++] = (byte)(41 - scale);
            switch (scale) {
                case 0: {
                    this._bytes[size++] = (byte)(0x80 | v >>> 28);
                }
                case 1: {
                    this._bytes[size++] = (byte)(0x80 | v >>> 21);
                }
                case 2: {
                    this._bytes[size++] = (byte)(0x80 | v >>> 14);
                }
                case 3: {
                    this._bytes[size++] = (byte)(0x80 | v >>> 7);
                }
                case 4: {
                    this._bytes[size++] = (byte)(0x80 | v);
                }
            }
        } else {
            int scale = v < -268435455 ? 0 : (v < -2097151 ? 1 : (v < -16383 ? 2 : (v < -127 ? 3 : 4)));
            this._bytes[size++] = (byte)(31 + scale);
            switch (scale) {
                case 0: {
                    this._bytes[size++] = (byte)(0x80 | v >>> 28);
                }
                case 1: {
                    this._bytes[size++] = (byte)(0x80 | v >>> 21);
                }
                case 2: {
                    this._bytes[size++] = (byte)(0x80 | v >>> 14);
                }
                case 3: {
                    this._bytes[size++] = (byte)(0x80 | v >>> 7);
                }
                case 4: {
                    this._bytes[size++] = (byte)(0x80 | v);
                }
            }
        }
        return size;
    }

    public Key append(long v) {
        int save = this._size;
        try {
            this.testValidForAppend();
            int size = this.appendLongInternal(v);
            return this.endSegment(size);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    private int appendLongInternal(long v) {
        int size = this._size;
        if (v >= 0L) {
            int scale = 9;
            if (v > 0xFFFFFFFFFFFFFFL) {
                scale = 0;
            } else if (v > 0x1FFFFFFFFFFFFL) {
                scale = 1;
            } else if (v > 0x3FFFFFFFFFFL) {
                scale = 2;
            } else if (v > 0x7FFFFFFFFL) {
                scale = 3;
            } else if (v > 0xFFFFFFFL) {
                scale = 4;
            } else if (v > 0x1FFFFFL) {
                scale = 5;
            } else if (v > 16383L) {
                scale = 6;
            } else if (v > 127L) {
                scale = 7;
            } else if (v > 0L) {
                scale = 8;
            }
            this._bytes[size++] = (byte)(73 - scale);
            switch (scale) {
                case 0: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 56);
                }
                case 1: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 49);
                }
                case 2: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 42);
                }
                case 3: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 35);
                }
                case 4: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 28);
                }
                case 5: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 21);
                }
                case 6: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 14);
                }
                case 7: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 7);
                }
                case 8: {
                    this._bytes[size++] = (byte)(0x80L | v);
                }
            }
        } else {
            int scale = 8;
            if (v < -72057594037927935L) {
                scale = 0;
            } else if (v < -562949953421311L) {
                scale = 1;
            } else if (v < -4398046511103L) {
                scale = 2;
            } else if (v < -34359738367L) {
                scale = 3;
            } else if (v < -268435455L) {
                scale = 4;
            } else if (v < -2097151L) {
                scale = 5;
            } else if (v < -16383L) {
                scale = 6;
            } else if (v < -127L) {
                scale = 7;
            }
            this._bytes[size++] = (byte)(55 + scale);
            switch (scale) {
                case 0: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 56);
                }
                case 1: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 49);
                }
                case 2: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 42);
                }
                case 3: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 35);
                }
                case 4: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 28);
                }
                case 5: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 21);
                }
                case 6: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 14);
                }
                case 7: {
                    this._bytes[size++] = (byte)(0x80L | v >>> 7);
                }
                case 8: {
                    this._bytes[size++] = (byte)(0x80L | v);
                }
            }
        }
        return size;
    }

    public Key append(float v) {
        int save = this._size;
        try {
            this.testValidForAppend();
            int bits = Float.floatToIntBits(v);
            int size = this._size;
            this._bytes[size++] = 98;
            bits = bits < 0 ? (bits ^= 0xFFFFFFFF) : (bits ^= Integer.MIN_VALUE);
            while (bits != 0) {
                this._bytes[size++] = (byte)(0x80 | bits >> 25);
                bits <<= 7;
            }
            return this.endSegment(size);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    public Key append(double v) {
        int save = this._size;
        try {
            this.testValidForAppend();
            long bits = Double.doubleToLongBits(v);
            int size = this._size;
            this._bytes[size++] = 99;
            bits = bits < 0L ? (bits ^= 0xFFFFFFFFFFFFFFFFL) : (bits ^= Long.MIN_VALUE);
            while (bits != 0L) {
                this._bytes[size++] = (byte)(0x80L | bits >> 57);
                bits <<= 7;
            }
            return this.endSegment(size);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    public Key append(Object object) {
        return this.append(object, null);
    }

    public Key append(Object object, CoderContext context) {
        this.testValidForAppend();
        if (object == null) {
            return this.appendNull();
        }
        if (object == BEFORE) {
            return this.appendBefore();
        }
        if (object == AFTER) {
            return this.appendAfter();
        }
        Class<?> cl = object.getClass();
        if (CharSequence.class.isAssignableFrom(cl)) {
            return this.appendString((CharSequence)object, context);
        }
        if (cl == Boolean.class) {
            return this.append((Boolean)object);
        }
        if (cl == Byte.class) {
            return this.append((Byte)object);
        }
        if (cl == Short.class) {
            return this.append((Short)object);
        }
        if (cl == Character.class) {
            return this.append(((Character)object).charValue());
        }
        if (cl == Integer.class) {
            return this.append((Integer)object);
        }
        if (cl == Long.class) {
            return this.append((Long)object);
        }
        if (cl == Float.class) {
            return this.append(((Float)object).floatValue());
        }
        if (cl == Double.class) {
            return this.append((Double)object);
        }
        if (cl == byte[].class) {
            return this.appendByteArray((byte[])object, 0, ((byte[])object).length);
        }
        if (cl == Date.class) {
            return this.appendDate((Date)object);
        }
        if (cl == BigInteger.class) {
            return this.appendBigInteger((BigInteger)object);
        }
        if (cl == BigDecimal.class) {
            return this.appendBigDecimal((BigDecimal)object);
        }
        KeyCoder coder = this._persistit.lookupKeyCoder(cl);
        if (coder != null) {
            return this.appendByKeyCoder(object, cl, coder, context);
        }
        throw new ConversionException("Object class " + object.getClass().getName() + " can't be used in a Key");
    }

    public Key appendKeySegment(Key key) {
        int save = this._size;
        try {
            int length = 0;
            for (int index = key.getIndex(); index < key.getEncodedSize(); ++index) {
                ++length;
                if (key.getEncodedBytes()[index] != 0) continue;
                --length;
                break;
            }
            System.arraycopy(key.getEncodedBytes(), key.getIndex(), this._bytes, this._size, length);
            return this.endSegment(this._size + length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    public Key to(boolean v) {
        this.cut();
        return this.append(v);
    }

    public Key to(byte v) {
        this.cut();
        return this.append(v);
    }

    public Key to(short v) {
        this.cut();
        return this.append(v);
    }

    public Key to(char v) {
        this.cut();
        return this.append(v);
    }

    public Key to(int v) {
        this.cut();
        return this.append(v);
    }

    public Key to(long v) {
        this.cut();
        return this.append(v);
    }

    public Key to(float v) {
        this.cut();
        return this.append(v);
    }

    public Key to(double v) {
        this.cut();
        return this.append(v);
    }

    public Key to(Object v) {
        this.cut();
        return this.append(v);
    }

    public boolean decodeBoolean() {
        boolean v;
        int type = this.getTypeCode();
        if (type == 3) {
            v = false;
        } else if (type == 4) {
            v = true;
        } else {
            throw new ConversionException("Invalid boolean type " + type);
        }
        this._index = this.decodeEnd(this._index + 1);
        return v;
    }

    public byte decodeByte() {
        int type = this.getTypeCode();
        if (type >= 6 && type <= 8) {
            return (byte)this.decodeInt();
        }
        throw new ConversionException("Invalid byte type " + type);
    }

    public short decodeShort() {
        int type = this.getTypeCode();
        if (type >= 6 && type <= 21) {
            return (short)this.decodeInt();
        }
        throw new ConversionException("Invalid short type " + type);
    }

    public char decodeChar() {
        int type = this.getTypeCode();
        if (type >= 26 && type <= 29) {
            return (char)this.decodeInt();
        }
        throw new ConversionException("Invalid char type " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decodeInt() {
        int index = this._index;
        try {
            int result = this.decodeIntInternal();
            index = this.decodeEnd(this._index);
            int n = result;
            return n;
        }
        finally {
            this._index = index;
        }
    }

    private int decodeIntInternal() {
        int type = this.getTypeCode();
        int index = this._index + 1;
        int result = 0;
        switch (type) {
            case 6: {
                result = ~this._bytes[index++] & 0x7F;
                result ^= 0xFFFFFFFF;
                break;
            }
            case 8: {
                result = this._bytes[index++] & 0x7F;
            }
            case 7: {
                break;
            }
            case 15: {
                result |= (~this._bytes[index++] & 0x7F) << 14;
            }
            case 16: {
                result |= (~this._bytes[index++] & 0x7F) << 7;
            }
            case 17: {
                result |= ~this._bytes[index++] & 0x7F;
                result ^= 0xFFFFFFFF;
                break;
            }
            case 21: {
                result |= (this._bytes[index++] & 0x7F) << 14;
            }
            case 20: {
                result |= (this._bytes[index++] & 0x7F) << 7;
            }
            case 19: {
                result |= this._bytes[index++] & 0x7F;
            }
            case 18: {
                break;
            }
            case 29: {
                result |= (this._bytes[index++] & 0x7F) << 14;
            }
            case 28: {
                result |= (this._bytes[index++] & 0x7F) << 7;
            }
            case 27: {
                result |= this._bytes[index++] & 0x7F;
            }
            case 26: {
                break;
            }
            case 31: {
                result |= (~this._bytes[index++] & 0x7F) << 28;
            }
            case 32: {
                result |= (~this._bytes[index++] & 0x7F) << 21;
            }
            case 33: {
                result |= (~this._bytes[index++] & 0x7F) << 14;
            }
            case 34: {
                result |= (~this._bytes[index++] & 0x7F) << 7;
            }
            case 35: {
                result |= ~this._bytes[index++] & 0x7F;
                result ^= 0xFFFFFFFF;
                break;
            }
            case 41: {
                result |= (this._bytes[index++] & 0x7F) << 28;
            }
            case 40: {
                result |= (this._bytes[index++] & 0x7F) << 21;
            }
            case 39: {
                result |= (this._bytes[index++] & 0x7F) << 14;
            }
            case 38: {
                result |= (this._bytes[index++] & 0x7F) << 7;
            }
            case 37: {
                result |= this._bytes[index++] & 0x7F;
            }
            case 36: {
                break;
            }
            default: {
                throw new ConversionException("Invalid integer type " + type);
            }
        }
        this._index = index;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decodeLong() {
        int index = this._index;
        try {
            long result = this.decodeLongInternal();
            index = this.decodeEnd(this._index);
            long l = result;
            return l;
        }
        finally {
            this._index = index;
        }
    }

    private long decodeLongInternal() {
        int type = this.getTypeCode();
        int index = this._index + 1;
        if (type >= 6 && type < 55) {
            return this.decodeIntInternal();
        }
        long result = 0L;
        switch (type) {
            case 55: {
                result |= ((long)(~this._bytes[index++]) & 0x7FL) << 56;
            }
            case 56: {
                result |= ((long)(~this._bytes[index++]) & 0x7FL) << 49;
            }
            case 57: {
                result |= ((long)(~this._bytes[index++]) & 0x7FL) << 42;
            }
            case 58: {
                result |= ((long)(~this._bytes[index++]) & 0x7FL) << 35;
            }
            case 59: {
                result |= ((long)(~this._bytes[index++]) & 0x7FL) << 28;
            }
            case 60: {
                result |= ((long)(~this._bytes[index++]) & 0x7FL) << 21;
            }
            case 61: {
                result |= ((long)(~this._bytes[index++]) & 0x7FL) << 14;
            }
            case 62: {
                result |= ((long)(~this._bytes[index++]) & 0x7FL) << 7;
            }
            case 63: {
                result |= (long)(~this._bytes[index++]) & 0x7FL;
                result ^= 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            case 73: {
                result |= ((long)this._bytes[index++] & 0x7FL) << 56;
            }
            case 72: {
                result |= ((long)this._bytes[index++] & 0x7FL) << 49;
            }
            case 71: {
                result |= ((long)this._bytes[index++] & 0x7FL) << 42;
            }
            case 70: {
                result |= ((long)this._bytes[index++] & 0x7FL) << 35;
            }
            case 69: {
                result |= ((long)this._bytes[index++] & 0x7FL) << 28;
            }
            case 68: {
                result |= ((long)this._bytes[index++] & 0x7FL) << 21;
            }
            case 67: {
                result |= ((long)this._bytes[index++] & 0x7FL) << 14;
            }
            case 66: {
                result |= ((long)this._bytes[index++] & 0x7FL) << 7;
            }
            case 65: {
                result |= (long)this._bytes[index++] & 0x7FL;
            }
            case 64: {
                break;
            }
            default: {
                throw new ConversionException("Invalid long type " + type);
            }
        }
        this._index = index;
        return result;
    }

    public float decodeFloat() {
        int bits;
        float result = 0.0f;
        int type = this.getTypeCode();
        int index = this._index + 1;
        if (type == 98) {
            int b;
            bits = 0;
            int shift = 32;
            while ((b = this._bytes[index++] & 0xFF) != 0) {
                if (shift == 0) {
                    throw new ConversionException("Unexpected float byte value " + b + " at " + (index - 1));
                }
                if (shift > 7) {
                    bits = bits << 7 | b & 0x7F;
                    shift -= 7;
                    continue;
                }
                bits = bits << shift | (b & 0x7F) >> 7 - shift;
                shift = 0;
            }
            if (shift > 0) {
                bits <<= shift;
            }
            bits = (bits & Integer.MIN_VALUE) != 0 ? (bits ^= Integer.MIN_VALUE) : (bits ^= 0xFFFFFFFF);
        } else {
            throw new ConversionException("Mismatched type " + type + " is not TYPE_FLOAT at " + this._index);
        }
        result = Float.intBitsToFloat(bits);
        this._index = index;
        return result;
    }

    public double decodeDouble() {
        long bits;
        double result = 0.0;
        int type = this.getTypeCode();
        int index = this._index + 1;
        if (type == 98) {
            return this.decodeFloat();
        }
        if (type == 99) {
            long b;
            bits = 0L;
            int shift = 64;
            while ((b = (long)(this._bytes[index++] & 0xFF)) != 0L) {
                if (shift == 0) {
                    throw new ConversionException("Unexpected float byte value " + b + " at " + (index - 1));
                }
                if (shift > 7) {
                    bits = bits << 7 | b & 0x7FL;
                    shift -= 7;
                    continue;
                }
                bits = bits << shift | (b & 0x7FL) >> 7 - shift;
                shift = 0;
            }
            if (shift > 0) {
                bits <<= shift;
            }
            bits = (bits & Long.MIN_VALUE) != 0L ? (bits ^= Long.MIN_VALUE) : (bits ^= 0xFFFFFFFFFFFFFFFFL);
        } else {
            throw new ConversionException("Mismatched type " + type + " is not TYPE_DOUBLE at " + this._index);
        }
        result = Double.longBitsToDouble(bits);
        this._index = index;
        return result;
    }

    public String decodeString() {
        StringBuilder sb = new StringBuilder();
        this.decodeString(false, sb);
        return sb.toString();
    }

    public Appendable decodeString(Appendable sb) {
        return this.decodeString(false, sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date decodeDate() {
        int index = this._index++;
        try {
            int type = this.getTypeCode();
            if (type != 129) {
                throw new ConversionException("Invalid Date lead-in byte (" + type + ") at position " + this._index + " in key");
            }
            Date result = new Date(this.decodeLongInternal());
            index = this.decodeEnd(this._index);
            Date date = result;
            return date;
        }
        finally {
            this._index = index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger decodeBigInteger() {
        int index = this._index++;
        int type = this.getTypeCode();
        if (type != 110) {
            throw new ConversionException("Invalid String lead-in byte (" + type + ") at position " + this._index + " in key");
        }
        try {
            BigIntegerStruct bis = new BigIntegerStruct();
            this.decodeBigInteger(bis);
            index = this.decodeEnd(this._index);
            BigInteger bigInteger = bis._bigInteger;
            return bigInteger;
        }
        finally {
            this._index = index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal decodeBigDecimal() {
        int index = this._index++;
        int type = this.getTypeCode();
        if (type != 111) {
            throw new ConversionException("Invalid String lead-in byte (" + type + ") at position " + this._index + " in key");
        }
        try {
            BigIntegerStruct bis = new BigIntegerStruct();
            this.decodeBigInteger(bis);
            index = this.decodeEnd(this._index);
            BigDecimal result = new BigDecimal(bis._bigInteger, bis._scale);
            int rescale = bis._scale - bis._zeroCount;
            if (bis._zeroCount > 0 && rescale > 0) {
                result = result.setScale(rescale);
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        finally {
            this._index = index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decodeByteArray() {
        int index = this._index;
        int type = this.getTypeCode();
        try {
            if (type != 126) {
                throw new ConversionException("Invalid String lead-in byte (" + type + ") at position " + this._index + " in key");
            }
            int size = this.unquoteNulls(index + 1, false);
            byte[] result = new byte[size];
            System.arraycopy(this._bytes, index + 1, result, 0, size);
            index += this.quoteNulls(index + 1, size, false) + 2;
            byte[] byArray = result;
            return byArray;
        }
        finally {
            this._index = index;
        }
    }

    public Object decode() {
        return this.decode(null, null);
    }

    public Object decode(Object target) {
        return this.decode(target, null);
    }

    public Object decode(Object target, CoderContext context) {
        int index = this._index;
        int type = this.getTypeCode();
        if (type == 2) {
            return this.decodeNull();
        }
        if (type == 3 || type == 4) {
            return this.decodeBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (type >= 6 && type < 15) {
            return (byte)this.decodeInt();
        }
        if (type >= 15 && type < 26) {
            return (short)this.decodeInt();
        }
        if (type >= 26 && type < 31) {
            return Character.valueOf((char)this.decodeInt());
        }
        if (type >= 31 && type < 55) {
            return this.decodeInt();
        }
        if (type >= 55 && type < 98) {
            return this.decodeLong();
        }
        if (type == 98) {
            return Float.valueOf(this.decodeFloat());
        }
        if (type == 99) {
            return this.decodeDouble();
        }
        if (type == 126) {
            return this.decodeByteArray();
        }
        if (type == 128) {
            if (target != null && Appendable.class.isAssignableFrom(target.getClass())) {
                return this.decodeString((Appendable)target);
            }
            return this.decodeString();
        }
        if (type == 129) {
            return this.decodeDate();
        }
        if (type == 110) {
            return this.decodeBigInteger();
        }
        if (type == 111) {
            return this.decodeBigDecimal();
        }
        if (type == 1 || type == 254) {
            return this.decodeBeforeAfter();
        }
        if (type >= 192 && type <= 219) {
            return this.decodeByKeyCoder(target, context);
        }
        throw new ConversionException("Invalid type " + type + " at index " + (index - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> decodeType() {
        int type = this.getTypeCode();
        if (type >= 192 && type <= 219) {
            int index = this._index;
            try {
                int handle = this.decodeHandle();
                Class<?> clazz = this._persistit.getClassIndex().lookupByHandle(handle).getDescribedClass();
                return clazz;
            }
            finally {
                this._index = index;
            }
        }
        return CLASS_PER_TYPE[type];
    }

    public String decodeDisplayable(boolean quoted) {
        StringBuilder sb = new StringBuilder();
        this.decodeDisplayable(quoted, sb, null);
        return sb.toString();
    }

    public void decodeDisplayable(boolean quoted, Appendable sb, CoderContext context) {
        if (this._index >= this._size) {
            return;
        }
        int type = this._bytes[this._index] & 0xFF;
        switch (type) {
            case 0: {
                Util.append(sb, "{left edge}");
                ++this._index;
                return;
            }
            case 255: {
                Util.append(sb, "{right edge}");
                ++this._index;
                return;
            }
            case 1: 
            case 254: {
                Util.append(sb, this.decodeBeforeAfter().toString());
                ++this._index;
                return;
            }
            case 128: {
                if (quoted) {
                    Util.append(sb, '\"');
                }
                this.decodeString(quoted, sb);
                if (quoted) {
                    Util.append(sb, '\"');
                }
                return;
            }
            case 2: {
                this.decodeNull();
                Util.append(sb, "null");
                return;
            }
            case 3: 
            case 4: {
                Util.append(sb, Boolean.toString(this.decodeBoolean()));
                return;
            }
        }
        if (type >= 192 && type <= 219) {
            this.decodeDisplayableByKeyCoder(quoted, sb, context);
            return;
        }
        Class<?> cl = CLASS_PER_TYPE[type];
        if (cl == Byte.class) {
            Util.append(sb, PREFIX_BYTE);
            Util.append(sb, Byte.toString(this.decodeByte()));
        } else if (cl == Short.class) {
            Util.append(sb, PREFIX_SHORT);
            Util.append(sb, Short.toString(this.decodeShort()));
        } else if (cl == Character.class) {
            Util.append(sb, PREFIX_CHAR);
            Util.append(sb, Integer.toString(this.decodeChar()));
        } else if (cl == Integer.class) {
            Util.append(sb, Integer.toString(this.decodeInt()));
        } else if (cl == Long.class) {
            Util.append(sb, PREFIX_LONG);
            Util.append(sb, Long.toString(this.decodeLong()));
        } else if (cl == Float.class) {
            Util.append(sb, PREFIX_FLOAT);
            Util.append(sb, Float.toString(this.decodeFloat()));
        } else if (cl == Double.class) {
            Util.append(sb, Double.toString(this.decodeDouble()));
        } else if (cl == BigInteger.class) {
            Util.append(sb, PREFIX_BIG_INTEGER);
            Util.append(sb, this.decode().toString());
        } else if (cl == BigDecimal.class) {
            Util.append(sb, PREFIX_BIG_DECIMAL);
            Util.append(sb, this.decode().toString());
        } else if (cl == Boolean.class) {
            Util.append(sb, Boolean.toString(this.decodeBoolean()));
        } else if (cl == Date.class) {
            Util.append(sb, PREFIX_DATE);
            Util.append(sb, SDF.format(this.decodeDate()));
        } else if (cl == byte[].class) {
            Util.append(sb, PREFIX_BYTE_ARRAY);
            Util.append(sb, Util.bytesToHex(this.decodeByteArray()));
        } else {
            Util.append(sb, "(?)");
            Util.bytesToHex(sb, this._bytes, this._index, this._size - this._index);
            this._index = this._size;
        }
    }

    public long getGeneration() {
        return this._generation;
    }

    public boolean isLeftEdge() {
        return this._size == 1 && this._bytes[0] == 0;
    }

    public boolean isRightEdge() {
        return this._size == 1 && this._bytes[0] == -1;
    }

    public boolean isNull() {
        int type = this.getTypeCode();
        return type == 2;
    }

    public boolean isNull(boolean skipNull) {
        if (this.getTypeCode() == 2) {
            if (skipNull) {
                this._index = this.decodeEnd(this._index + 1);
            }
            return true;
        }
        return false;
    }

    int nextElementIndex() {
        this._depth = -1;
        this._index = this.nextElementIndex(this._index);
        return this._index;
    }

    int previousElementIndex() {
        this._index = this.previousElementIndex(this._index);
        this._depth = -1;
        return this._index;
    }

    int nextElementIndex(int index) {
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < this._size; ++i) {
            if (this._bytes[i] != 0) continue;
            return i < this._size ? i + 1 : -1;
        }
        return -1;
    }

    int previousElementIndex(int index) {
        if (index < 0 || index > this._size) {
            index = this._size;
        }
        int i = index - 1;
        while (--i >= 0) {
            if (this._bytes[i] != 0) continue;
            return i + 1;
        }
        return index == 0 ? -1 : 0;
    }

    void bumpGeneration() {
        ++this._generation;
    }

    void testValidForAppend() {
        if (this._size == 0 || this._size > 1 && this._bytes[this._size - 1] == 0 || this._inKeyCoder) {
            return;
        }
        int b = this._bytes[this._size - 1] & 0xFF;
        if (this._size == 1) {
            if (b == 0) {
                throw new IllegalArgumentException("append to LEFT_EDGE key");
            }
            if (b == 255) {
                throw new IllegalArgumentException("append to RIGHT_EDGE key");
            }
        }
        if (b == 1 || b == 254) {
            throw new IllegalArgumentException("append to BEFORE key or AFTER");
        }
        throw new IllegalArgumentException("append to invalid final key segment: " + (b & 0xFF));
    }

    void testValidForStoreAndFetch(int bufferSize) throws InvalidKeyException {
        if (this._size == 0) {
            throw new InvalidKeyException("Empty Key not permitted");
        }
        if (this._size > Key.maxStorableKeySize(bufferSize)) {
            throw new InvalidKeyException("Key too long for buffer: " + this._size);
        }
        int b = this._bytes[this._size - 1] & 0xFF;
        if (b == 1 || b == 254) {
            throw new InvalidKeyException("BEFORE key or AFTER key not permitted");
        }
        if (b != 0) {
            throw new InvalidKeyException("Invalid key segment terminator " + (b & 0xFF));
        }
    }

    void testValidForTraverse() throws InvalidKeyException {
        if (this._size == 0) {
            throw new InvalidKeyException("Empty Key not permitted");
        }
    }

    static int maxStorableKeySize(int bufferSize) {
        if (bufferSize >= 8192) {
            return 2047;
        }
        int result = bufferSize / 8 - 1;
        if (result > 2047) {
            result = 2047;
        }
        return result;
    }

    boolean isBefore() {
        return this._size > 0 && (this._bytes[this._size - 1] & 0xFF) == 1;
    }

    boolean isAfter() {
        return this._size > 0 && (this._bytes[this._size - 1] & 0xFF) == 254;
    }

    void nudgeLeft() {
        if (this._size >= 2 && this._bytes[this._size - 1] == 0 && this._bytes[this._size - 2] != 0) {
            --this._size;
            this.bumpGeneration();
        }
    }

    void nudgeRight() {
        if (this._size >= 2 && this._bytes[this._size - 1] == 0 && this._bytes[this._size - 2] != 0) {
            this._bytes[this._size - 1] = 1;
            this.bumpGeneration();
        }
    }

    void nudgeDeeper() {
        if (this._size <= this._maxSize) {
            this._bytes[this._size++] = 0;
            this.bumpGeneration();
        }
    }

    boolean isSpecial() {
        return this.isSegmentSpecial(this._size);
    }

    boolean isSegmentSpecial(int size) {
        if (size < 2) {
            return true;
        }
        if (this._bytes[size - 1] != 0) {
            return true;
        }
        return this._bytes[size - 2] == 0;
    }

    private Key appendString(CharSequence s, CoderContext context) {
        int save = this._size;
        try {
            this.notLeftOrRightGuard();
            this.testValidForAppend();
            int strlen = s.length();
            int size = this._size;
            this._bytes[size++] = -128;
            for (int i = 0; i < strlen; ++i) {
                char c = s.charAt(i);
                if (c <= '\u0001') {
                    this._bytes[size++] = 1;
                    this._bytes[size++] = (byte)(c + 32);
                    continue;
                }
                if (c <= '\u007f') {
                    this._bytes[size++] = (byte)c;
                    continue;
                }
                if (c <= '\u07ff') {
                    this._bytes[size++] = (byte)(0xC0 | c >> 6 & 0x1F);
                    this._bytes[size++] = (byte)(0x80 | c >> 0 & 0x3F);
                    continue;
                }
                this._bytes[size++] = (byte)(0xE0 | c >> 12 & 0xF);
                this._bytes[size++] = (byte)(0x80 | c >> 6 & 0x3F);
                this._bytes[size++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            return this.endSegment(size);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    private Key appendNull() {
        int save = this._size;
        try {
            int size = this._size;
            this._bytes[size++] = 2;
            return this.endSegment(size);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key appendByKeyCoder(Object object, Class<?> cl, KeyCoder coder, CoderContext context) {
        int size = this._size;
        boolean saveInKeyCoder = this._inKeyCoder;
        try {
            int handle = this._persistit.getClassIndex().lookupByClass(cl).getHandle();
            this._size += this.encodeHandle(handle);
            int begin = this._size;
            this._inKeyCoder = true;
            coder.appendKeySegment(this, object, context);
            this.quoteNulls(begin, this._size - begin, coder.isZeroByteFree());
            this.endSegment(this._size);
            size = this._size;
            Key key = this;
            return key;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Key key = this.tooLong(size);
            return key;
        }
        finally {
            this._size = size;
            this._inKeyCoder = saveInKeyCoder;
        }
    }

    private Object decodeByKeyCoder(Object target, CoderContext context) {
        int index = this._index;
        int size = this._size;
        Class clazz = Object.class;
        int segmentSize = 0;
        boolean unquoted = false;
        boolean zeroByteFree = false;
        try {
            int handle = this.decodeHandle();
            clazz = this._persistit.classForHandle(handle);
            if (clazz == null) {
                throw new ConversionException("No class information for handle " + handle);
            }
            KeyCoder coder = this._persistit.lookupKeyCoder(clazz);
            if (coder == null) {
                throw new ConversionException("No KeyCoder for class " + clazz.getName());
            }
            zeroByteFree = coder.isZeroByteFree();
            segmentSize = this.unquoteNulls(index, zeroByteFree);
            size = this._size;
            this._size = index + segmentSize;
            unquoted = true;
            if (target == null) {
                Object object = coder.decodeKeySegment(this, clazz, context);
                return object;
            }
            if (coder instanceof KeyRenderer) {
                ((KeyRenderer)coder).renderKeySegment(this, target, clazz, context);
                Object object = target;
                return object;
            }
            throw new ConversionException("No KeyRenderer for class " + clazz.getName());
        }
        finally {
            this._size = size;
            if (unquoted) {
                index += this.quoteNulls(index, segmentSize, zeroByteFree);
                index = this.decodeEnd(index);
            }
            this._index = index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeDisplayableByKeyCoder(boolean quoted, Appendable sb, CoderContext context) {
        int index = this._index;
        int size = this._size;
        int segmentSize = 0;
        boolean unquoted = false;
        boolean zeroByteFree = false;
        try {
            int handle = this.decodeHandle();
            Class<?> clazz = this._persistit.classForHandle(handle);
            KeyCoder coder = null;
            if (clazz == null) {
                Util.append(sb, "(?handle=");
                Util.append(sb, Integer.toString(handle));
                Util.append(sb, ")");
            } else {
                Util.append(sb, "(");
                Util.append(sb, clazz.getName());
                Util.append(sb, ")");
                coder = this._persistit.lookupKeyCoder(clazz);
                zeroByteFree = coder.isZeroByteFree();
            }
            segmentSize = this.unquoteNulls(index, zeroByteFree);
            size = this._size;
            unquoted = true;
            this._size = index + segmentSize;
            if (coder instanceof KeyDisplayer) {
                ((KeyDisplayer)coder).displayKeySegment(this, sb, clazz, context);
            } else {
                Util.append(sb, '{');
                int depth = 0;
                while (this._index < this._size) {
                    if (depth > 0) {
                        Util.append(sb, ',');
                    }
                    this.decodeDisplayable(quoted, sb, context);
                    ++depth;
                }
                Util.append(sb, '}');
            }
        }
        finally {
            this._size = size;
            if (unquoted) {
                index += this.quoteNulls(index, segmentSize, zeroByteFree);
                index = this.decodeEnd(index);
            }
            this._index = index;
        }
    }

    Key appendBefore() {
        int save = this._size;
        try {
            int size = this._size;
            this._bytes[size++] = 1;
            this._bytes[size] = 0;
            this._size = size;
            if (this._depth != -1) {
                ++this._depth;
            }
            this.bumpGeneration();
            return this;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    Key appendAfter() {
        int save = this._size;
        try {
            int size = this._size;
            this._bytes[size++] = -2;
            this._bytes[size] = 0;
            this._size = size;
            if (this._depth != -1) {
                ++this._depth;
            }
            this.bumpGeneration();
            return this;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    private Key appendDate(Date v) {
        int save = this._size;
        try {
            this._bytes[this._size++] = -127;
            int size = this.appendLongInternal(v.getTime());
            return this.endSegment(size);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    private Key appendBigInteger(BigInteger v) {
        int save = this._size;
        try {
            this._bytes[this._size++] = 110;
            this.appendBigInteger(v, 0);
            this.endSegment(this._size);
            return this;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    private Key appendBigDecimal(BigDecimal v) {
        int save = this._size;
        try {
            this._bytes[this._size++] = 111;
            this.appendBigInteger(v.unscaledValue(), v.scale());
            this.endSegment(this._size);
            return this;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    public Key appendByteArray(byte[] bytes, int offset, int size) {
        int save = this._size;
        try {
            this._bytes[this._size++] = 126;
            int keySize = this._size;
            System.arraycopy(bytes, offset, this._bytes, keySize, size);
            this._size += size;
            keySize += this.quoteNulls(keySize, size, false);
            return this.endSegment(keySize);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.tooLong(save);
        }
    }

    private int getTypeCode() {
        if (this._index >= this._size) {
            throw new MissingKeySegmentException("index=" + this._index + " size=" + this._size);
        }
        return this._bytes[this._index] & 0xFF;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Appendable decodeString(boolean quoted, Appendable sb) {
        int c1;
        int index = this._index;
        if ((c1 = this._bytes[index++] & 0xFF) != 128) {
            throw new ConversionException("Invalid String lead-in byte (" + c1 + ") at position " + (index - 1) + " in key");
        }
        while ((c1 = this._bytes[index++] & 0xFF) != 0 && index <= this._size) {
            int c2;
            char c = '\u0000';
            if (c1 == 1) {
                if ((c2 = this._bytes[index++] & 0xFF) < 32 || c2 > 33) throw new ConversionException("String decoding exception at position " + (index - 1));
                c = (char)(c2 - 32);
            } else if (c1 <= 127) {
                c = (char)c1;
            } else if (c1 > 192 && c1 <= 223) {
                if ((c2 = this._bytes[index++] & 0xFF) < 128 || c2 > 191) throw new ConversionException("String decoding exception at position " + (index - 1));
                c = (char)((c1 & 0x1F) << 6 | (c2 & 0x3F) << 0);
            } else {
                if (c1 < 224 || c1 > 239) throw new ConversionException("String decoding exception at position " + (index - 1));
                c2 = this._bytes[index++] & 0xFF;
                int c3 = this._bytes[index++] & 0xFF;
                if (c2 >= 128 && c2 <= 191 && c3 >= 128 && c3 <= 191) {
                    c = (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                }
            }
            if (quoted) {
                Util.appendQuotedChar(sb, c);
                continue;
            }
            Util.append(sb, c);
        }
        this._index = index;
        return sb;
    }

    private Key endSegment(int size) {
        this._bytes[size++] = 0;
        this._size = size;
        if (this._depth != -1) {
            ++this._depth;
        }
        this.bumpGeneration();
        return this;
    }

    private Key tooLong(int originalSize) throws KeyTooLongException {
        this._size = originalSize;
        throw new KeyTooLongException("Maximum size=" + this._maxSize + " original size=" + originalSize);
    }

    private Key setRightEdge() {
        this._bytes[0] = -1;
        this._size = 1;
        return this;
    }

    private Key setLeftEdge() {
        this._bytes[0] = 0;
        this._size = 1;
        return this;
    }

    private int encodeHandle(int handle) {
        int v = handle - 64;
        int size = this._size;
        if (v < 7) {
            this._bytes[size++] = (byte)(0xC0 | v & 7);
            return 1;
        }
        if (v < 511) {
            this._bytes[size++] = (byte)(0xC8 | v >>> 6 & 7);
            this._bytes[size++] = (byte)(0x80 | v & 0x3F);
            return 2;
        }
        if (v < Short.MAX_VALUE) {
            this._bytes[size++] = (byte)(0xD0 | v >>> 12 & 7);
            this._bytes[size++] = (byte)(0xC0 | v >>> 6 & 0x3F);
            this._bytes[size++] = (byte)(0x80 | v & 0x3F);
            return 3;
        }
        this._bytes[size++] = (byte)(0xD8 | v >>> 30 & 7);
        this._bytes[size++] = (byte)(0xC0 | v >>> 24 & 0x3F);
        this._bytes[size++] = (byte)(0xC0 | v >>> 18 & 0x3F);
        this._bytes[size++] = (byte)(0xC0 | v >>> 12 & 0x3F);
        this._bytes[size++] = (byte)(0xC0 | v >>> 6 & 0x3F);
        this._bytes[size++] = (byte)(0x80 | v & 0x3F);
        return 6;
    }

    private int decodeHandle() {
        int index = this._index;
        int base = this._bytes[index++] & 0xFF;
        int result = base & 7;
        switch (base & 0xC0) {
            case 216: {
                int v = this._bytes[index++] & 0xFF;
                if ((v & 0xC0) != 192) break;
                result = result << 6 | v & 0x3F;
                if (((v = this._bytes[index++] & 0xFF) & 0xC0) != 192) break;
                result = result << 6 | v & 0x3F;
                if (((v = this._bytes[index++] & 0xFF) & 0xC0) != 192) break;
                result = result << 6 | v & 0x3F;
            }
            case 208: {
                int v = this._bytes[index++] & 0xFF;
                if ((v & 0xC0) != 192) break;
                result = result << 6 | v & 0x3F;
            }
            case 200: {
                int v = this._bytes[index++] & 0xFF;
                if ((v & 0x80) != 128) break;
                result = result << 6 | v & 0x3F;
            }
            case 192: {
                this._index = index;
                return result + 64;
            }
        }
        throw new ConversionException("Invalid KeyCoder handle at " + this._index);
    }

    private int decodeEnd(int index) {
        if (this._bytes[index] != 0) {
            throw new ConversionException("Invalid end byte at " + (index + 1));
        }
        return index + 1;
    }

    private Object decodeNull() {
        int type = this._bytes[this._index] & 0xFF;
        if (type != 2) {
            throw new ConversionException("Expected null type");
        }
        this._index = this.decodeEnd(this._index + 1);
        return null;
    }

    private Object decodeBeforeAfter() {
        int type = this._bytes[this._index] & 0xFF;
        EdgeValue v = null;
        if (type == 1) {
            v = BEFORE;
        } else if (type == 254) {
            v = AFTER;
        } else {
            throw new ConversionException("Invalid BEFORE type " + type);
        }
        this._index = this.decodeEnd(this._index + 1);
        return v;
    }

    private int quoteNulls(int index, int size, boolean zeroByteFree) {
        for (int i = index; i < index + size; ++i) {
            int c = this._bytes[i] & 0xFF;
            if (zeroByteFree) {
                if (c != 0) continue;
                throw new ConversionException("NUL found in encoded Key");
            }
            if (c != 0 && c != 1) continue;
            System.arraycopy(this._bytes, i + 1, this._bytes, i + 2, this._size - i - 1);
            this._bytes[i] = 1;
            this._bytes[i + 1] = (byte)(c + 32);
            ++this._size;
            ++size;
            ++i;
        }
        return size;
    }

    private int unquoteNulls(int index, boolean zeroByteFree) {
        for (int i = index; i < this._size; ++i) {
            int c = this._bytes[i] & 0xFF;
            if (c == 0) {
                return i - index;
            }
            if (zeroByteFree || c != 1 || i + 1 >= this._size || (c = this._bytes[i + 1]) != 32 && c != 33) continue;
            this._bytes[i] = (byte)(c - 32);
            System.arraycopy(this._bytes, i + 2, this._bytes, i + 1, this._size - (i + 2));
            --this._size;
        }
        return this._size - index;
    }

    private void recomputeCurrentDepth() {
        int depth = 0;
        for (int index = 0; index < this._size; ++index) {
            if (this._bytes[index] != 0) continue;
            ++depth;
        }
        this._depth = depth;
    }

    private void notLeftOrRightGuard() {
        if (this == LEFT_GUARD_KEY || this == RIGHT_GUARD_KEY) {
            throw new IllegalArgumentException("Operation not permitted on a guard key");
        }
    }

    private void appendBigInteger(BigInteger bigInt, int scale) {
        int signum = bigInt.signum();
        if (signum == 0) {
            this._bytes[this._size++] = 64;
            return;
        }
        boolean neg = signum < 0;
        int length = bigInt.bitLength();
        int rLength = length + 1;
        int iLength = bigInt.bitLength() / 24 + 1;
        int[] buffer = new int[iLength];
        int index = iLength - 1;
        int digitCount = 0;
        int zeroCount = 0;
        boolean low4 = false;
        while (rLength > 0) {
            BigInteger remainder = bigInt.remainder(BIG_INT_DIVISOR);
            long lowBits = remainder.longValue();
            if (neg) {
                lowBits = -lowBits;
            }
            for (int j = 0; j < 2 && index >= 0 && index >= 0; --index, ++j) {
                for (int k = 0; k < 4; ++k) {
                    int hundred = (int)(lowBits % 100L);
                    int bcd = hundred / 10 * 16 + hundred % 10;
                    int n = index;
                    buffer[n] = buffer[n] | bcd << k * 8;
                    lowBits /= 100L;
                    if (hundred > 0) {
                        boolean bl = low4 = hundred < 10;
                        if (digitCount == 0 && hundred % 10 == 0) {
                            ++zeroCount;
                        }
                        digitCount = (iLength - index - 1) * 8 + k * 2 + 2;
                        continue;
                    }
                    if (digitCount != 0) continue;
                    zeroCount += 2;
                }
            }
            if ((rLength -= 50) <= 0) continue;
            bigInt = bigInt.divide(BIG_INT_DIVISOR);
        }
        if (index < 0) {
            index = 0;
        }
        if (low4) {
            for (int i = index; i < iLength; ++i) {
                int low = i + 1 == iLength ? 0 : buffer[i + 1];
                buffer[i] = buffer[i] << 4 | low >>> 28 & 0xF;
            }
            ++zeroCount;
        }
        int exp = digitCount - scale - (low4 ? 1 : 0);
        this._bytes[this._size++] = (byte)(64 + signum);
        if (neg) {
            exp = -exp;
        }
        this._size = this.appendIntInternal(exp);
        int shift = digitCount % 8 * 4;
        if (shift == 0) {
            shift = 32;
        }
        int digits = digitCount - zeroCount;
        for (int k = index = iLength - (digitCount + 7) / 8; k < iLength; ++k) {
            int word = buffer[k];
            while ((shift -= 8) >= 0) {
                byte b = (byte)(word >>> shift);
                b = neg ? (byte)(170 - b) : (byte)(b + 17);
                this._bytes[this._size++] = b;
                if ((digits -= 2) > 0) continue;
                break;
            }
            if (digits <= 0) break;
            shift = 32;
        }
        if (neg) {
            this._bytes[this._size++] = -1;
        }
    }

    private void decodeBigInteger(BigIntegerStruct bis) {
        int signum;
        int start = this._index;
        if ((signum = (this._bytes[this._index++] & 0xFF) - 64) < -1 || signum > 1) {
            throw new ConversionException("Invalid BigInteger signum at offset " + start);
        }
        if (signum == 0) {
            bis._bigInteger = BigInteger.ZERO;
            bis._scale = 0;
            return;
        }
        boolean neg = signum < 0;
        int exp = this.decodeIntInternal();
        if (neg) {
            exp = -exp;
        }
        bis._bigInteger = null;
        bis._scale = 0;
        bis._zeroCount = 0;
        boolean done = false;
        int lastDigit = 0;
        boolean leftOverDigit = false;
        boolean lastDigitZero = false;
        int zeroCount = 0;
        while (!done) {
            long lowBits = leftOverDigit ? (long)lastDigit : 0L;
            int chunk = 0;
            if (exp > 0) {
                chunk = exp % 16;
                if (chunk == 0) {
                    chunk = 16;
                }
            } else {
                chunk = 16;
            }
            exp -= chunk;
            if (leftOverDigit) {
                --chunk;
            }
            boolean dontAccumulate = false;
            while (chunk > 0 && !done) {
                int b;
                if ((b = this._bytes[this._index++] & 0xFF) == 0) {
                    done = true;
                    --this._index;
                    if (chunk >= 15 && exp == -16 && lowBits == 0L) {
                        exp += 16;
                        dontAccumulate = true;
                        continue;
                    }
                    if (leftOverDigit) {
                        boolean bl = lastDigitZero = lastDigit == 0;
                    }
                    if (lastDigitZero) {
                        ++zeroCount;
                    }
                    while (--chunk >= 0) {
                        ++zeroCount;
                        lowBits *= 10L;
                    }
                    continue;
                }
                if (b == 255) continue;
                b = neg ? 170 - b : (b -= 17);
                if ((b >>> 4 & 0xF) > 9 || (b & 0xF) > 9) {
                    throw new ConversionException("Invalid BigInteger encoding at index " + (this._index - 1));
                }
                if (chunk == 1) {
                    int digit = b >>> 4 & 0xF;
                    lowBits = lowBits * 10L + (long)digit;
                    lastDigit = b & 0xF;
                    lastDigitZero = digit == 0;
                    leftOverDigit = true;
                    --chunk;
                    continue;
                }
                int digit0 = b & 0xF;
                int digit1 = b >>> 4 & 0xF;
                lowBits = lowBits * 100L + (long)digit1 * 10L + (long)digit0;
                chunk -= 2;
                lastDigitZero = digit0 == 0;
                leftOverDigit = false;
            }
            if (neg) {
                lowBits = -lowBits;
            }
            if (bis._bigInteger == null) {
                bis._bigInteger = BigInteger.valueOf(lowBits);
                continue;
            }
            if (dontAccumulate) continue;
            bis._bigInteger = bis._bigInteger.multiply(BIG_INT_DIVISOR).add(BigInteger.valueOf(lowBits));
        }
        while (exp > 0) {
            bis._bigInteger = bis._bigInteger.multiply(BIG_INT_DIVISOR);
            exp -= 16;
        }
        bis._zeroCount = zeroCount;
        bis._scale = -exp;
    }

    static {
        LEFT_GUARD_KEY.setLeftEdge();
        RIGHT_GUARD_KEY.setRightEdge();
    }

    private static class BigIntegerStruct {
        BigInteger _bigInteger;
        int _scale;
        int _zeroCount = 0;

        private BigIntegerStruct() {
        }
    }

    private static enum Nudged {
        NO,
        LEFT,
        RIGHT,
        DOWN;

    }

    public static class EdgeValue
    implements Serializable {
        public static final long serialVersionUID = -502106634184636556L;
        boolean _after;

        private EdgeValue(boolean after) {
            this._after = after;
        }

        public String toString() {
            return this._after ? "{after}" : "{before}";
        }

        public Object readResolve() {
            return this._after ? AFTER : BEFORE;
        }
    }

    public static enum Direction {
        EQ,
        LT,
        LTEQ,
        GT,
        GTEQ;

    }
}

