/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Persistit;
import com.persistit.exception.PersistitInterruptedException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

class SharedResource {
    public static final long DEFAULT_MAX_WAIT_TIME = 60000L;
    static final int CLAIMED_MASK = Short.MAX_VALUE;
    static final int WRITER_MASK = 32768;
    static final int DIRTY_MASK = 65536;
    static final int VALID_MASK = 131072;
    static final int TEMPORARY_MASK = 0x400000;
    static final int TOUCHED_MASK = 0x8000000;
    static final int FIXED_MASK = 0x40000000;
    static final AtomicLong ACQUIRE_LOOPS = new AtomicLong();
    static final AtomicLong RELEASE_LOOPS = new AtomicLong();
    static final AtomicLong SET_BIT_LOOPS = new AtomicLong();
    static final AtomicLong CLEAR_BIT_LOOPS = new AtomicLong();
    protected final Persistit _persistit;
    private final Sync _sync = new Sync();
    protected AtomicLong _generation = new AtomicLong();

    protected SharedResource(Persistit persistit) {
        this._persistit = persistit;
    }

    public boolean isAvailable(boolean writer) {
        return writer ? this._sync.isAvailable(this._sync.state()) : this._sync.isAvailableShared(this._sync.state());
    }

    boolean isDirty() {
        return this._sync.testBitsInState(65536);
    }

    public boolean isValid() {
        return this._sync.testBitsInState(131072);
    }

    public boolean isTemporary() {
        return this._sync.testBitsInState(0x400000);
    }

    boolean isFixed() {
        return this._sync.testBitsInState(0x40000000);
    }

    boolean isWriter() {
        return this._sync.testBitsInState(32768);
    }

    boolean isOwnedAsWriterByMe() {
        return this._sync.writerThread() == Thread.currentThread();
    }

    boolean isOwnedAsWriterByOther() {
        Thread t = this._sync.writerThread();
        return t != null && t != Thread.currentThread();
    }

    boolean claim(boolean writer) throws PersistitInterruptedException {
        return this.claim(writer, 60000L);
    }

    boolean claim(boolean writer, long timeout) throws PersistitInterruptedException {
        if (timeout == 0L) {
            if (writer) {
                return this._sync.tryAcquire(1);
            }
            return this._sync.tryAcquireShared(1) >= 0;
        }
        long ns = Math.min(timeout, 9223372036854L) * 1000000L;
        try {
            if (writer ? this._sync.tryAcquireNanos(1, ns) : this._sync.tryAcquireSharedNanos(1, ns)) {
                return true;
            }
        }
        catch (InterruptedException e) {
            throw new PersistitInterruptedException(e);
        }
        return false;
    }

    boolean upgradeClaim() {
        return this._sync.tryUpgrade();
    }

    void release() {
        this._sync.release(1);
    }

    void releaseWriterClaim() {
        this._sync.release(0);
    }

    boolean setDirty() {
        return this._sync.setBitsInState(65536);
    }

    boolean clearDirty() {
        return this._sync.clearBitsInState(65536);
    }

    void setTouched() {
        this._sync.setBitsInState(0x8000000);
    }

    void clearTouched() {
        this._sync.clearBitsInState(0x8000000);
    }

    void setFixed() {
        this._sync.setBitsInState(0x40000000);
    }

    void clearFixed() {
        this._sync.clearBitsInState(0x40000000);
    }

    boolean isTouched() {
        return this._sync.testBitsInState(0x8000000);
    }

    public long getGeneration() {
        return this._generation.get();
    }

    void setTemporary() {
        this._sync.setBitsInState(0x400000);
    }

    void clearTemporary() {
        this._sync.clearBitsInState(0x400000);
    }

    void setValid() {
        this._sync.setBitsInState(131072);
    }

    void clearValid() {
        this._sync.clearBitsInState(131072);
    }

    void bumpGeneration() {
        this._generation.incrementAndGet();
    }

    public int getStatus() {
        return this._sync.state();
    }

    void setStatus(SharedResource resource) {
        int mask = resource.getStatus();
        this._sync.clearBitsInState(-65536);
        this._sync.setBitsInState(mask & 0xFFFF0000);
    }

    public String getStatusCode() {
        return SharedResource.getStatusCode(this.getStatus());
    }

    public String getStatusDisplayString() {
        Thread writerThread = this._sync.writerThread();
        int state = this._sync.state();
        if (writerThread == null) {
            return SharedResource.getStatusCode(state);
        }
        return SharedResource.getStatusCode(state) + " <" + writerThread.getName() + ">";
    }

    public static String getStatusCode(int state) {
        switch (state) {
            case 0: {
                return "";
            }
            case 131072: {
                return "v";
            }
            case 196608: {
                return "vd";
            }
            case 131073: {
                return "vr1";
            }
            case 163841: {
                return "vwr1";
            }
            case 196609: {
                return "vdr1";
            }
            case 229377: {
                return "vdwr1";
            }
        }
        StringBuilder sb = new StringBuilder(8);
        if ((state & 0x20000) != 0) {
            sb.append("v");
        }
        if ((state & 0x10000) != 0) {
            sb.append("d");
        }
        if ((state & 0x400000) != 0) {
            sb.append("t");
        }
        if ((state & 0x8000) != 0) {
            sb.append("w");
        }
        if ((state & Short.MAX_VALUE) != 0) {
            sb.append("r");
            sb.append(state & Short.MAX_VALUE);
        }
        return sb.toString();
    }

    public Thread getWriterThread() {
        return this._sync.writerThread();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.hashCode() + " status=" + this.getStatusDisplayString();
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1L;

        private Sync() {
        }

        @Override
        protected boolean tryAcquire(int arg) {
            assert (arg == 1);
            Thread thisThread = Thread.currentThread();
            Thread queuedThread;
            while ((queuedThread = this.getFirstQueuedThread()) == null || queuedThread == thisThread || this.getExclusiveOwnerThread() == thisThread) {
                int state = this.getState();
                if (!this.isAvailable(state)) {
                    return false;
                }
                if (this.compareAndSetState(state, (state | 0x8000) + 1)) {
                    this.setExclusiveOwnerThread(thisThread);
                    return true;
                }
                ACQUIRE_LOOPS.incrementAndGet();
            }
            return false;
        }

        @Override
        protected int tryAcquireShared(int arg) {
            assert (arg == 1);
            Thread thisThread = Thread.currentThread();
            Thread queuedThread;
            while ((queuedThread = this.getFirstQueuedThread()) == null || queuedThread == thisThread || this.getExclusiveOwnerThread() == thisThread) {
                int state = this.getState();
                if (!this.isAvailableShared(state)) {
                    return -1;
                }
                if (this.compareAndSetState(state, state + 1)) {
                    return Short.MAX_VALUE - (state & Short.MAX_VALUE) - 1;
                }
                ACQUIRE_LOOPS.incrementAndGet();
            }
            return -1;
        }

        private boolean tryUpgrade() {
            while (true) {
                int state = this.getState();
                Thread thisThread = Thread.currentThread();
                if ((state & Short.MAX_VALUE) != 1 || (state & 0x8000) != 0 && this.getExclusiveOwnerThread() != thisThread) {
                    return false;
                }
                if (this.compareAndSetState(state, state | 0x8000)) {
                    this.setExclusiveOwnerThread(thisThread);
                    return true;
                }
                ACQUIRE_LOOPS.incrementAndGet();
            }
        }

        @Override
        protected boolean tryRelease(int arg) {
            return (this.releaseState(arg) & 0x8000) == 0;
        }

        @Override
        protected boolean tryReleaseShared(int arg) {
            return (this.releaseState(arg) & 0x8000) == 0;
        }

        @Override
        protected boolean isHeldExclusively() {
            return (this.getState() & 0x8000) != 0;
        }

        private boolean isAvailable(int state) {
            return (state & Short.MAX_VALUE) < Short.MAX_VALUE && ((state & Short.MAX_VALUE) == 0 || this.getExclusiveOwnerThread() == Thread.currentThread());
        }

        private boolean isAvailableShared(int state) {
            return (state & Short.MAX_VALUE) < Short.MAX_VALUE && ((state & 0x8000) == 0 || this.getExclusiveOwnerThread() == Thread.currentThread());
        }

        private int releaseState(int count) {
            assert (count == 0 || count == 1);
            while (true) {
                int newState;
                int state;
                if (((state = this.getState()) & Short.MAX_VALUE) == 1) {
                    newState = state - count & 0xFFFF7FFF;
                    this.setExclusiveOwnerThread(null);
                    if (this.compareAndSetState(state, newState)) {
                        return newState;
                    }
                } else if ((state & Short.MAX_VALUE) > 1) {
                    if (count == 0) {
                        return state;
                    }
                    newState = state - 1;
                    if (this.compareAndSetState(state, newState)) {
                        return newState;
                    }
                } else {
                    throw new IllegalMonitorStateException("Unmatched attempt to release " + this);
                }
                RELEASE_LOOPS.incrementAndGet();
            }
        }

        private int state() {
            return this.getState();
        }

        private Thread writerThread() {
            return this.getExclusiveOwnerThread();
        }

        private boolean setBitsInState(int mask) {
            int newState;
            int state;
            while (!this.compareAndSetState(state = this.getState(), newState = state | mask)) {
                SET_BIT_LOOPS.incrementAndGet();
            }
            return state != newState;
        }

        private boolean clearBitsInState(int mask) {
            int newState;
            int state;
            while (!this.compareAndSetState(state = this.getState(), newState = state & ~mask)) {
                CLEAR_BIT_LOOPS.incrementAndGet();
            }
            return state != newState;
        }

        private boolean testBitsInState(int mask) {
            return (this.getState() & mask) != 0;
        }
    }
}

