/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.AlertMonitor;
import com.persistit.Exchange;
import com.persistit.JournalManager;
import com.persistit.JournalRecord;
import com.persistit.Key;
import com.persistit.Persistit;
import com.persistit.TransactionPlayerSupport;
import com.persistit.Tree;
import com.persistit.Value;
import com.persistit.Volume;
import com.persistit.exception.CorruptJournalException;
import com.persistit.exception.PersistitException;
import com.persistit.exception.VolumeNotFoundException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;

class TransactionPlayer {
    private final AtomicLong appliedUpdates = new AtomicLong();
    private final AtomicLong ignoredUpdates = new AtomicLong();
    private final AtomicLong failedUpdates = new AtomicLong();
    final TransactionPlayerSupport _support;

    TransactionPlayer(TransactionPlayerSupport support) {
        this._support = support;
    }

    void applyTransaction(JournalManager.TransactionMapItem item, TransactionPlayerListener listener) throws PersistitException {
        long commitTimestamp;
        long startTimestamp;
        int type;
        int recordSize;
        ArrayList<Long> chainedAddress = new ArrayList<Long>();
        long address = item.getLastRecordAddress();
        while (true) {
            this._support.read(address, 32);
            recordSize = JournalRecord.TX.getLength(this._support.getReadBuffer());
            this._support.read(address, recordSize);
            type = JournalRecord.TX.getType(this._support.getReadBuffer());
            startTimestamp = JournalRecord.TX.getTimestamp(this._support.getReadBuffer());
            commitTimestamp = JournalRecord.TX.getCommitTimestamp(this._support.getReadBuffer());
            long backchainAddress = JournalRecord.TX.getBackchainAddress(this._support.getReadBuffer());
            if (recordSize < 32 || recordSize > 65568 || type != 21592) {
                throw new CorruptJournalException("Transaction record at " + TransactionPlayer.addressToString(address) + " has invalid length " + recordSize + " or type " + type);
            }
            if (startTimestamp != item.getStartTimestamp()) {
                throw new CorruptJournalException("Transaction record at " + TransactionPlayer.addressToString(address) + " has an invalid start timestamp: " + startTimestamp);
            }
            if (backchainAddress == 0L) {
                if (address == item.getStartAddress()) break;
                throw new CorruptJournalException("Transaction record at " + TransactionPlayer.addressToString(address) + " has an invalid start " + TransactionPlayer.addressToString(item.getStartAddress()));
            }
            chainedAddress.add(0, address);
            address = backchainAddress;
        }
        listener.startTransaction(address, startTimestamp, commitTimestamp);
        this.applyTransactionUpdates(this._support.getReadBuffer(), address, recordSize, startTimestamp, commitTimestamp, listener);
        for (Long continuation : chainedAddress) {
            address = continuation;
            this._support.read(address, 32);
            recordSize = JournalRecord.TX.getLength(this._support.getReadBuffer());
            if (recordSize < 32 || recordSize > 65568 || type != 21592) {
                throw new CorruptJournalException("Transaction record at " + TransactionPlayer.addressToString(address) + " has invalid length " + recordSize + " or type " + type);
            }
            this._support.read(address, recordSize);
            this.applyTransactionUpdates(this._support.getReadBuffer(), address, recordSize, startTimestamp, commitTimestamp, listener);
        }
        listener.endTransaction(address, startTimestamp);
    }

    void applyTransactionUpdates(ByteBuffer byteBuffer, long address, int recordSize, long startTimestamp, long commitTimestamp, TransactionPlayerListener listener) throws PersistitException {
        int innerSize;
        ByteBuffer bb = byteBuffer;
        int start = bb.position();
        int end = start + recordSize;
        block10: for (int position = start + 32; position < end; position += innerSize) {
            bb.position(position);
            innerSize = JournalRecord.getLength(bb);
            int type = JournalRecord.getType(bb);
            try {
                switch (type) {
                    case 21330: {
                        int keySize = JournalRecord.SR.getKeySize(bb);
                        int treeHandle = JournalRecord.SR.getTreeHandle(bb);
                        Exchange exchange = this.getExchange(treeHandle, address, startTimestamp);
                        exchange.ignoreTransactions();
                        Key key = exchange.getKey();
                        Value value = exchange.getValue();
                        System.arraycopy(bb.array(), bb.position() + 14, key.getEncodedBytes(), 0, keySize);
                        key.setEncodedSize(keySize);
                        int valueSize = innerSize - 14 - keySize;
                        value.ensureFit(valueSize);
                        System.arraycopy(bb.array(), bb.position() + 14 + keySize, value.getEncodedBytes(), 0, valueSize);
                        value.setEncodedSize(valueSize);
                        if (value.getEncodedSize() >= 120 && (value.getEncodedBytes()[0] & 0xFF) == 255) {
                            if (bb == this._support.getReadBuffer()) {
                                end = recordSize - (position - start);
                                bb = ByteBuffer.allocate(end);
                                bb.put(this._support.getReadBuffer().array(), position, end);
                                bb.flip();
                                position = 0;
                            }
                            if (listener.requiresLongRecordConversion()) {
                                this._support.convertToLongRecord(value, treeHandle, address, commitTimestamp);
                            }
                        }
                        listener.store(address, startTimestamp, exchange);
                        this.appliedUpdates.incrementAndGet();
                        if (exchange.getValue().getMaximumSize() >= 0x400000) continue block10;
                        this.releaseExchange(exchange);
                        break;
                    }
                    case 17490: {
                        int key1Size = JournalRecord.DR.getKey1Size(bb);
                        int elisionCount = JournalRecord.DR.getKey2Elision(bb);
                        Exchange exchange = this.getExchange(JournalRecord.DR.getTreeHandle(bb), address, startTimestamp);
                        exchange.ignoreTransactions();
                        Key key1 = exchange.getAuxiliaryKey3();
                        Key key2 = exchange.getAuxiliaryKey4();
                        System.arraycopy(bb.array(), bb.position() + 16, key1.getEncodedBytes(), 0, key1Size);
                        key1.setEncodedSize(key1Size);
                        int key2Size = innerSize - 16 - key1Size;
                        System.arraycopy(key1.getEncodedBytes(), 0, key2.getEncodedBytes(), 0, elisionCount);
                        System.arraycopy(bb.array(), bb.position() + 16 + key1Size, key2.getEncodedBytes(), elisionCount, key2Size);
                        key2.setEncodedSize(key2Size + elisionCount);
                        listener.removeKeyRange(address, startTimestamp, exchange, key1, key2);
                        this.appliedUpdates.incrementAndGet();
                        this.releaseExchange(exchange);
                        break;
                    }
                    case 17492: {
                        Exchange exchange = this.getExchange(JournalRecord.DT.getTreeHandle(bb), address, startTimestamp);
                        listener.removeTree(address, startTimestamp, exchange);
                        this.appliedUpdates.incrementAndGet();
                        this.releaseExchange(exchange);
                        break;
                    }
                    case 17456: {
                        Exchange exchange = this.getExchange(JournalRecord.D0.getTreeHandle(bb), address, startTimestamp);
                        listener.delta(address, commitTimestamp, exchange.getTree(), JournalRecord.D0.getIndex(bb), JournalRecord.D0.getAccumulatorTypeOrdinal(bb), 1L);
                        this.appliedUpdates.incrementAndGet();
                        break;
                    }
                    case 17457: {
                        Exchange exchange = this.getExchange(JournalRecord.D1.getTreeHandle(bb), address, startTimestamp);
                        listener.delta(address, startTimestamp, exchange.getTree(), JournalRecord.D1.getIndex(bb), JournalRecord.D1.getAccumulatorTypeOrdinal(bb), JournalRecord.D1.getValue(bb));
                        this.appliedUpdates.incrementAndGet();
                        break;
                    }
                    default: {
                        throw new CorruptJournalException("Invalid record type " + type + " at journal address " + TransactionPlayer.addressToString(address + (long)position - (long)start) + " index of transaction record at " + TransactionPlayer.addressToString(address));
                    }
                }
                continue;
            }
            catch (VolumeNotFoundException vnfe) {
                Persistit db = this._support.getPersistit();
                if (db.getJournalManager().isIgnoreMissingVolumes()) {
                    db.getAlertMonitor().post(new AlertMonitor.Event(AlertMonitor.AlertLevel.WARN, db.getLogBase().missingVolume, vnfe.getMessage(), address + (long)position - (long)start), "MissingVolume");
                    this.ignoredUpdates.incrementAndGet();
                    continue;
                }
                this.failedUpdates.incrementAndGet();
                throw vnfe;
            }
            catch (PersistitException e) {
                this.failedUpdates.incrementAndGet();
                throw e;
            }
        }
    }

    public static String addressToString(long address) {
        return String.format("JournalAddress %,d", address);
    }

    public static String addressToString(long address, long timestamp) {
        return String.format("JournalAddress %,d{%,d}", address, timestamp);
    }

    private Exchange getExchange(int treeHandle, long from, long timestamp) throws PersistitException {
        JournalManager.TreeDescriptor td = this._support.getPersistit().getJournalManager().lookupTreeHandle(treeHandle);
        if (td == null) {
            throw new CorruptJournalException("Tree handle " + treeHandle + " is undefined at " + TransactionPlayer.addressToString(from, timestamp));
        }
        Volume volume = this._support.getPersistit().getJournalManager().volumeForHandle(td.getVolumeHandle());
        if (volume == null) {
            throw new CorruptJournalException("Volume handle " + td.getVolumeHandle() + " is undefined at " + TransactionPlayer.addressToString(from, timestamp));
        }
        if ("_directory".equals(td.getTreeName())) {
            return volume.getStructure().directoryExchange();
        }
        Exchange exchange = this._support.getPersistit().getExchange(volume, td.getTreeName(), true);
        exchange.ignoreTransactions();
        return exchange;
    }

    private void releaseExchange(Exchange exchange) {
        this._support.getPersistit().releaseExchange(exchange);
    }

    long getAppliedUpdates() {
        return this.appliedUpdates.get();
    }

    long getIgnoredUpdates() {
        return this.ignoredUpdates.get();
    }

    long getFailedUpdates() {
        return this.failedUpdates.get();
    }

    static interface TransactionPlayerListener {
        public void startRecovery(long var1, long var3) throws PersistitException;

        public void startTransaction(long var1, long var3, long var5) throws PersistitException;

        public void store(long var1, long var3, Exchange var5) throws PersistitException;

        public void removeKeyRange(long var1, long var3, Exchange var5, Key var6, Key var7) throws PersistitException;

        public void removeTree(long var1, long var3, Exchange var5) throws PersistitException;

        public void delta(long var1, long var3, Tree var5, int var6, int var7, long var8) throws PersistitException;

        public void endTransaction(long var1, long var3) throws PersistitException;

        public void endRecovery(long var1, long var3) throws PersistitException;

        public boolean requiresLongRecordConversion();
    }
}

