/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Accumulator;
import com.persistit.TransactionIndex;
import com.persistit.TransactionIndexBucket;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

class TransactionStatus {
    static final long PRIMORDIAL = 0L;
    static final long ABORTED = Long.MIN_VALUE;
    static final long UNCOMMITTED = Long.MAX_VALUE;
    static final long TIMED_OUT = -9223372036854775807L;
    private final TransactionIndexBucket _bucket;
    private volatile long _ts;
    private volatile long _tc;
    private volatile long _ta;
    private AtomicInteger _mvvCount = new AtomicInteger();
    private final ReentrantLock _wwLock = new ReentrantLock(true);
    private TransactionStatus _next;
    private volatile TransactionStatus _depends;
    private volatile Accumulator.Delta _delta;
    private volatile boolean _notified;
    private volatile boolean _abandoned;

    TransactionStatus(TransactionIndexBucket bucket) {
        this._bucket = bucket;
    }

    TransactionStatus(TransactionStatus status) {
        this._bucket = status._bucket;
        this._mvvCount = status._mvvCount;
        this._notified = status._notified;
        this._ta = status._ta;
        this._tc = status._tc;
        this._ts = status._ts;
    }

    TransactionStatus getNext() {
        return this._next;
    }

    void setNext(TransactionStatus next) {
        this._next = next;
    }

    TransactionStatus getDepends() {
        return this._depends;
    }

    void setDepends(TransactionStatus depends) {
        this._depends = depends;
    }

    long getTs() {
        return this._ts;
    }

    long getTc() {
        return this._tc;
    }

    long getTa() {
        return this._ta;
    }

    boolean isNotified() {
        return this._notified;
    }

    void commit(long timestamp) {
        if (timestamp < this._ts || timestamp == Long.MAX_VALUE) {
            throw new IllegalArgumentException("Attempt to commit before start: " + this);
        }
        if (this._tc != Long.MAX_VALUE) {
            throw new IllegalArgumentException("Already committed or aborted: " + this);
        }
        this._tc = -timestamp;
    }

    void abort() {
        if (this._tc != Long.MAX_VALUE) {
            throw new IllegalArgumentException("Already committed or aborted: " + this);
        }
        this._tc = Long.MIN_VALUE;
    }

    void complete(long timestamp) {
        if (this._tc > 0L || -this._tc > timestamp && timestamp != Long.MIN_VALUE) {
            throw new IllegalStateException("Transaction not ready to complete: " + this);
        }
        if (this._tc < 0L && this._tc != Long.MIN_VALUE) {
            this._tc = timestamp;
        }
        this._notified = true;
    }

    void completeAndUnlock(long timestamp) {
        this.complete(timestamp);
        if (!this.isAbandoned()) {
            this.wwUnlock();
        }
    }

    boolean isLocked() {
        return this._wwLock.isLocked();
    }

    boolean isHeldByCurrentThread() {
        return this._wwLock.isHeldByCurrentThread();
    }

    Accumulator.Delta getDelta() {
        return this._delta;
    }

    void addDelta(Accumulator.Delta delta) {
        delta.setNext(this._delta);
        this._delta = delta;
    }

    Accumulator.Delta takeDelta() {
        Accumulator.Delta delta = this._delta;
        this._delta = null;
        return delta;
    }

    long accumulate(long value, Accumulator accumulator, int step) {
        long result = value;
        for (Accumulator.Delta delta = this._delta; delta != null; delta = delta.getNext()) {
            if (delta.getAccumulator() != accumulator || delta.getStep() >= step) continue;
            result = accumulator.applyValue(result, delta.getValue());
        }
        return result;
    }

    int incrementMvvCount() {
        this._ta = Long.MAX_VALUE;
        return this._mvvCount.incrementAndGet();
    }

    int decrementMvvCount() {
        assert (this._tc == Long.MIN_VALUE) : "can only decrement MVVs for an aborted transaction";
        int count = this._mvvCount.decrementAndGet();
        assert (count >= 0) : "mvvCount is negative";
        if (count == 0) {
            this._ta = this._bucket.getTimestampAllocator().getCurrentTimestamp();
        }
        return count;
    }

    int getMvvCount() {
        return this._mvvCount.get();
    }

    void setMvvCount(int count) {
        this._mvvCount.set(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void briefLock(long timeout) throws InterruptedException {
        boolean locked = false;
        try {
            locked = this.wwLock(timeout);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (locked) {
                this.wwUnlock();
            }
        }
    }

    boolean wwLock(long timeout) throws InterruptedException {
        return this._wwLock.tryLock(timeout, TimeUnit.MILLISECONDS);
    }

    void wwUnlock() {
        assert (!this.isAbandoned()) : "Attempt to unlock abandoned: " + this;
        this._wwLock.unlock();
    }

    void initialize(long ts) {
        this._ts = ts;
        this._tc = Long.MAX_VALUE;
        this._ta = 0L;
        this._next = null;
        this._delta = null;
        this._mvvCount.set(0);
        this._notified = false;
    }

    void initializeAsAborted(long ts) {
        this.initialize(ts);
        this.abort();
        this.setMvvCount(Integer.MAX_VALUE);
        this._notified = true;
    }

    void markAbandoned() {
        this._abandoned = true;
    }

    boolean isAbandoned() {
        return this._abandoned;
    }

    public String toString() {
        return String.format("<ts=%,d tc=%s mvv=%,d>", this._ts, TransactionStatus.tcString(this._tc), this._mvvCount.get());
    }

    static String versionString(long version) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%,d", TransactionIndex.vh2ts(version)));
        int step = TransactionIndex.vh2step(version);
        if (step > 0) {
            sb.append(String.format("#%02d", step));
        }
        return sb.toString();
    }

    static String tcString(long ts) {
        if (ts == Long.MIN_VALUE) {
            return "ABORTED";
        }
        if (ts == Long.MAX_VALUE) {
            return "UNCOMMITTED";
        }
        return String.format("%,d", ts);
    }
}

