/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.logging;

import com.persistit.logging.PersistitLevel;
import com.persistit.logging.PersistitLogger;
import java.util.EnumMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4JAdapter
implements PersistitLogger {
    private static final EnumMap<PersistitLevel, Level> LEVEL_MAP = new EnumMap(PersistitLevel.class);
    private final Logger _logger;

    public Log4JAdapter(Logger logger) {
        this._logger = logger;
    }

    @Override
    public boolean isLoggable(PersistitLevel level) {
        return this._logger.isEnabledFor((Priority)LEVEL_MAP.get((Object)level));
    }

    @Override
    public void log(PersistitLevel level, String message) {
        this._logger.log((Priority)LEVEL_MAP.get((Object)level), (Object)message);
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    static {
        LEVEL_MAP.put(PersistitLevel.NONE, Level.OFF);
        LEVEL_MAP.put(PersistitLevel.TRACE, Level.TRACE);
        LEVEL_MAP.put(PersistitLevel.DEBUG, Level.DEBUG);
        LEVEL_MAP.put(PersistitLevel.INFO, Level.INFO);
        LEVEL_MAP.put(PersistitLevel.WARNING, Level.WARN);
        LEVEL_MAP.put(PersistitLevel.ERROR, Level.ERROR);
    }
}

