/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.mxbeans;

import com.persistit.exception.PersistitException;
import com.persistit.mxbeans.Description;
import javax.management.MXBean;

@MXBean
public interface JournalManagerMXBean {
    public static final String MXBEAN_NAME = "com.persistit:type=Persistit,class=JournalManager";
    public static final int VERSION = 2;
    public static final long DEFAULT_BLOCK_SIZE = 1000000000L;
    public static final long MINIMUM_BLOCK_SIZE = 10000000L;
    public static final long MAXIMUM_BLOCK_SIZE = 100000000000L;
    public static final long ROLLOVER_THRESHOLD = 0x400000L;
    public static final int DEFAULT_BUFFER_SIZE = 0x1000000;
    public static final int MINIMUM_BUFFER_SIZE = 65536;
    public static final int MAXIMUM_BUFFER_SIZE = 0xA000000;
    public static final int DEFAULT_COPY_BUFFER_SIZE = 0x1000000;
    public static final long DEFAULT_FLUSH_INTERVAL_MS = 100L;
    public static final long DEFAULT_COPIER_INTERVAL_MS = 10000L;
    public static final int DEFAULT_URGENT_FILE_COUNT_THRESHOLD = 15;
    public static final int MINIMUM_URGENT_FILE_COUNT_THRESHOLD = 5;
    public static final int MAXIMUM_URGENT_FILE_COUNT_THRESHOLD = 100;
    public static final int DEFAULT_COPIES_PER_CYCLE = 1000;
    public static final long DEFAULT_LOG_REPEAT_INTERVAL_MS = 60000L;
    public static final long MINIMUM_LOG_REPEAT_INTERVAL_MS = 1000L;
    public static final long MAXIMUM_LOG_REPEAT_INTERVAL_MS = Long.MAX_VALUE;
    public static final long DEFAULT_SLOW_IO_ALERT_THRESHOLD_MS = 2000L;
    public static final long MINIMUM_SLOW_ALERT_THRESHOLD_MS = 100L;
    public static final long MAXIMUM_SLOW_ALERT_THRESHOLD_MS = Long.MAX_VALUE;
    public static final String DEFAULT_JOURNAL_FILE_NAME = "persistit_journal";
    public static final String PATH_FORMAT = "%s.%012d";
    public static final int MAXIMUM_CONCURRENT_TRANSACTIONS = 10000;

    @Description(value="Number of transaction map items in the live map")
    public int getLiveTransactionMapSize();

    @Description(value="Number of unique pages currently stored in the journal")
    public int getPageMapSize();

    @Description(value="Number of unique page versions currently stored in the journal")
    public int getPageListSize();

    @Description(value="Address of first record in the journal required for recovery")
    public long getBaseAddress();

    @Description(value="Address of next record to be written")
    public long getCurrentAddress();

    @Description(value="Maximum size of one journal file")
    public long getBlockSize();

    @Description(value="True if copying of pages from the journal to their destination volumes is disabled")
    public boolean isAppendOnly();

    @Description(value="True to allow journal to lose pages from missing volumes")
    public boolean isIgnoreMissingVolumes();

    @Description(value="True if copy-fast mode has been enabled")
    public boolean isCopyingFast();

    @Description(value="True if copying of pages from the journal to their destination volumes is disabled")
    public void setAppendOnly(boolean var1);

    @Description(value="True to allow journal to lose pages from missing volumes")
    public void setIgnoreMissingVolumes(boolean var1);

    @Description(value="True if copy-fast mode has been enabled")
    public void setCopyingFast(boolean var1);

    @Description(value="Interval between data flush cycles in milliseconds")
    public long getFlushInterval();

    @Description(value="Interval between data flush cycles in milliseconds")
    public void setFlushInterval(long var1);

    @Description(value="Interval between page copying cycles")
    public long getCopierInterval();

    @Description(value="Interval between page copying cycles")
    public void setCopierInterval(long var1);

    @Description(value="True if the journal has been closed")
    public boolean isClosed();

    @Description(value="True if the JOURNAL_COPIER thread is currently active")
    public boolean isCopying();

    @Description(value="File path where journal files are written")
    public String getJournalFilePath();

    @Description(value="Total number of page images read from the journal")
    public long getReadPageCount();

    @Description(value="Total number of page images written to the journal")
    public long getJournaledPageCount();

    @Description(value="Total number of page images copied from the journal to their destination volumes")
    public long getCopiedPageCount();

    @Description(value="Total number of page images pages dropped from the journal due the existence of newer versions")
    public long getDroppedPageCount();

    @Description(value="System time when journal was first created")
    public long getJournalCreatedTime();

    @Description(value="Timestamp value when the most recently valid checkpoint was created")
    public long getLastValidCheckpointTimestamp();

    @Description(value="Current timestamp value")
    public long getCurrentTimestamp();

    @Description(value="True to enable pruning of rolled-back transactions")
    public void setRollbackPruningEnabled(boolean var1);

    @Description(value="True to enable pruning of rolled-back transactions")
    public boolean isRollbackPruningEnabled();

    @Description(value="True to enable pruning when writing pages to journal")
    public void setWritePagePruningEnabled(boolean var1);

    @Description(value="True to enable pruning when writing pages to journal")
    public boolean isWritePagePruningEnabled();

    @Description(value="Degree of urgency for copying pages: 0-10")
    public int urgency();

    @Description(value="Flush all pending journal records to durable storage")
    public void force() throws PersistitException;

    @Description(value="Perform accelerated page copying")
    public void copyBack() throws Exception;

    @Description(value="String value of last Exception encountered by the JOURNAL_COPIER thread")
    public String getLastCopierException();

    @Description(value="String value of last Exception encountered by the JOURNAL_FLUSHER thread")
    public String getLastFlusherException();

    @Description(value="System time when the most recently valid checkpoint was created")
    public long getLastValidCheckpointTimeMillis();

    @Description(value="Total number of transaction commit records written to the journal")
    public long getTotalCompletedCommits();

    @Description(value="Total aggregate time spent waiting for durable commits in milliseconds")
    public long getCommitCompletionWaitTime();

    @Description(value="Threshold in  milliseconds for warnings of long duration flush cycles")
    public long getSlowIoAlertThreshold();

    @Description(value="Threshold in  milliseconds for warnings of long duration flush cycles")
    public void setSlowIoAlertThreshold(long var1);

    @Description(value="Journal file count threshold for throttling transactions")
    public int getUrgentFileCountThreshold();

    @Description(value="Journal file count threshold for throttling transactions")
    public void setUrgentFileCountThreshold(int var1);
}

