/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.policy;

import com.persistit.Buffer;

public class JoinPolicy {
    public static final JoinPolicy LEFT_BIAS = new JoinPolicy(-1, "LEFT");
    public static final JoinPolicy RIGHT_BIAS = new JoinPolicy(1, "RIGHT");
    public static final JoinPolicy EVEN_BIAS = new JoinPolicy(0, "EVEN");
    private static final JoinPolicy[] POLICIES = new JoinPolicy[]{LEFT_BIAS, RIGHT_BIAS, EVEN_BIAS};
    String _name;
    int _bias;

    public static JoinPolicy forName(String name) {
        for (JoinPolicy policy : POLICIES) {
            if (!policy.toString().equalsIgnoreCase(name)) continue;
            return policy;
        }
        throw new IllegalArgumentException("No such SplitPolicy " + name);
    }

    protected JoinPolicy(int bias, String name) {
        this._bias = bias;
        this._name = name;
    }

    public int rebalanceFit(Buffer leftBuffer, Buffer rightBuffer, int kbOffset, int foundAt1, int foundAt2, int virtualSize, int leftSize, int rightSize, int capacity) {
        int fitness;
        if (leftSize > capacity || rightSize > capacity) {
            return 0;
        }
        switch (this._bias) {
            case -1: {
                fitness = leftSize;
                break;
            }
            case 0: {
                int difference = rightSize - leftSize;
                if (difference < 0) {
                    difference = -difference;
                }
                fitness = capacity - difference;
                break;
            }
            case 1: {
                fitness = rightSize;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid bias");
            }
        }
        return fitness;
    }

    public boolean acceptJoin(Buffer buffer, int virtualSize) {
        return virtualSize < buffer.getBufferSize();
    }

    public String getName() {
        return this._name;
    }
}

