/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.Management;
import com.persistit.ui.AdminCommand;
import com.persistit.ui.AdminPanel;
import com.persistit.ui.AdminUI;
import com.persistit.ui.InspectorPanel;
import com.persistit.ui.ManagementListModel;
import com.persistit.ui.ManagementSlidingTableModel;
import com.persistit.ui.ManagementTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AdminUITreePanel
extends AdminPanel
implements AdminCommand {
    AdminUI _adminUI;
    private static final String PROTOTYPE_VOLUME_NAME = "c:/this/that/and/the/other/persistit";
    private static double TOP_SPLITPANE_RESIZE_WEIGHT = 0.25;
    private static double BOTTOM_SPLITPANE_RESIZE_WEIGHT = 0.85;
    private static double MAIN_SPLITPANE_RESIZE_WEIGHT = 0.25;
    private ManagementListModel _volumeInfoArrayModel;
    private ManagementTableModel _treeInfoArrayModel;
    private ManagementSlidingTableModel _logicalRecordArrayModel;
    private final Map _menuMap = new TreeMap();
    private boolean _refreshing;
    private JPanel _volumePanel;
    private JPanel _treePanel;
    private JPanel _dataPanel;
    private InspectorPanel _inspectorPanel;
    private AdminUI.AdminAction _displayAction;
    private JTextField _filterTextField;
    private JList _volumeList;
    private JTable _treeTable;
    private JTable _dataTable;
    private String _selectedVolumeName;
    private String _selectedTreeName;
    private JButton _displayButton;

    @Override
    protected void setup(AdminUI ui) throws NoSuchMethodException, RemoteException {
        this._adminUI = ui;
        this._volumePanel = new JPanel(new BorderLayout());
        this._treePanel = new JPanel(new BorderLayout());
        this._dataPanel = new JPanel(new BorderLayout());
        this._inspectorPanel = new InspectorPanel(ui);
        this._volumeInfoArrayModel = new ManagementListModel();
        this._volumeList = new JList(this._volumeInfoArrayModel);
        this._volumeList.setPrototypeCellValue(PROTOTYPE_VOLUME_NAME);
        this._treeInfoArrayModel = new ManagementTableModel(Management.TreeInfo.class, "TreeInfo", ui);
        this._treeTable = new JTable(this._treeInfoArrayModel);
        this._treeTable.setAutoCreateRowSorter(true);
        this._treeTable.setPreferredScrollableViewportSize(new Dimension(500, 50));
        this._treeTable.setAutoCreateColumnsFromModel(false);
        this._treeTable.setSelectionMode(0);
        this._treeInfoArrayModel.formatColumns(this._treeTable, null);
        this._volumeList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                int index = AdminUITreePanel.this._volumeList.getSelectedIndex();
                if (!lse.getValueIsAdjusting() && !AdminUITreePanel.this._refreshing && index >= 0) {
                    Management.VolumeInfo[] array = (Management.VolumeInfo[])AdminUITreePanel.this._volumeInfoArrayModel.getInfoArray();
                    if (array != null && index < array.length) {
                        AdminUITreePanel.this.selectVolume(array[index]);
                    } else {
                        AdminUITreePanel.this.selectVolume(null);
                    }
                    AdminUITreePanel.this._adminUI.scheduleRefresh(-1);
                }
            }
        });
        this._treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                Management.TreeInfo[] array;
                boolean changed;
                int index = AdminUITreePanel.this._treeTable.getSelectedRow();
                if (!lse.getValueIsAdjusting() && !AdminUITreePanel.this._refreshing && index >= 0 && (changed = (array = (Management.TreeInfo[])AdminUITreePanel.this._treeInfoArrayModel.getInfoArray()) != null && index < array.length ? AdminUITreePanel.this.selectTree(array[index]) : AdminUITreePanel.this.selectTree(null))) {
                    AdminUITreePanel.this._adminUI.scheduleRefresh(-1);
                }
            }
        });
        this._logicalRecordArrayModel = new ManagementSlidingTableModel(Management.LogicalRecord.class, "LogicalRecord", ui);
        this._dataTable = new JTable(this._logicalRecordArrayModel){

            @Override
            public void repaint(Rectangle drawRect) {
                if (!AdminUITreePanel.this._logicalRecordArrayModel.isDeletingRows()) {
                    super.repaint(drawRect);
                }
            }
        };
        this._dataTable.setCellSelectionEnabled(true);
        this._dataTable.setPreferredScrollableViewportSize(new Dimension(600, 300));
        this._dataTable.setAutoCreateColumnsFromModel(false);
        this._dataTable.setSelectionMode(1);
        this._logicalRecordArrayModel.formatColumns(this._dataTable, null);
        JScrollPane volumeScrollPane = new JScrollPane(this._volumeList);
        volumeScrollPane.setBorder(null);
        this._volumePanel.setBorder(this._adminUI.createTitledBorder("TreePanel.volumes"));
        this._volumePanel.add((Component)volumeScrollPane, "Center");
        JScrollPane treeScrollPane = new JScrollPane(this._treeTable);
        treeScrollPane.setBorder(null);
        this._treePanel.setBorder(this._adminUI.createTitledBorder("TreePanel.trees"));
        this._treePanel.add((Component)treeScrollPane, "Center");
        JScrollPane dataScrollPane = new JScrollPane(this._dataTable);
        dataScrollPane.setBorder(null);
        this._dataPanel.setBorder(this._adminUI.createTitledBorder("TreePanel.data"));
        this._dataPanel.add((Component)dataScrollPane, "Center");
        this._inspectorPanel.setBorder(this._adminUI.createTitledBorder("TreePanel.inspector"));
        JSplitPane topSplitPane = new JSplitPane(1);
        topSplitPane.setResizeWeight(TOP_SPLITPANE_RESIZE_WEIGHT);
        JSplitPane bottomSplitPane = new JSplitPane(0);
        bottomSplitPane.setResizeWeight(BOTTOM_SPLITPANE_RESIZE_WEIGHT);
        bottomSplitPane.setOneTouchExpandable(true);
        topSplitPane.add(this._volumePanel);
        topSplitPane.add(this._treePanel);
        bottomSplitPane.add(this._dataPanel);
        bottomSplitPane.add(this._inspectorPanel);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)topSplitPane, "Center");
        topPanel.add((Component)this.createDataSelectorPanel(), "South");
        JSplitPane mainSplitPane = new JSplitPane(0);
        mainSplitPane.setResizeWeight(MAIN_SPLITPANE_RESIZE_WEIGHT);
        mainSplitPane.add(topPanel);
        mainSplitPane.add(bottomSplitPane);
        this.setLayout(new BorderLayout());
        this._adminUI.registerTextComponent(this._dataTable);
        this._adminUI.registerTextComponent(this._filterTextField);
        this.add((Component)mainSplitPane, "Center");
        this._adminUI.scheduleRefresh(-1);
    }

    JPanel createDataSelectorPanel() {
        JPanel panel = new JPanel(new BorderLayout(3, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this._displayAction = this._adminUI.createAction(this, this._adminUI.getProperty("TreePanel.display"));
        this._displayButton = new JButton(this._displayAction);
        this._displayAction.addButton(this._displayButton);
        this._filterTextField = new JTextField();
        JLabel label = new JLabel(this._adminUI.getProperty("TreePanel.filterCaption"));
        JPanel filterPanel = new JPanel(new BorderLayout());
        filterPanel.add((Component)label, "West");
        filterPanel.add((Component)this._filterTextField, "Center");
        label.setFont(this._adminUI.getBoldFont());
        label.setForeground(this._adminUI.getPersistitAccentColor());
        panel.add((Component)this._displayButton, "West");
        panel.add((Component)filterPanel, "Center");
        JMenuItem displayMenuItem = new JMenuItem(this._displayAction);
        JMenuItem[] menus = new JMenuItem[]{displayMenuItem};
        this._menuMap.put("VIEW.1", menus);
        this._menuMap.put("VIEW.2", this._adminUI.createMenuArray(this._adminUI, "TreePanelMenu", "VIEW"));
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                Management.LogicalRecord lr;
                int row = AdminUITreePanel.this._dataTable.getSelectedRow();
                int column = AdminUITreePanel.this._dataTable.getSelectedColumn();
                if (row >= 0 && column >= 0 && (lr = (Management.LogicalRecord)AdminUITreePanel.this._logicalRecordArrayModel.getValueAt(row, -1)) != null) {
                    AdminUITreePanel.this._inspectorPanel.setLogicalRecord(AdminUITreePanel.this._selectedVolumeName, AdminUITreePanel.this._selectedTreeName, lr);
                    AdminUITreePanel.this._inspectorPanel.setShowValue(column == 1);
                    AdminUITreePanel.this._inspectorPanel.refreshed();
                }
            }
        };
        this._dataTable.getSelectionModel().addListSelectionListener(listener);
        this._dataTable.getColumnModel().getSelectionModel().addListSelectionListener(listener);
        return panel;
    }

    @Override
    public void actionPerformed(AdminUI.AdminAction action, ActionEvent ae) {
        String name = action.getName();
        if ("DISPLAY".equals(name)) {
            this._dataTable.scrollRectToVisible(new Rectangle(0, 0));
            this._logicalRecordArrayModel.set(this._selectedVolumeName, this._selectedTreeName, this._filterTextField.getText());
        }
    }

    private void selectVolume(Management.VolumeInfo volumeInfo) {
        String newName;
        String string = newName = volumeInfo == null ? null : volumeInfo.getName();
        if (!this.equals(newName, this._selectedVolumeName)) {
            this._logicalRecordArrayModel.setInfoArray(null);
            this._selectedTreeName = null;
            this._selectedVolumeName = newName;
        }
    }

    private boolean selectTree(Management.TreeInfo treeInfo) {
        String newName;
        String string = newName = treeInfo == null ? null : treeInfo.getName();
        if (!this.equals(newName, this._selectedTreeName)) {
            this._logicalRecordArrayModel.setInfoArray(null);
            this._selectedTreeName = newName;
            return true;
        }
        return false;
    }

    private boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refresh(boolean reset) {
        AdminUITreePanel adminUITreePanel = this;
        synchronized (adminUITreePanel) {
            if (this._refreshing) {
                return;
            }
            this._refreshing = true;
        }
        try {
            Management management = this._adminUI.getManagement();
            if (reset) {
                this._selectedTreeName = null;
                this._selectedVolumeName = null;
                this._logicalRecordArrayModel.setInfoArray(null);
            }
            Object[] volumeInfoArray = null;
            if (management != null) {
                volumeInfoArray = management.getVolumeInfoArray();
            }
            this._volumeInfoArrayModel.setInfoArray(volumeInfoArray);
            Management.TreeInfo[] treeInfoArray = null;
            if (management != null && this._selectedVolumeName != null) {
                treeInfoArray = management.getTreeInfoArray(this._selectedVolumeName);
            }
            this._treeInfoArrayModel.setInfoArray(treeInfoArray);
            if (this._selectedTreeName != null) {
                for (int index = 0; index < treeInfoArray.length; ++index) {
                    if (!this._selectedTreeName.equals(treeInfoArray[index].getName())) continue;
                    this._treeTable.getSelectionModel().setSelectionInterval(index, index);
                }
            }
            this._displayAction.setEnabled(this._selectedVolumeName != null && this._selectedTreeName != null);
            this._inspectorPanel.refresh(reset);
        }
        catch (RemoteException re) {
            this._adminUI.postException(re);
        }
        finally {
            AdminUITreePanel adminUITreePanel2 = this;
            synchronized (adminUITreePanel2) {
                this._refreshing = false;
            }
        }
    }

    @Override
    protected Map getMenuMap() {
        return this._menuMap;
    }

    @Override
    protected void setDefaultButton() {
        this.getRootPane().setDefaultButton(this._displayButton);
    }
}

