/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.ui.AdminPanel;
import com.persistit.ui.AdminUI;
import com.persistit.ui.TreeAndVolumeSelector;
import java.awt.FlowLayout;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TaskSetupPanel
extends Box {
    private final AdminUI _adminUI;
    private final String _commandName;
    private final String _taskName;
    private final List<ParameterComponent> _generalParameterDescriptors = new ArrayList<ParameterComponent>();
    private final List<ParameterComponent> _taskSpecificParameterDescriptors = new ArrayList<ParameterComponent>();
    private final String _yesMessage;
    private final String _noMessage;

    public TaskSetupPanel(AdminUI ui, String taskSpecification) throws Exception {
        super(1);
        ParameterComponent pd;
        String parameterSpec;
        this._adminUI = ui;
        this._yesMessage = ui.getProperty("YesMessage");
        this._noMessage = ui.getProperty("NoMessage");
        String generalParameters = ui.getProperty("TaskDescriptor.General");
        StringTokenizer st = new StringTokenizer(generalParameters, ",");
        while (st.hasMoreTokens()) {
            parameterSpec = st.nextToken();
            pd = this.taskParameterDescription(parameterSpec);
            this._generalParameterDescriptors.add(pd);
        }
        st = new StringTokenizer(taskSpecification, ",");
        this._taskName = st.nextToken();
        this._commandName = st.nextToken();
        while (st.hasMoreTokens()) {
            parameterSpec = st.nextToken();
            pd = this.taskParameterDescription(parameterSpec);
            this._taskSpecificParameterDescriptors.add(pd);
        }
        this.setDescriptionString(this._taskName);
        this.setOwnerString(this._adminUI.getHostName());
    }

    ParameterComponent taskParameterDescription(String parameterSpec) {
        StringTokenizer st2 = new StringTokenizer(parameterSpec, ":");
        String name = st2.nextToken();
        String type = st2.nextToken();
        String caption = st2.nextToken();
        JLabel label = new JLabel(caption);
        label.setFont(this._adminUI.getBoldFont());
        label.setForeground(this._adminUI.getPersistitAccentColor());
        JPanel labelPanel = this.offsetPanel(0);
        labelPanel.add(label);
        labelPanel.add(Box.createHorizontalGlue());
        this.add(labelPanel);
        JPanel panel = this.offsetPanel(10);
        if ("STRING".equals(type) || "LINE".equals(type)) {
            int columns = 50;
            if (st2.hasMoreTokens()) {
                columns = Integer.parseInt(st2.nextToken());
            }
            String dflt = "";
            if (st2.hasMoreElements()) {
                dflt = st2.nextToken();
            }
            JTextField textField = new JTextField(dflt, columns);
            panel.add(textField);
            panel.add(Box.createHorizontalGlue());
            this.add(panel);
            return new ParameterComponent(name, type, textField);
        }
        if ("TREES".equals(type)) {
            TreeAndVolumeSelector tavSelector = new TreeAndVolumeSelector();
            tavSelector.setup(this._adminUI);
            panel.add(tavSelector);
            this.add(panel);
            panel.add(Box.createHorizontalGlue());
            return new ParameterComponent(name, type, tavSelector);
        }
        if ("BOOLEAN".equals(type)) {
            JRadioButton yesButton = new JRadioButton(this._yesMessage);
            JRadioButton noButton = new JRadioButton(this._noMessage);
            ButtonGroup group = new ButtonGroup();
            group.add(yesButton);
            group.add(noButton);
            String dflt = "false";
            if (st2.hasMoreTokens()) {
                dflt = st2.nextToken();
            }
            if ("true".equals(dflt)) {
                yesButton.setSelected(true);
            } else {
                noButton.setSelected(true);
            }
            panel.add(yesButton);
            panel.add(noButton);
            panel.add(Box.createHorizontalGlue());
            this.add(panel);
            return new ParameterComponent(name, type, yesButton);
        }
        if ("INTEGER".equals(type)) {
            String dflt = "";
            if (st2.hasMoreTokens()) {
                dflt = st2.nextToken();
            }
            JTextField textField = new JTextField(10);
            textField.setDocument(new PlainDocument(){

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    boolean okay = true;
                    for (int index = 0; index < str.length() && okay; ++index) {
                        if (Character.isDigit(str.charAt(index))) continue;
                        okay = false;
                    }
                    if (okay) {
                        super.insertString(offs, str, a);
                    }
                }
            });
            textField.setText(dflt);
            panel.add(textField);
            panel.add(Box.createHorizontalGlue());
            this.add(panel);
            return new ParameterComponent(name, type, textField);
        }
        throw new RuntimeException("Misconfigured admin properties: no such task parameter type " + type);
    }

    JPanel offsetPanel(int size) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 2, 2));
        if (size > 0) {
            panel.add(Box.createHorizontalStrut(size));
        }
        return panel;
    }

    void refresh(boolean reset) throws RemoteException {
        for (int index = 0; index < this._taskSpecificParameterDescriptors.size(); ++index) {
            ParameterComponent pc = this._taskSpecificParameterDescriptors.get(index);
            if (!(pc._component instanceof AdminPanel)) continue;
            ((AdminPanel)pc._component).refresh(reset);
        }
    }

    String getTaskName() {
        return this._taskName;
    }

    String getCommandName() {
        return this._commandName;
    }

    String getCommandLine() {
        StringBuilder sb = new StringBuilder(this._commandName);
        for (ParameterComponent pc : this._taskSpecificParameterDescriptors) {
            sb.append(' ');
            if ("BOOLEAN".equals(pc._type)) {
                String flag = pc._name;
                boolean invert = flag.endsWith("~");
                if (!(invert ^ pc.getBooleanValue())) continue;
                sb.append("-");
                sb.append(flag.charAt(0));
                continue;
            }
            if ("LINE".equals(pc._type)) {
                sb.setLength(0);
                sb.append(pc.getStringValue());
                continue;
            }
            sb.append(pc._name);
            sb.append('=');
            if ("INTEGER".equals(pc._type)) {
                sb.append(pc.getIntValue());
                continue;
            }
            sb.append(pc.getStringValue());
        }
        return sb.toString();
    }

    String[] argStrings() {
        String[] results = new String[this._taskSpecificParameterDescriptors.size()];
        for (int index = 0; index < results.length; ++index) {
            ParameterComponent pc = this._taskSpecificParameterDescriptors.get(index);
            results[index] = pc.getStringValue();
        }
        return results;
    }

    String getDescriptionString() {
        ParameterComponent pc = this._generalParameterDescriptors.get(0);
        return pc.getStringValue();
    }

    void setDescriptionString(String description) {
        ParameterComponent pc = this._generalParameterDescriptors.get(0);
        pc.setStringValue(description);
    }

    String getOwnerString() {
        ParameterComponent pc = this._generalParameterDescriptors.get(1);
        return pc.getStringValue();
    }

    void setOwnerString(String owner) {
        ParameterComponent pc = this._generalParameterDescriptors.get(1);
        pc.setStringValue(owner);
    }

    boolean isVerboseEnabled() {
        ParameterComponent pc = this._generalParameterDescriptors.get(2);
        return pc.getBooleanValue();
    }

    long getExpirationTime() {
        ParameterComponent pc = this._generalParameterDescriptors.get(3);
        return (long)pc.getIntValue() * 1000L;
    }

    private static class ParameterComponent {
        String _name;
        String _type;
        JComponent _component;

        ParameterComponent(String name, String type, JComponent component) {
            this._name = name;
            this._type = type;
            this._component = component;
        }

        void setStringValue(String s) {
            if ("STRING".equals(this._type) || "INTEGER".equals(this._type) || "LINE".equals(this._type)) {
                ((JTextField)this._component).setText(s);
            }
        }

        String getStringValue() {
            if ("STRING".equals(this._type) || "INTEGER".equals(this._type) || "LINE".equals(this._type)) {
                return ((JTextField)this._component).getText();
            }
            if ("BOOLEAN".equals(this._type)) {
                return ((JRadioButton)this._component).isSelected() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
            }
            if ("TREES".equals(this._type)) {
                return ((TreeAndVolumeSelector)this._component).getTreeListString();
            }
            throw new RuntimeException();
        }

        boolean getBooleanValue() {
            if ("BOOLEAN".equals(this._type)) {
                return ((JRadioButton)this._component).isSelected();
            }
            throw new RuntimeException();
        }

        int getIntValue() {
            if ("INTEGER".equals(this._type)) {
                return Integer.parseInt(((JTextField)this._component).getText());
            }
            throw new RuntimeException();
        }
    }
}

