/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.serializer.ASMSerializerFactory;
import com.alibaba.fastjson.serializer.AppendableSerializer;
import com.alibaba.fastjson.serializer.AtomicBooleanSerializer;
import com.alibaba.fastjson.serializer.AtomicIntegerArraySerializer;
import com.alibaba.fastjson.serializer.AtomicIntegerSerializer;
import com.alibaba.fastjson.serializer.AtomicLongArraySerializer;
import com.alibaba.fastjson.serializer.AtomicLongSerializer;
import com.alibaba.fastjson.serializer.AtomicReferenceSerializer;
import com.alibaba.fastjson.serializer.BigDecimalSerializer;
import com.alibaba.fastjson.serializer.BigIntegerSerializer;
import com.alibaba.fastjson.serializer.BooleanArraySerializer;
import com.alibaba.fastjson.serializer.BooleanSerializer;
import com.alibaba.fastjson.serializer.ByteArraySerializer;
import com.alibaba.fastjson.serializer.ByteSerializer;
import com.alibaba.fastjson.serializer.CharArraySerializer;
import com.alibaba.fastjson.serializer.CharacterSerializer;
import com.alibaba.fastjson.serializer.CharsetSerializer;
import com.alibaba.fastjson.serializer.ClassSerializer;
import com.alibaba.fastjson.serializer.DateFormatSerializer;
import com.alibaba.fastjson.serializer.DoubleArraySerializer;
import com.alibaba.fastjson.serializer.DoubleSerializer;
import com.alibaba.fastjson.serializer.FileSerializer;
import com.alibaba.fastjson.serializer.FloatArraySerializer;
import com.alibaba.fastjson.serializer.FloatSerializer;
import com.alibaba.fastjson.serializer.InetAddressSerializer;
import com.alibaba.fastjson.serializer.InetSocketAddressSerializer;
import com.alibaba.fastjson.serializer.IntArraySerializer;
import com.alibaba.fastjson.serializer.IntegerSerializer;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.LocaleSerializer;
import com.alibaba.fastjson.serializer.LongArraySerializer;
import com.alibaba.fastjson.serializer.LongSerializer;
import com.alibaba.fastjson.serializer.ObjectArraySerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PatternSerializer;
import com.alibaba.fastjson.serializer.ShortArraySerializer;
import com.alibaba.fastjson.serializer.ShortSerializer;
import com.alibaba.fastjson.serializer.StringSerializer;
import com.alibaba.fastjson.serializer.TimeZoneSerializer;
import com.alibaba.fastjson.serializer.URISerializer;
import com.alibaba.fastjson.serializer.URLSerializer;
import com.alibaba.fastjson.serializer.UUIDSerializer;
import com.alibaba.fastjson.util.ASMClassLoader;
import com.alibaba.fastjson.util.ASMUtils;
import com.alibaba.fastjson.util.IdentityHashMap;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializeConfig
extends IdentityHashMap<Type, ObjectSerializer> {
    private static final SerializeConfig globalInstance = new SerializeConfig();
    private boolean asm = !ASMUtils.isAndroid();
    private final ASMSerializerFactory asmFactory = new ASMSerializerFactory();

    public final ObjectSerializer createASMSerializer(Class<?> clazz) throws Exception {
        return this.asmFactory.createJavaBeanSerializer(clazz);
    }

    public ObjectSerializer createJavaBeanSerializer(Class<?> clazz) {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            return new JavaBeanSerializer(clazz);
        }
        boolean asm = this.asm;
        if (asm && ASMClassLoader.isExternalClass(clazz) || clazz == Serializable.class || clazz == Object.class) {
            asm = false;
        }
        if (asm) {
            try {
                return this.createASMSerializer(clazz);
            }
            catch (Throwable e) {
                throw new JSONException("create asm serilizer error, class " + clazz, e);
            }
        }
        return new JavaBeanSerializer(clazz);
    }

    public boolean isAsmEnable() {
        return this.asm;
    }

    public void setAsmEnable(boolean asmEnable) {
        this.asm = asmEnable;
    }

    public static final SerializeConfig getGlobalInstance() {
        return globalInstance;
    }

    public SerializeConfig() {
        this(1024);
    }

    public SerializeConfig(int tableSize) {
        super(tableSize);
        this.put(Boolean.class, BooleanSerializer.instance);
        this.put(Character.class, CharacterSerializer.instance);
        this.put(Byte.class, ByteSerializer.instance);
        this.put(Short.class, ShortSerializer.instance);
        this.put(Integer.class, IntegerSerializer.instance);
        this.put(Long.class, LongSerializer.instance);
        this.put(Float.class, FloatSerializer.instance);
        this.put(Double.class, DoubleSerializer.instance);
        this.put(BigDecimal.class, BigDecimalSerializer.instance);
        this.put(BigInteger.class, BigIntegerSerializer.instance);
        this.put(String.class, StringSerializer.instance);
        this.put(byte[].class, ByteArraySerializer.instance);
        this.put(short[].class, ShortArraySerializer.instance);
        this.put(int[].class, IntArraySerializer.instance);
        this.put(long[].class, LongArraySerializer.instance);
        this.put(float[].class, FloatArraySerializer.instance);
        this.put(double[].class, DoubleArraySerializer.instance);
        this.put(boolean[].class, BooleanArraySerializer.instance);
        this.put(char[].class, CharArraySerializer.instance);
        this.put(Object[].class, ObjectArraySerializer.instance);
        this.put(Class.class, ClassSerializer.instance);
        this.put(SimpleDateFormat.class, DateFormatSerializer.instance);
        this.put(Locale.class, LocaleSerializer.instance);
        this.put(TimeZone.class, TimeZoneSerializer.instance);
        this.put(UUID.class, UUIDSerializer.instance);
        this.put(InetAddress.class, InetAddressSerializer.instance);
        this.put(Inet4Address.class, InetAddressSerializer.instance);
        this.put(Inet6Address.class, InetAddressSerializer.instance);
        this.put(InetSocketAddress.class, InetSocketAddressSerializer.instance);
        this.put(File.class, FileSerializer.instance);
        this.put(URI.class, URISerializer.instance);
        this.put(URL.class, URLSerializer.instance);
        this.put(Appendable.class, AppendableSerializer.instance);
        this.put(StringBuffer.class, AppendableSerializer.instance);
        this.put(StringBuilder.class, AppendableSerializer.instance);
        this.put(Pattern.class, PatternSerializer.instance);
        this.put(Charset.class, CharsetSerializer.instance);
        this.put(AtomicBoolean.class, AtomicBooleanSerializer.instance);
        this.put(AtomicInteger.class, AtomicIntegerSerializer.instance);
        this.put(AtomicLong.class, AtomicLongSerializer.instance);
        this.put(AtomicReference.class, AtomicReferenceSerializer.instance);
        this.put(AtomicIntegerArray.class, AtomicIntegerArraySerializer.instance);
        this.put(AtomicLongArray.class, AtomicLongArraySerializer.instance);
    }
}

