/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.Keywords;
import com.alibaba.fastjson.parser.SymbolTable;
import java.io.Closeable;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSONLexer
implements Closeable {
    public static final byte EOI = 26;
    public static final int NOT_MATCH = -1;
    public static final int NOT_MATCH_NAME = -2;
    public static final int UNKOWN = 0;
    public static final int OBJECT = 1;
    public static final int ARRAY = 2;
    public static final int VALUE = 3;
    public static final int END = 4;
    protected int token;
    protected int pos;
    protected int features = JSON.DEFAULT_PARSER_FEATURE;
    protected char ch;
    protected int bp;
    protected int eofPos;
    protected char[] sbuf;
    protected int sp;
    protected int np;
    protected boolean hasSpecial;
    protected Calendar calendar = null;
    public int matchStat = 0;
    private static final ThreadLocal<SoftReference<char[]>> SBUF_REF_LOCAL;
    protected Keywords keywods = Keywords.DEFAULT_KEYWORDS;
    protected static boolean[] whitespaceFlags;
    protected static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    protected static final long N_MULTMAX_RADIX_TEN = -922337203685477580L;
    protected static final int INT_MULTMIN_RADIX_TEN = -214748364;
    protected static final int INT_N_MULTMAX_RADIX_TEN = -214748364;
    protected static final int[] digits;

    protected void lexError(String key, Object ... args) {
        this.token = 1;
    }

    public JSONLexer() {
        SoftReference<char[]> sbufRef = SBUF_REF_LOCAL.get();
        if (sbufRef != null) {
            this.sbuf = sbufRef.get();
            SBUF_REF_LOCAL.set(null);
        }
        if (this.sbuf == null) {
            this.sbuf = new char[64];
        }
    }

    public final int matchStat() {
        return this.matchStat;
    }

    public final void nextToken() {
        this.sp = 0;
        block17: while (true) {
            this.pos = this.bp;
            if (this.ch == '\"') {
                this.scanString();
                return;
            }
            if (this.ch == ',') {
                this.next();
                this.token = 16;
                return;
            }
            if (this.ch >= '0' && this.ch <= '9') {
                this.scanNumber();
                return;
            }
            if (this.ch == '-') {
                this.scanNumber();
                return;
            }
            switch (this.ch) {
                case '\'': {
                    if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                        throw new JSONException("Feature.AllowSingleQuotes is false");
                    }
                    this.scanStringSingleQuote();
                    return;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    this.next();
                    continue block17;
                }
                case 't': {
                    this.scanTrue();
                    return;
                }
                case 'T': {
                    this.scanTreeSet();
                    return;
                }
                case 'S': {
                    this.scanSet();
                    return;
                }
                case 'f': {
                    this.scanFalse();
                    return;
                }
                case 'n': {
                    this.scanNullOrNew();
                    return;
                }
                case 'D': {
                    this.scanIdent();
                    return;
                }
                case '(': {
                    this.next();
                    this.token = 10;
                    return;
                }
                case ')': {
                    this.next();
                    this.token = 11;
                    return;
                }
                case '[': {
                    this.next();
                    this.token = 14;
                    return;
                }
                case ']': {
                    this.next();
                    this.token = 15;
                    return;
                }
                case '{': {
                    this.next();
                    this.token = 12;
                    return;
                }
                case '}': {
                    this.next();
                    this.token = 13;
                    return;
                }
                case ':': {
                    this.next();
                    this.token = 17;
                    return;
                }
            }
            break;
        }
        if (this.isEOF()) {
            if (this.token == 20) {
                throw new JSONException("EOF error");
            }
            this.token = 20;
            this.pos = this.bp = this.eofPos;
        } else {
            this.lexError("illegal.char", String.valueOf((int)this.ch));
            this.next();
        }
    }

    public final void nextToken(int expect) {
        this.sp = 0;
        while (true) {
            switch (expect) {
                case 12: {
                    if (this.ch == '{') {
                        this.token = 12;
                        this.next();
                        return;
                    }
                    if (this.ch != '[') break;
                    this.token = 14;
                    this.next();
                    return;
                }
                case 16: {
                    if (this.ch == ',') {
                        this.token = 16;
                        this.next();
                        return;
                    }
                    if (this.ch == '}') {
                        this.token = 13;
                        this.next();
                        return;
                    }
                    if (this.ch == ']') {
                        this.token = 15;
                        this.next();
                        return;
                    }
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
                case 2: {
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 4: {
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 14: {
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 15: {
                    if (this.ch == ']') {
                        this.token = 15;
                        this.next();
                        return;
                    }
                }
                case 20: {
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
                case 18: {
                    this.nextIdent();
                    return;
                }
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        this.nextToken();
    }

    public final void nextIdent() {
        while (JSONLexer.isWhitespace(this.ch)) {
            this.next();
        }
        if (this.ch == '_' || Character.isLetter(this.ch)) {
            this.scanIdent();
        } else {
            this.nextToken();
        }
    }

    public final void nextTokenWithColon() {
        this.sp = 0;
        while (true) {
            if (this.ch == ':') {
                this.next();
                this.nextToken();
                return;
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        throw new JSONException("not match ':' - " + this.ch);
    }

    public final int token() {
        return this.token;
    }

    public final String tokenName() {
        return JSONToken.name(this.token);
    }

    public final int pos() {
        return this.pos;
    }

    public final int getBufferPosition() {
        return this.bp;
    }

    public final String stringDefaultValue() {
        if (this.isEnabled(Feature.InitStringFieldAsEmpty)) {
            return "";
        }
        return null;
    }

    public final Number integerValue() throws NumberFormatException {
        int digit;
        long multmin;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        int type = 32;
        if (max > 0) {
            switch (this.charAt(max - 1)) {
                case 'L': {
                    --max;
                    type = 76;
                    break;
                }
                case 'S': {
                    --max;
                    type = 83;
                    break;
                }
                case 'B': {
                    --max;
                    type = 66;
                    break;
                }
            }
        }
        if (this.charAt(this.np) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long l = multmin = negative ? -922337203685477580L : -922337203685477580L;
        if (i < max) {
            digit = digits[this.charAt(i++)];
            result = -digit;
        }
        while (i < max) {
            digit = digits[this.charAt(i++)];
            if (result < multmin) {
                return new BigInteger(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                return new BigInteger(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                if (result >= Integer.MIN_VALUE && type != 76) {
                    if (type == 83) {
                        return (short)result;
                    }
                    if (type == 66) {
                        return (byte)result;
                    }
                    return (int)result;
                }
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((result = -result) <= Integer.MAX_VALUE && type != 76) {
            if (type == 83) {
                return (short)result;
            }
            if (type == 66) {
                return (byte)result;
            }
            return (int)result;
        }
        return result;
    }

    public final void nextTokenWithColon(int expect) {
        block17: {
            this.sp = 0;
            while (true) {
                if (this.ch == ':') break block17;
                if (!JSONLexer.isWhitespace(this.ch)) break;
                this.next();
            }
            throw new JSONException("not match ':', actual " + this.ch);
        }
        this.next();
        while (true) {
            if (expect == 2) {
                if (this.ch >= '0' && this.ch <= '9') {
                    this.pos = this.bp;
                    this.scanNumber();
                    return;
                }
                if (this.ch == '\"') {
                    this.pos = this.bp;
                    this.scanString();
                    return;
                }
            } else if (expect == 4) {
                if (this.ch == '\"') {
                    this.pos = this.bp;
                    this.scanString();
                    return;
                }
                if (this.ch >= '0' && this.ch <= '9') {
                    this.pos = this.bp;
                    this.scanNumber();
                    return;
                }
            } else if (expect == 12) {
                if (this.ch == '{') {
                    this.token = 12;
                    this.next();
                    return;
                }
                if (this.ch == '[') {
                    this.token = 14;
                    this.next();
                    return;
                }
            } else if (expect == 14) {
                if (this.ch == '[') {
                    this.token = 14;
                    this.next();
                    return;
                }
                if (this.ch == '{') {
                    this.token = 12;
                    this.next();
                    return;
                }
            }
            if (!JSONLexer.isWhitespace(this.ch)) break;
            this.next();
        }
        this.nextToken();
    }

    public float floatValue() {
        return Float.parseFloat(this.numberString());
    }

    public double doubleValue() {
        return Double.parseDouble(this.numberString());
    }

    public void config(Feature feature, boolean state) {
        this.features = Feature.config(this.features, feature, state);
    }

    public final boolean isEnabled(Feature feature) {
        return Feature.isEnabled(this.features, feature);
    }

    public abstract String numberString();

    public abstract boolean isEOF();

    public abstract String symbol(SymbolTable var1);

    public final char getCurrent() {
        return this.ch;
    }

    public abstract char charAt(int var1);

    public abstract char next();

    public final String scanSymbol(SymbolTable symbolTable) {
        this.skipWhitespace();
        if (this.ch == '\"') {
            return this.scanSymbol(symbolTable, '\"');
        }
        if (this.ch == '\'') {
            if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                throw new JSONException("syntax error");
            }
            return this.scanSymbol(symbolTable, '\'');
        }
        if (this.ch == '}') {
            this.next();
            this.token = 13;
            return null;
        }
        if (this.ch == ',') {
            this.next();
            this.token = 16;
            return null;
        }
        if (this.ch == '\u001a') {
            this.token = 20;
            return null;
        }
        if (!this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
            throw new JSONException("syntax error");
        }
        return this.scanSymbolUnQuoted(symbolTable);
    }

    public abstract String scanSymbol(SymbolTable var1, char var2);

    public final void resetStringPosition() {
        this.sp = 0;
    }

    public abstract String scanSymbolUnQuoted(SymbolTable var1);

    protected abstract void copyTo(int var1, int var2, char[] var3);

    public abstract void scanString();

    public Calendar getCalendar() {
        return this.calendar;
    }

    public final int intValue() {
        char chLocal;
        int digit;
        int multmin;
        int limit;
        int result = 0;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        if (this.charAt(this.np) == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        int n = multmin = negative ? -214748364 : -214748364;
        if (i < max) {
            digit = digits[this.charAt(i++)];
            result = -digit;
        }
        while (i < max && (chLocal = this.charAt(i++)) != 'L' && chLocal != 'S' && chLocal != 'B') {
            digit = digits[chLocal];
            if (result < multmin) {
                throw new NumberFormatException(this.numberString());
            }
            if ((result *= 10) < limit + digit) {
                throw new NumberFormatException(this.numberString());
            }
            result -= digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -result;
    }

    public abstract byte[] bytesValue();

    @Override
    public void close() {
        if (this.sbuf.length <= 8192) {
            SBUF_REF_LOCAL.set(new SoftReference<char[]>(this.sbuf));
        }
        this.sbuf = null;
    }

    public abstract boolean isRef();

    public abstract int scanType(String var1);

    public abstract boolean matchField(char[] var1);

    public abstract int indexOf(char var1, int var2);

    public abstract String addSymbol(int var1, int var2, int var3, SymbolTable var4);

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldString(char[] fieldName) {
        char chLocal;
        this.matchStat = 0;
        if (!this.charArrayCompare(fieldName)) {
            this.matchStat = -2;
            return this.stringDefaultValue();
        }
        int offset = fieldName.length;
        if ((chLocal = this.charAt(this.bp + offset++)) != '\"') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        boolean hasSpecial = false;
        int startIndex = this.bp + fieldName.length + 1;
        int endIndex = this.indexOf('\"', startIndex);
        if (endIndex == -1) {
            throw new JSONException("unclosed str");
        }
        String stringVal = this.subString(this.bp + fieldName.length + 1, endIndex - startIndex);
        for (int i = this.bp + fieldName.length + 1; i < endIndex; ++i) {
            if (this.charAt(i) != '\\') continue;
            hasSpecial = true;
            break;
        }
        if (hasSpecial) {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        offset += endIndex - (this.bp + fieldName.length + 1) + 1;
        chLocal = this.charAt(this.bp + offset++);
        String strVal = stringVal;
        if (chLocal == ',') {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            return strVal;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return this.stringDefaultValue();
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return strVal;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldSymbol(char[] fieldName, SymbolTable symbolTable) {
        String strVal;
        char chLocal;
        int offset;
        block12: {
            block13: {
                this.matchStat = 0;
                if (!this.charArrayCompare(fieldName)) {
                    this.matchStat = -2;
                    return null;
                }
                offset = fieldName.length;
                if ((chLocal = this.charAt(this.bp + offset++)) != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                int hash = 0;
                do {
                    if ((chLocal = this.charAt(this.bp + offset++)) == '\"') {
                        int start = this.bp + fieldName.length + 1;
                        int len = this.bp + offset - start - 1;
                        strVal = this.addSymbol(start, len, hash, symbolTable);
                        if ((chLocal = this.charAt(this.bp + offset++)) != ',') break block12;
                        break block13;
                    }
                    hash = 31 * hash + chLocal;
                } while (chLocal != '\\');
                this.matchStat = -1;
                return null;
            }
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            return strVal;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return strVal;
    }

    public ArrayList<String> scanFieldStringArray(char[] fieldName) {
        return (ArrayList)this.scanFieldStringArray(fieldName, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<String> scanFieldStringArray(char[] fieldName, Class<?> type) {
        Collection<String> list;
        this.matchStat = 0;
        if (!this.charArrayCompare(fieldName)) {
            this.matchStat = -2;
            return null;
        }
        if (type.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (type.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else {
            try {
                list = type.newInstance();
            }
            catch (Exception e) {
                throw new JSONException(e.getMessage(), e);
            }
        }
        int offset = fieldName.length;
        char chLocal = this.charAt(this.bp + offset++);
        if (chLocal != '[') {
            this.matchStat = -1;
            return null;
        }
        chLocal = this.charAt(this.bp + offset++);
        block2: while (true) {
            block21: {
                if (chLocal != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                int startOffset = offset;
                do {
                    if ((chLocal = this.charAt(this.bp + offset++)) != '\"') continue;
                    int start = this.bp + startOffset;
                    int len = this.bp + offset - start - 1;
                    String strVal = this.subString(start, len);
                    list.add(strVal);
                    chLocal = this.charAt(this.bp + offset++);
                    if (chLocal != ',') break block2;
                    break block21;
                } while (chLocal != '\\');
                this.matchStat = -1;
                return null;
            }
            chLocal = this.charAt(this.bp + offset++);
        }
        if (chLocal != ']') {
            this.matchStat = -1;
            return null;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            return list;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.bp += offset - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanFieldInt(char[] fieldName) {
        int value;
        char chLocal;
        this.matchStat = 0;
        if (!this.charArrayCompare(fieldName)) {
            this.matchStat = -2;
            return 0;
        }
        int offset = fieldName.length;
        if ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
            value = digits[chLocal];
            while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                value = value * 10 + digits[chLocal];
            }
            if (chLocal == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (value < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            this.matchStat = -1;
            return 0;
        }
        if (chLocal == ',') {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return 0;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return 0;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean scanFieldBoolean(char[] fieldName) {
        boolean value;
        char chLocal;
        this.matchStat = 0;
        if (!this.charArrayCompare(fieldName)) {
            this.matchStat = -2;
            return false;
        }
        int offset = fieldName.length;
        if ((chLocal = this.charAt(this.bp + offset++)) == 't') {
            if (this.charAt(this.bp + offset++) != 'r') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + offset++) != 'u') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + offset++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            value = true;
        } else {
            if (chLocal != 'f') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + offset++) != 'a') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + offset++) != 'l') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + offset++) != 's') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + offset++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            value = false;
        }
        chLocal = this.charAt(this.bp + offset++);
        if (chLocal == ',') {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return false;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return false;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldLong(char[] fieldName) {
        long value;
        char chLocal;
        this.matchStat = 0;
        if (!this.charArrayCompare(fieldName)) {
            this.matchStat = -2;
            return 0L;
        }
        int offset = fieldName.length;
        if ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
            value = digits[chLocal];
            while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                value = value * 10L + (long)digits[chLocal];
            }
            if (chLocal == '.') {
                this.matchStat = -1;
                return 0L;
            }
            if (value < 0L) {
                this.matchStat = -1;
                return 0L;
            }
        } else {
            this.matchStat = -1;
            return 0L;
        }
        if (chLocal == ',') {
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return 0L;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final float scanFieldFloat(char[] fieldName) {
        float value;
        char chLocal;
        int offset;
        block15: {
            block16: {
                block14: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(fieldName)) {
                        this.matchStat = -2;
                        return 0.0f;
                    }
                    offset = fieldName.length;
                    if ((chLocal = this.charAt(this.bp + offset++)) < '0' || chLocal > '9') break block14;
                    while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                    }
                    if (chLocal == '.') {
                        if ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                            while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                    int start = this.bp + fieldName.length;
                    int count = this.bp + offset - start - 1;
                    String text = this.subString(start, count);
                    value = Float.parseFloat(text);
                    if (chLocal != ',') break block15;
                    break block16;
                }
                this.matchStat = -1;
                return 0.0f;
            }
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return 0.0f;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return 0.0f;
            }
            this.bp += offset - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final double scanFieldDouble(char[] fieldName) {
        double value;
        char chLocal;
        int offset;
        block18: {
            block19: {
                block17: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(fieldName)) {
                        this.matchStat = -2;
                        return 0.0;
                    }
                    offset = fieldName.length;
                    if ((chLocal = this.charAt(this.bp + offset++)) < '0' || chLocal > '9') break block17;
                    while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                    }
                    if (chLocal == '.') {
                        if ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                            while ((chLocal = this.charAt(this.bp + offset++)) >= '0' && chLocal <= '9') {
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    if (chLocal == 'e' || chLocal == 'E') {
                        if ((chLocal = this.charAt(this.bp + offset++)) == '+' || chLocal == '-') {
                            chLocal = this.charAt(this.bp + offset++);
                        }
                        while (chLocal >= '0' && chLocal <= '9') {
                            chLocal = this.charAt(this.bp + offset++);
                        }
                    }
                    int start = this.bp + fieldName.length;
                    int count = this.bp + offset - start - 1;
                    String text = this.subString(start, count);
                    value = Double.parseDouble(text);
                    if (chLocal != ',') break block18;
                    break block19;
                }
                this.matchStat = -1;
                return 0.0;
            }
            this.bp += offset - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (chLocal != '}') {
            this.matchStat = -1;
            return 0.0;
        }
        if ((chLocal = this.charAt(this.bp + offset++)) == ',') {
            this.token = 16;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == ']') {
            this.token = 15;
            this.bp += offset - 1;
            this.next();
        } else if (chLocal == '}') {
            this.token = 13;
            this.bp += offset - 1;
            this.next();
        } else {
            if (chLocal != '\u001a') {
                this.matchStat = -1;
                return 0.0;
            }
            this.token = 20;
            this.bp += offset - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return value;
    }

    public final void scanTrue() {
        if (this.ch != 't') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'r') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'u') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
            throw new JSONException("scan true error");
        }
        this.token = 6;
    }

    public final void scanTreeSet() {
        if (this.ch != 'T') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'r') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'S') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 't') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b' && this.ch != '[' && this.ch != '(') {
            throw new JSONException("scan set error");
        }
        this.token = 22;
    }

    public final void scanNullOrNew() {
        if (this.ch != 'n') {
            throw new JSONException("error parse null or new");
        }
        this.next();
        if (this.ch == 'u') {
            this.next();
            if (this.ch != 'l') {
                throw new JSONException("error parse true");
            }
            this.next();
            if (this.ch != 'l') {
                throw new JSONException("error parse true");
            }
            this.next();
            if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
                throw new JSONException("scan true error");
            }
            this.token = 8;
            return;
        }
        if (this.ch != 'e') {
            throw new JSONException("error parse e");
        }
        this.next();
        if (this.ch != 'w') {
            throw new JSONException("error parse w");
        }
        this.next();
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
            throw new JSONException("scan true error");
        }
        this.token = 9;
    }

    public final void scanFalse() {
        if (this.ch != 'f') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'a') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'l') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 's') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
            throw new JSONException("scan false error");
        }
        this.token = 7;
    }

    public abstract void scanIdent();

    public abstract String stringVal();

    public abstract String subString(int var1, int var2);

    public abstract boolean charArrayCompare(char[] var1);

    public final boolean isBlankInput() {
        char chLocal;
        int i = 0;
        while ((chLocal = this.charAt(i)) != '\u001a') {
            if (!JSONLexer.isWhitespace(chLocal)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final void skipWhitespace() {
        while (whitespaceFlags[this.ch]) {
            this.next();
        }
    }

    public abstract void scanStringSingleQuote();

    public final void scanSet() {
        if (this.ch != 'S') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 't') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b' && this.ch != '[' && this.ch != '(') {
            throw new JSONException("scan set error");
        }
        this.token = 21;
    }

    protected final void putChar(char ch) {
        if (this.sp == this.sbuf.length) {
            char[] newsbuf = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
            this.sbuf = newsbuf;
        }
        this.sbuf[this.sp++] = ch;
    }

    public final void scanNumber() {
        this.np = this.bp;
        if (this.ch == '-') {
            ++this.sp;
            this.next();
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.sp;
            this.next();
        }
        boolean isDouble = false;
        if (this.ch == '.') {
            ++this.sp;
            this.next();
            isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.next();
            }
        }
        if (this.ch == 'L') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'S') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'B') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'F') {
            ++this.sp;
            this.next();
            isDouble = true;
        } else if (this.ch == 'D') {
            ++this.sp;
            this.next();
            isDouble = true;
        } else if (this.ch == 'e' || this.ch == 'E') {
            ++this.sp;
            this.next();
            if (this.ch == '+' || this.ch == '-') {
                ++this.sp;
                this.next();
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.next();
            }
            if (this.ch == 'D' || this.ch == 'F') {
                this.next();
            }
            isDouble = true;
        }
        this.token = isDouble ? 3 : 2;
    }

    public final long longValue() throws NumberFormatException {
        char chLocal;
        int digit;
        long multmin;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        if (this.charAt(this.np) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long l = multmin = negative ? -922337203685477580L : -922337203685477580L;
        if (i < max) {
            digit = digits[this.charAt(i++)];
            result = -digit;
        }
        while (i < max && (chLocal = this.charAt(i++)) != 'L' && chLocal != 'S' && chLocal != 'B') {
            digit = digits[chLocal];
            if (result < multmin) {
                throw new NumberFormatException(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                throw new NumberFormatException(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -result;
    }

    public final Number decimalValue(boolean decimal) {
        char chLocal = this.charAt(this.np + this.sp - 1);
        if (chLocal == 'F') {
            return Float.valueOf(Float.parseFloat(this.numberString()));
        }
        if (chLocal == 'D') {
            return Double.parseDouble(this.numberString());
        }
        if (decimal) {
            return this.decimalValue();
        }
        return this.doubleValue();
    }

    public final BigDecimal decimalValue() {
        return new BigDecimal(this.numberString());
    }

    public static final boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\f' || ch == '\b';
    }

    static {
        int i;
        SBUF_REF_LOCAL = new ThreadLocal();
        whitespaceFlags = new boolean[256];
        JSONLexer.whitespaceFlags[32] = true;
        JSONLexer.whitespaceFlags[10] = true;
        JSONLexer.whitespaceFlags[13] = true;
        JSONLexer.whitespaceFlags[9] = true;
        JSONLexer.whitespaceFlags[12] = true;
        JSONLexer.whitespaceFlags[8] = true;
        digits = new int[103];
        for (i = 48; i <= 57; ++i) {
            JSONLexer.digits[i] = i - 48;
        }
        for (i = 97; i <= 102; ++i) {
            JSONLexer.digits[i] = i - 97 + 10;
        }
        for (i = 65; i <= 70; ++i) {
            JSONLexer.digits[i] = i - 65 + 10;
        }
    }
}

