/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.CharTypes;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.util.Base64;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSONScanner
extends JSONLexer {
    private final String text;
    protected static final char[] typeFieldName = ("\"" + JSON.DEFAULT_TYPE_KEY + "\":\"").toCharArray();
    public final int ISO8601_LEN_0 = "0000-00-00".length();
    public final int ISO8601_LEN_1 = "0000-00-00T00:00:00".length();
    public final int ISO8601_LEN_2 = "0000-00-00T00:00:00.000".length();

    public JSONScanner(String input) {
        this(input, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(String input, int features) {
        this.features = features;
        this.text = input;
        this.bp = -1;
        this.next();
        if (this.ch == '\ufeff') {
            this.next();
        }
    }

    @Override
    public final char charAt(int index) {
        if (index >= this.text.length()) {
            return '\u001a';
        }
        return this.text.charAt(index);
    }

    @Override
    public final char next() {
        this.ch = this.charAt(++this.bp);
        return this.ch;
    }

    public JSONScanner(char[] input, int inputLength) {
        this(input, inputLength, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(char[] input, int inputLength, int features) {
        this(new String(input, 0, inputLength), features);
    }

    @Override
    public final void scanStringSingleQuote() {
        char chLocal;
        this.np = this.bp;
        this.hasSpecial = false;
        block22: while ((chLocal = this.charAt(++this.bp)) != '\'') {
            if (chLocal == '\u001a') {
                throw new JSONException("unclosed single-quote string");
            }
            if (chLocal == '\\') {
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp > this.sbuf.length) {
                        char[] newsbuf = new char[this.sp * 2];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    this.text.getChars(this.np + 1, this.np + 1 + this.sp, this.sbuf, 0);
                }
                chLocal = this.charAt(++this.bp);
                switch (chLocal) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        char x1 = chLocal = this.charAt(++this.bp);
                        char x2 = chLocal = this.charAt(++this.bp);
                        int x_val = digits[x1] * 16 + digits[x2];
                        char x_char = (char)x_val;
                        this.putChar(x_char);
                        continue block22;
                    }
                    case 'u': {
                        char c1 = chLocal = this.charAt(++this.bp);
                        char c2 = chLocal = this.charAt(++this.bp);
                        char c3 = chLocal = this.charAt(++this.bp);
                        char c4 = chLocal = this.charAt(++this.bp);
                        int val = Integer.parseInt(new String(new char[]{c1, c2, c3, c4}), 16);
                        this.putChar((char)val);
                        continue block22;
                    }
                }
                this.ch = chLocal;
                throw new JSONException("unclosed single-quote string");
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(chLocal);
                continue;
            }
            this.sbuf[this.sp++] = chLocal;
        }
        this.token = 4;
        this.next();
    }

    @Override
    protected final void copyTo(int offset, int count, char[] dest) {
        this.text.getChars(offset, offset + count, dest, 0);
    }

    @Override
    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        char chLocal;
        boolean firstFlag;
        boolean[] firstIdentifierFlags = CharTypes.firstIdentifierFlags;
        int first = this.ch;
        boolean bl = firstFlag = this.ch >= firstIdentifierFlags.length || firstIdentifierFlags[first];
        if (!firstFlag) {
            throw new JSONException("illegal identifier : " + this.ch);
        }
        boolean[] identifierFlags = CharTypes.identifierFlags;
        int hash = first;
        this.np = this.bp;
        this.sp = 1;
        while ((chLocal = this.charAt(++this.bp)) >= identifierFlags.length || identifierFlags[chLocal]) {
            hash = 31 * hash + chLocal;
            ++this.sp;
        }
        this.ch = this.charAt(this.bp);
        this.token = 18;
        int NULL_HASH = 3392903;
        if (this.sp == 4 && hash == 3392903 && this.charAt(this.np) == 'n' && this.charAt(this.np + 1) == 'u' && this.charAt(this.np + 2) == 'l' && this.charAt(this.np + 3) == 'l') {
            return null;
        }
        return this.text.substring(this.np, this.np + this.sp).intern();
    }

    @Override
    public final int scanType(String type) {
        this.matchStat = 0;
        if (!JSONScanner.charArrayCompare(this.text, this.bp, typeFieldName)) {
            return -2;
        }
        int bpLocal = this.bp + typeFieldName.length;
        int typeLength = type.length();
        for (int i = 0; i < typeLength; ++i) {
            if (type.charAt(i) == this.charAt(bpLocal + i)) continue;
            return -1;
        }
        if (this.charAt(bpLocal += typeLength) != '\"') {
            return -1;
        }
        this.ch = this.charAt(++bpLocal);
        if (this.ch == ',') {
            this.ch = this.charAt(++bpLocal);
            this.bp = bpLocal;
            this.token = 16;
            return 3;
        }
        if (this.ch == '}') {
            this.ch = this.charAt(++bpLocal);
            if (this.ch == ',') {
                this.token = 16;
                this.ch = this.charAt(++bpLocal);
            } else if (this.ch == ']') {
                this.token = 15;
                this.ch = this.charAt(++bpLocal);
            } else if (this.ch == '}') {
                this.token = 13;
                this.ch = this.charAt(++bpLocal);
            } else if (this.ch == '\u001a') {
                this.token = 20;
            } else {
                return -1;
            }
            this.matchStat = 4;
        }
        this.bp = bpLocal;
        return this.matchStat;
    }

    @Override
    public final boolean matchField(char[] fieldName) {
        if (!this.charArrayCompare(fieldName)) {
            return false;
        }
        this.bp += fieldName.length;
        this.ch = this.charAt(this.bp);
        if (this.ch == '{') {
            this.next();
            this.token = 12;
        } else if (this.ch == '[') {
            this.next();
            this.token = 14;
        } else {
            this.nextToken();
        }
        return true;
    }

    static final boolean charArrayCompare(String src, int offset, char[] dest) {
        int destLen = dest.length;
        if (destLen + offset > src.length()) {
            return false;
        }
        for (int i = 0; i < destLen; ++i) {
            if (dest[i] == src.charAt(offset + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean charArrayCompare(char[] chars) {
        return JSONScanner.charArrayCompare(this.text, this.bp, chars);
    }

    @Override
    public final int indexOf(char ch, int startIndex) {
        return this.text.indexOf(ch, startIndex);
    }

    @Override
    public final String addSymbol(int offset, int len, int hash, SymbolTable symbolTable) {
        return symbolTable.addSymbol(this.text, offset, len, hash);
    }

    @Override
    public byte[] bytesValue() {
        return Base64.decodeFast(this.text, this.np + 1, this.sp);
    }

    @Override
    public final String scanSymbol(SymbolTable symbolTable, char quote) {
        char chLocal;
        int hash = 0;
        this.np = this.bp;
        this.sp = 0;
        boolean hasSpecial = false;
        block11: while ((chLocal = this.charAt(++this.bp)) != quote) {
            if (chLocal == '\u001a') {
                throw new JSONException("unclosed.str");
            }
            if (chLocal == '\\') {
                if (!hasSpecial) {
                    hasSpecial = true;
                    if (this.sp >= this.sbuf.length) {
                        int newCapcity = this.sbuf.length * 2;
                        if (this.sp > newCapcity) {
                            newCapcity = this.sp;
                        }
                        char[] newsbuf = new char[newCapcity];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    this.text.getChars(this.np + 1, this.np + 1 + this.sp, this.sbuf, 0);
                }
                chLocal = this.charAt(++this.bp);
                switch (chLocal) {
                    case '\"': {
                        hash = 31 * hash + 34;
                        this.putChar('\"');
                        continue block11;
                    }
                    case '\\': {
                        hash = 31 * hash + 92;
                        this.putChar('\\');
                        continue block11;
                    }
                    case '/': {
                        hash = 31 * hash + 47;
                        this.putChar('/');
                        continue block11;
                    }
                    case 'b': {
                        hash = 31 * hash + 8;
                        this.putChar('\b');
                        continue block11;
                    }
                    case 'F': 
                    case 'f': {
                        hash = 31 * hash + 12;
                        this.putChar('\f');
                        continue block11;
                    }
                    case 'n': {
                        hash = 31 * hash + 10;
                        this.putChar('\n');
                        continue block11;
                    }
                    case 'r': {
                        hash = 31 * hash + 13;
                        this.putChar('\r');
                        continue block11;
                    }
                    case 't': {
                        hash = 31 * hash + 9;
                        this.putChar('\t');
                        continue block11;
                    }
                    case 'u': {
                        char c1 = chLocal = this.charAt(++this.bp);
                        char c2 = chLocal = this.charAt(++this.bp);
                        char c3 = chLocal = this.charAt(++this.bp);
                        char c4 = chLocal = this.charAt(++this.bp);
                        int val = Integer.parseInt(new String(new char[]{c1, c2, c3, c4}), 16);
                        hash = 31 * hash + val;
                        this.putChar((char)val);
                        continue block11;
                    }
                }
                this.ch = chLocal;
                throw new JSONException("unclosed.str.lit");
            }
            hash = 31 * hash + chLocal;
            if (!hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(chLocal);
                continue;
            }
            this.sbuf[this.sp++] = chLocal;
        }
        this.token = 4;
        this.next();
        if (!hasSpecial) {
            return symbolTable.addSymbol(this.text, this.np + 1, this.sp, hash);
        }
        return symbolTable.addSymbol(this.sbuf, 0, this.sp, hash);
    }

    @Override
    public void scanIdent() {
        this.np = this.bp - 1;
        this.hasSpecial = false;
        do {
            ++this.sp;
            this.next();
        } while (Character.isLetterOrDigit(this.ch));
        String ident = this.stringVal();
        Integer tok = this.keywods.getKeyword(ident);
        this.token = tok != null ? tok : 18;
    }

    @Override
    public final String stringVal() {
        if (!this.hasSpecial) {
            return this.text.substring(this.np + 1, this.np + 1 + this.sp);
        }
        return new String(this.sbuf, 0, this.sp);
    }

    @Override
    public final String subString(int offset, int count) {
        return this.text.substring(offset, offset + count);
    }

    @Override
    public final String symbol(SymbolTable symbolTable) {
        if (symbolTable == null) {
            if (!this.hasSpecial) {
                return this.text.substring(this.np + 1, this.np + 1 + this.sp);
            }
            return new String(this.sbuf, 0, this.sp);
        }
        if (!this.hasSpecial) {
            return symbolTable.addSymbol(this.text, this.np + 1, this.sp);
        }
        return symbolTable.addSymbol(this.sbuf, 0, this.sp);
    }

    @Override
    public final String numberString() {
        char chLocal = this.charAt(this.np + this.sp - 1);
        int sp = this.sp;
        if (chLocal == 'L' || chLocal == 'S' || chLocal == 'B' || chLocal == 'F' || chLocal == 'D') {
            --sp;
        }
        return this.text.substring(this.np, this.np + sp);
    }

    public boolean scanISO8601DateIfMatch() {
        return this.scanISO8601DateIfMatch(true);
    }

    public boolean scanISO8601DateIfMatch(boolean strict) {
        char s1;
        char s0;
        char m1;
        char m0;
        char h1;
        char d1;
        char d0;
        char M1;
        char M0;
        char y3;
        char y2;
        char y1;
        char y0;
        int rest = this.text.length() - this.bp;
        if (!strict && rest > 13) {
            char c0 = this.charAt(this.bp);
            char c1 = this.charAt(this.bp + 1);
            char c2 = this.charAt(this.bp + 2);
            char c3 = this.charAt(this.bp + 3);
            char c4 = this.charAt(this.bp + 4);
            char c5 = this.charAt(this.bp + 5);
            char c_r0 = this.charAt(this.bp + rest - 1);
            char c_r1 = this.charAt(this.bp + rest - 2);
            if (c0 == '/' && c1 == 'D' && c2 == 'a' && c3 == 't' && c4 == 'e' && c5 == '(' && c_r0 == '/' && c_r1 == ')') {
                int plusIndex = -1;
                for (int i = 6; i < rest; ++i) {
                    char c = this.charAt(this.bp + i);
                    if (c == '+') {
                        plusIndex = i;
                        continue;
                    }
                    if (c < '0' || c > '9') break;
                }
                if (plusIndex == -1) {
                    return false;
                }
                int offset = this.bp + 6;
                String numberText = this.subString(offset, plusIndex - offset);
                long millis = Long.parseLong(numberText);
                Locale local = Locale.getDefault();
                this.calendar = Calendar.getInstance(TimeZone.getDefault(), local);
                this.calendar.setTimeInMillis(millis);
                this.token = 5;
                return true;
            }
        }
        if (rest == 8 || rest == 14 || rest == 17) {
            int seconds;
            int minute;
            int hour;
            int millis;
            if (strict) {
                return false;
            }
            y0 = this.charAt(this.bp);
            if (!JSONScanner.checkDate(y0, y1 = this.charAt(this.bp + 1), y2 = this.charAt(this.bp + 2), y3 = this.charAt(this.bp + 3), M0 = this.charAt(this.bp + 4), M1 = this.charAt(this.bp + 5), d0 = this.charAt(this.bp + 6), d1 = this.charAt(this.bp + 7))) {
                return false;
            }
            this.setCalendar(y0, y1, y2, y3, M0, M1, d0, d1);
            if (rest != 8) {
                char s12;
                char s02;
                char m12;
                char m02;
                char h12;
                char h0 = this.charAt(this.bp + 8);
                if (!this.checkTime(h0, h12 = this.charAt(this.bp + 9), m02 = this.charAt(this.bp + 10), m12 = this.charAt(this.bp + 11), s02 = this.charAt(this.bp + 12), s12 = this.charAt(this.bp + 13))) {
                    return false;
                }
                if (rest == 17) {
                    char S0 = this.charAt(this.bp + 14);
                    char S1 = this.charAt(this.bp + 15);
                    char S2 = this.charAt(this.bp + 16);
                    if (S0 < '0' || S0 > '9') {
                        return false;
                    }
                    if (S1 < '0' || S1 > '9') {
                        return false;
                    }
                    if (S2 < '0' || S2 > '9') {
                        return false;
                    }
                    millis = digits[S0] * 100 + digits[S1] * 10 + digits[S2];
                } else {
                    millis = 0;
                }
                hour = digits[h0] * 10 + digits[h12];
                minute = digits[m02] * 10 + digits[m12];
                seconds = digits[s02] * 10 + digits[s12];
            } else {
                hour = 0;
                minute = 0;
                seconds = 0;
                millis = 0;
            }
            this.calendar.set(11, hour);
            this.calendar.set(12, minute);
            this.calendar.set(13, seconds);
            this.calendar.set(14, millis);
            this.token = 5;
            return true;
        }
        if (rest < this.ISO8601_LEN_0) {
            return false;
        }
        if (this.charAt(this.bp + 4) != '-') {
            return false;
        }
        if (this.charAt(this.bp + 7) != '-') {
            return false;
        }
        y0 = this.charAt(this.bp);
        if (!JSONScanner.checkDate(y0, y1 = this.charAt(this.bp + 1), y2 = this.charAt(this.bp + 2), y3 = this.charAt(this.bp + 3), M0 = this.charAt(this.bp + 5), M1 = this.charAt(this.bp + 6), d0 = this.charAt(this.bp + 8), d1 = this.charAt(this.bp + 9))) {
            return false;
        }
        this.setCalendar(y0, y1, y2, y3, M0, M1, d0, d1);
        char t = this.charAt(this.bp + 10);
        if (t == 'T' || t == ' ' && !strict) {
            if (rest < this.ISO8601_LEN_1) {
                return false;
            }
        } else {
            if (t == '\"' || t == '\u001a') {
                this.calendar.set(11, 0);
                this.calendar.set(12, 0);
                this.calendar.set(13, 0);
                this.calendar.set(14, 0);
                this.ch = this.charAt(this.bp += 10);
                this.token = 5;
                return true;
            }
            return false;
        }
        if (this.charAt(this.bp + 13) != ':') {
            return false;
        }
        if (this.charAt(this.bp + 16) != ':') {
            return false;
        }
        char h0 = this.charAt(this.bp + 11);
        if (!this.checkTime(h0, h1 = this.charAt(this.bp + 12), m0 = this.charAt(this.bp + 14), m1 = this.charAt(this.bp + 15), s0 = this.charAt(this.bp + 17), s1 = this.charAt(this.bp + 18))) {
            return false;
        }
        int hour = digits[h0] * 10 + digits[h1];
        int minute = digits[m0] * 10 + digits[m1];
        int seconds = digits[s0] * 10 + digits[s1];
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, seconds);
        char dot = this.charAt(this.bp + 19);
        if (dot == '.') {
            if (rest < this.ISO8601_LEN_2) {
                return false;
            }
        } else {
            this.calendar.set(14, 0);
            this.ch = this.charAt(this.bp += 19);
            this.token = 5;
            return true;
        }
        char S0 = this.charAt(this.bp + 20);
        char S1 = this.charAt(this.bp + 21);
        char S2 = this.charAt(this.bp + 22);
        if (S0 < '0' || S0 > '9') {
            return false;
        }
        if (S1 < '0' || S1 > '9') {
            return false;
        }
        if (S2 < '0' || S2 > '9') {
            return false;
        }
        int millis = digits[S0] * 100 + digits[S1] * 10 + digits[S2];
        this.calendar.set(14, millis);
        this.ch = this.charAt(this.bp += 23);
        this.token = 5;
        return true;
    }

    private boolean checkTime(char h0, char h1, char m0, char m1, char s0, char s1) {
        if (h0 == '0') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '1') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '2') {
            if (h1 < '0' || h1 > '4') {
                return false;
            }
        } else {
            return false;
        }
        if (m0 >= '0' && m0 <= '5') {
            if (m1 < '0' || m1 > '9') {
                return false;
            }
        } else if (m0 == '6') {
            if (m1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        if (s0 >= '0' && s0 <= '5') {
            if (s1 < '0' || s1 > '9') {
                return false;
            }
        } else if (s0 == '6') {
            if (s1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void setCalendar(char y0, char y1, char y2, char y3, char M0, char M1, char d0, char d1) {
        Locale local = Locale.getDefault();
        this.calendar = Calendar.getInstance(TimeZone.getDefault(), local);
        int year = digits[y0] * 1000 + digits[y1] * 100 + digits[y2] * 10 + digits[y3];
        int month = digits[M0] * 10 + digits[M1] - 1;
        int day = digits[d0] * 10 + digits[d1];
        this.calendar.set(1, year);
        this.calendar.set(2, month);
        this.calendar.set(5, day);
    }

    static boolean checkDate(char y0, char y1, char y2, char y3, char M0, char M1, int d0, int d1) {
        if (y0 != '1' && y0 != '2') {
            return false;
        }
        if (y1 < '0' || y1 > '9') {
            return false;
        }
        if (y2 < '0' || y2 > '9') {
            return false;
        }
        if (y3 < '0' || y3 > '9') {
            return false;
        }
        if (M0 == '0') {
            if (M1 < '1' || M1 > '9') {
                return false;
            }
        } else if (M0 == '1') {
            if (M1 != '0' && M1 != '1' && M1 != '2') {
                return false;
            }
        } else {
            return false;
        }
        if (d0 == 48) {
            if (d1 < 49 || d1 > 57) {
                return false;
            }
        } else if (d0 == 49 || d0 == 50) {
            if (d1 < 48 || d1 > 57) {
                return false;
            }
        } else if (d0 == 51) {
            if (d1 != 48 && d1 != 49) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean isEOF() {
        return this.bp == this.text.length() || this.ch == '\u001a' && this.bp + 1 == this.text.length();
    }

    @Override
    public final boolean isRef() {
        if (this.hasSpecial) {
            return false;
        }
        if (this.sp != 4) {
            return false;
        }
        return this.charAt(this.np + 1) == '$' && this.charAt(this.np + 2) == 'r' && this.charAt(this.np + 3) == 'e' && this.charAt(this.np + 4) == 'f';
    }

    @Override
    public int scanFieldInt(char[] fieldName) {
        int value;
        char ch;
        this.matchStat = 0;
        int startPos = this.bp;
        char startChar = this.ch;
        if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
            this.matchStat = -2;
            return 0;
        }
        int index = this.bp + fieldName.length;
        if ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
            value = digits[ch];
            while ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
                value = value * 10 + digits[ch];
            }
            if (ch == '.') {
                this.matchStat = -1;
                return 0;
            }
            this.bp = index - 1;
            if (value < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            this.matchStat = -1;
            return 0;
        }
        if (ch == ',') {
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (ch == '}') {
            if ((ch = this.charAt(++this.bp)) == ',') {
                this.token = 16;
                this.ch = this.charAt(++this.bp);
            } else if (ch == ']') {
                this.token = 15;
                this.ch = this.charAt(++this.bp);
            } else if (ch == '}') {
                this.token = 13;
                this.ch = this.charAt(++this.bp);
            } else if (ch == '\u001a') {
                this.token = 20;
            } else {
                this.bp = startPos;
                this.ch = startChar;
                this.matchStat = -1;
                return 0;
            }
            this.matchStat = 4;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String scanFieldString(char[] fieldName) {
        char ch;
        this.matchStat = 0;
        int startPos = this.bp;
        char startChar = this.ch;
        if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
            this.matchStat = -2;
            return this.stringDefaultValue();
        }
        int index = this.bp + fieldName.length;
        if ((ch = this.charAt(index++)) != '\"') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        boolean hasSpecial = false;
        int startIndex = index;
        int endIndex = this.text.indexOf(34, startIndex);
        if (endIndex == -1) {
            throw new JSONException("unclosed str");
        }
        String stringVal = this.subString(startIndex, endIndex - startIndex);
        for (int i = 0; i < stringVal.length(); ++i) {
            if (stringVal.charAt(i) != '\\') continue;
            hasSpecial = true;
            break;
        }
        if (hasSpecial) {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        this.bp = endIndex + 1;
        this.ch = ch = this.charAt(this.bp);
        String strVal = stringVal;
        if (ch == ',') {
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            return strVal;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        if ((ch = this.charAt(++this.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else {
            if (ch != '\u001a') {
                this.bp = startPos;
                this.ch = startChar;
                this.matchStat = -1;
                return this.stringDefaultValue();
            }
            this.token = 20;
        }
        this.matchStat = 4;
        return strVal;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String scanFieldSymbol(char[] fieldName, SymbolTable symbolTable) {
        String strVal;
        char ch;
        block12: {
            block13: {
                this.matchStat = 0;
                if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
                    this.matchStat = -2;
                    return null;
                }
                int index = this.bp + fieldName.length;
                if ((ch = this.charAt(index++)) != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                int start = index;
                int hash = 0;
                do {
                    if ((ch = this.charAt(index++)) == '\"') {
                        this.bp = index;
                        this.ch = ch = this.charAt(this.bp);
                        strVal = symbolTable.addSymbol(this.text, start, index - start - 1, hash);
                        if (ch != ',') break block12;
                        break block13;
                    }
                    hash = 31 * hash + ch;
                } while (ch != '\\');
                this.matchStat = -1;
                return null;
            }
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            return strVal;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((ch = this.charAt(++this.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else {
            if (ch != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
        }
        this.matchStat = 4;
        return strVal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> scanFieldStringArray(char[] fieldName, Class<?> type) {
        Collection<String> list;
        this.matchStat = 0;
        if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
            this.matchStat = -2;
            return null;
        }
        if (type.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (type.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else {
            try {
                list = type.newInstance();
            }
            catch (Exception e) {
                throw new JSONException(e.getMessage(), e);
            }
        }
        int index = this.bp + fieldName.length;
        char ch = this.charAt(index++);
        if (ch != '[') {
            this.matchStat = -1;
            return null;
        }
        ch = this.charAt(index++);
        block2: while (true) {
            block21: {
                if (ch != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                int start = index;
                do {
                    if ((ch = this.charAt(index++)) != '\"') continue;
                    String strVal = this.text.substring(start, index - 1);
                    list.add(strVal);
                    ch = this.charAt(index++);
                    if (ch != ',') break block2;
                    break block21;
                } while (ch != '\\');
                this.matchStat = -1;
                return null;
            }
            ch = this.charAt(index++);
        }
        if (ch != ']') {
            this.matchStat = -1;
            return null;
        }
        ch = this.charAt(index++);
        this.bp = index;
        if (ch == ',') {
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return list;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return null;
        }
        ch = this.charAt(this.bp);
        if (ch == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else {
            if (ch != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.ch = ch;
        }
        this.matchStat = 4;
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long scanFieldLong(char[] fieldName) {
        long value;
        char ch;
        this.matchStat = 0;
        int startPos = this.bp;
        char startChar = this.ch;
        if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
            this.matchStat = -2;
            return 0L;
        }
        int index = this.bp + fieldName.length;
        if ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
            value = digits[ch];
            while ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
                value = value * 10L + (long)digits[ch];
            }
            if (ch == '.') {
                this.matchStat = -1;
                return 0L;
            }
            this.bp = index - 1;
            if (value < 0L) {
                this.bp = startPos;
                this.ch = startChar;
                this.matchStat = -1;
                return 0L;
            }
        } else {
            this.bp = startPos;
            this.ch = startChar;
            this.matchStat = -1;
            return 0L;
        }
        if (ch == ',') {
            ch = this.charAt(++this.bp);
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return 0L;
        }
        if ((ch = this.charAt(++this.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else {
            if (ch != '\u001a') {
                this.bp = startPos;
                this.ch = startChar;
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
        }
        this.matchStat = 4;
        return value;
    }

    @Override
    public boolean scanFieldBoolean(char[] fieldName) {
        boolean value;
        char ch;
        this.matchStat = 0;
        if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
            this.matchStat = -2;
            return false;
        }
        int index = this.bp + fieldName.length;
        if ((ch = this.charAt(index++)) == 't') {
            if (this.charAt(index++) != 'r') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(index++) != 'u') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(index++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            this.bp = index;
            ch = this.charAt(this.bp);
            value = true;
        } else if (ch == 'f') {
            if (this.charAt(index++) != 'a') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(index++) != 'l') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(index++) != 's') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(index++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            this.bp = index;
            ch = this.charAt(this.bp);
            value = false;
        } else {
            this.matchStat = -1;
            return false;
        }
        if (ch == ',') {
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            this.token = 16;
        } else if (ch == '}') {
            if ((ch = this.charAt(++this.bp)) == ',') {
                this.token = 16;
                this.ch = this.charAt(++this.bp);
            } else if (ch == ']') {
                this.token = 15;
                this.ch = this.charAt(++this.bp);
            } else if (ch == '}') {
                this.token = 13;
                this.ch = this.charAt(++this.bp);
            } else if (ch == '\u001a') {
                this.token = 20;
            } else {
                this.matchStat = -1;
                return false;
            }
            this.matchStat = 4;
        } else {
            this.matchStat = -1;
            return false;
        }
        return value;
    }

    @Override
    public final void scanString() {
        char ch;
        this.np = this.bp;
        this.hasSpecial = false;
        block22: while ((ch = this.charAt(++this.bp)) != '\"') {
            if (ch == '\\') {
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp >= this.sbuf.length) {
                        int newCapcity = this.sbuf.length * 2;
                        if (this.sp > newCapcity) {
                            newCapcity = this.sp;
                        }
                        char[] newsbuf = new char[newCapcity];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    this.text.getChars(this.np + 1, this.np + 1 + this.sp, this.sbuf, 0);
                }
                ch = this.charAt(++this.bp);
                switch (ch) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        char x1 = ch = this.charAt(++this.bp);
                        char x2 = ch = this.charAt(++this.bp);
                        int x_val = digits[x1] * 16 + digits[x2];
                        char x_char = (char)x_val;
                        this.putChar(x_char);
                        continue block22;
                    }
                    case 'u': {
                        char u1 = ch = this.charAt(++this.bp);
                        char u2 = ch = this.charAt(++this.bp);
                        char u3 = ch = this.charAt(++this.bp);
                        char u4 = ch = this.charAt(++this.bp);
                        int val = Integer.parseInt(new String(new char[]{u1, u2, u3, u4}), 16);
                        this.putChar((char)val);
                        continue block22;
                    }
                }
                this.ch = ch;
                throw new JSONException("unclosed string : " + ch);
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(ch);
                continue;
            }
            this.sbuf[this.sp++] = ch;
        }
        this.token = 4;
        this.ch = this.charAt(++this.bp);
    }
}

