/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.util.Base64;
import com.alibaba.fastjson.util.IOUtils;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;

public final class JSONReaderScanner
extends JSONLexer {
    public static final int BUF_INIT_LEN = 8192;
    private static final ThreadLocal<SoftReference<char[]>> BUF_REF_LOCAL = new ThreadLocal();
    private Reader reader;
    private char[] buf;
    private int bufLength;

    public JSONReaderScanner(String input) {
        this(input, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(String input, int features) {
        this(new StringReader(input), features);
    }

    public JSONReaderScanner(char[] input, int inputLength) {
        this(input, inputLength, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(Reader reader) {
        this(reader, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(Reader reader, int features) {
        this.reader = reader;
        this.features = features;
        SoftReference<char[]> bufRef = BUF_REF_LOCAL.get();
        if (bufRef != null) {
            this.buf = bufRef.get();
            BUF_REF_LOCAL.set(null);
        }
        if (this.buf == null) {
            this.buf = new char[8192];
        }
        try {
            this.bufLength = reader.read(this.buf);
        }
        catch (IOException e) {
            throw new JSONException(e.getMessage(), e);
        }
        this.bp = -1;
        this.next();
        if (this.ch == '\ufeff') {
            this.next();
        }
    }

    public JSONReaderScanner(char[] input, int inputLength, int features) {
        this(new CharArrayReader(input, 0, inputLength), features);
    }

    public final char charAt(int index) {
        if (index >= this.bufLength) {
            if (this.bufLength == -1) {
                if (index < this.sp) {
                    return this.buf[index];
                }
                return '\u001a';
            }
            int rest = this.bufLength - this.bp;
            if (rest > 0) {
                System.arraycopy(this.buf, this.bp, this.buf, 0, rest);
            }
            try {
                this.bufLength = this.reader.read(this.buf, rest, this.buf.length - rest);
            }
            catch (IOException e) {
                throw new JSONException(e.getMessage(), e);
            }
            if (this.bufLength == 0) {
                throw new JSONException("illegal stat, textLength is zero");
            }
            if (this.bufLength == -1) {
                return '\u001a';
            }
            this.bufLength += rest;
            index -= this.bp;
            this.np -= this.bp;
            this.bp = 0;
        }
        return this.buf[index];
    }

    public final int indexOf(char ch, int startIndex) {
        int offset = startIndex;
        while (ch != this.charAt(offset)) {
            if (ch == '\u001a') {
                return -1;
            }
            ++offset;
        }
        return offset;
    }

    public final String addSymbol(int offset, int len, int hash, SymbolTable symbolTable) {
        return symbolTable.addSymbol(this.buf, offset, len, hash);
    }

    public final char next() {
        int index;
        if ((index = ++this.bp) >= this.bufLength) {
            if (this.bufLength == -1) {
                return '\u001a';
            }
            if (this.sp > 0) {
                if (this.token == 4) {
                    System.arraycopy(this.buf, this.buf.length - this.sp, this.buf, 0, this.sp);
                    this.np = -1 + this.sp;
                } else {
                    System.arraycopy(this.buf, this.bufLength - this.sp, this.buf, 0, this.sp);
                    this.np = 0;
                }
            }
            index = this.bp = this.sp;
            try {
                int startPos = this.bp;
                int readLength = this.buf.length - startPos;
                this.bufLength = this.reader.read(this.buf, this.bp, readLength);
            }
            catch (IOException e) {
                throw new JSONException(e.getMessage(), e);
            }
            if (this.bufLength == 0) {
                throw new JSONException("illegal stat, textLength is zero");
            }
            if (this.bufLength == -1) {
                this.ch = '\u001a';
                return '\u001a';
            }
            this.bufLength += this.bp;
        }
        this.ch = this.buf[index];
        return this.ch;
    }

    protected final void copyTo(int offset, int count, char[] dest) {
        System.arraycopy(this.buf, offset, dest, 0, count);
    }

    public final boolean charArrayCompare(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (this.charAt(this.bp + i) == chars[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] bytesValue() {
        return Base64.decodeFast(this.buf, this.np + 1, this.sp);
    }

    protected final void arrayCopy(int srcPos, char[] dest, int destPos, int length) {
        System.arraycopy(this.buf, srcPos, dest, destPos, length);
    }

    public final String stringVal() {
        if (!this.hasSpecial) {
            return new String(this.buf, this.np + 1, this.sp);
        }
        return new String(this.sbuf, 0, this.sp);
    }

    public final String subString(int offset, int count) {
        return new String(this.buf, offset, count);
    }

    public final String numberString() {
        char chLocal = this.charAt(this.np + this.sp - 1);
        int sp = this.sp;
        if (chLocal == 'L' || chLocal == 'S' || chLocal == 'B' || chLocal == 'F' || chLocal == 'D') {
            --sp;
        }
        return new String(this.buf, this.np, sp);
    }

    public void close() {
        super.close();
        BUF_REF_LOCAL.set(new SoftReference<char[]>(this.buf));
        this.buf = null;
        IOUtils.close(this.reader);
    }

    public boolean isEOF() {
        return this.bufLength == -1 || this.bp == this.buf.length || this.ch == '\u001a' && this.bp + 1 == this.buf.length;
    }
}

