/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.serializer.BeanContext;
import com.alibaba.fastjson.serializer.FieldSerializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeFilterable;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanSerializer
extends SerializeFilterable
implements ObjectSerializer {
    protected final FieldSerializer[] getters;
    protected final FieldSerializer[] sortedGetters;
    protected int features = 0;
    protected final Class<?> beanType;
    protected String typeName;
    protected final JSONType jsonType;

    public JavaBeanSerializer(Class<?> beanType) {
        this(beanType, (Map<String, String>)null);
    }

    public JavaBeanSerializer(Class<?> beanType, String ... aliasList) {
        this(beanType, JavaBeanSerializer.createAliasMap(aliasList));
    }

    static Map<String, String> createAliasMap(String ... aliasList) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        for (String alias : aliasList) {
            aliasMap.put(alias, alias);
        }
        return aliasMap;
    }

    public JavaBeanSerializer(Class<?> beanType, Map<String, String> aliasMap) {
        this(beanType, aliasMap, TypeUtils.getSerializeFeatures(beanType));
    }

    public JavaBeanSerializer(Class<?> beanType, Map<String, String> aliasMap, int features) {
        this.features = features;
        this.beanType = beanType;
        this.jsonType = beanType.getAnnotation(JSONType.class);
        if (this.jsonType != null) {
            features = SerializerFeature.of(this.jsonType.serialzeFeatures());
        }
        ArrayList<FieldSerializer> getterList = new ArrayList<FieldSerializer>();
        List<FieldInfo> fieldInfoList = TypeUtils.computeGetters(beanType, this.jsonType, aliasMap, false);
        for (FieldInfo fieldInfo : fieldInfoList) {
            getterList.add(new FieldSerializer(beanType, fieldInfo));
        }
        this.getters = getterList.toArray(new FieldSerializer[getterList.size()]);
        String[] orders = null;
        if (this.jsonType != null) {
            orders = this.jsonType.orders();
            String typeName = this.jsonType.typeName();
            if (typeName.length() != 0) {
                this.typeName = typeName;
            }
        }
        if (orders != null && orders.length != 0) {
            fieldInfoList = TypeUtils.computeGetters(beanType, this.jsonType, aliasMap, true);
            ArrayList<FieldSerializer> getterList2 = new ArrayList<FieldSerializer>();
            for (FieldInfo fieldInfo : fieldInfoList) {
                FieldSerializer fieldDeser = new FieldSerializer(beanType, fieldInfo);
                getterList2.add(fieldDeser);
            }
            this.sortedGetters = getterList2.toArray(new FieldSerializer[getterList2.size()]);
        } else {
            Object[] sortedGetters = new FieldSerializer[this.getters.length];
            System.arraycopy(this.getters, 0, sortedGetters, 0, this.getters.length);
            Arrays.sort(sortedGetters);
            this.sortedGetters = Arrays.equals(sortedGetters, this.getters) ? this.getters : sortedGetters;
        }
    }

    public void writeDirectNonContext(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        this.write(serializer, object, fieldName, fieldType, features);
    }

    public void writeAsArrayNonContext(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        this.write(serializer, object, fieldName, fieldType, features);
    }

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull();
            return;
        }
        if (this.writeReference(serializer, object, features)) {
            return;
        }
        FieldSerializer[] getters = out.sortField ? this.sortedGetters : this.getters;
        SerialContext parent = serializer.context;
        serializer.setContext(parent, object, fieldName, this.features, features);
        boolean writeAsArray = this.isWriteAsArray(serializer);
        try {
            Class<?> objClass;
            char startSeperator = writeAsArray ? (char)'[' : '{';
            char endSeperator = writeAsArray ? (char)']' : '}';
            out.append(startSeperator);
            if (getters.length > 0 && out.isEnabled(SerializerFeature.PrettyFormat)) {
                serializer.incrementIndent();
                serializer.println();
            }
            boolean commaFlag = false;
            if (((this.features & SerializerFeature.WriteClassName.mask) != 0 || serializer.isWriteClassName(fieldType, object)) && (objClass = object.getClass()) != fieldType) {
                out.writeFieldName(JSON.DEFAULT_TYPE_KEY, false);
                if (this.typeName == null) {
                    this.typeName = object.getClass().getName();
                }
                serializer.write(this.typeName);
                commaFlag = true;
            }
            char seperator = commaFlag ? (char)',' : '\u0000';
            boolean directWritePrefix = out.quoteFieldNames && !out.useSingleQuotes;
            char newSeperator = serializer.writeBefore(this, object, seperator);
            commaFlag = newSeperator == ',';
            boolean skipTransient = out.isEnabled(SerializerFeature.SkipTransientField);
            boolean ignoreNonFieldGetter = out.isEnabled(SerializerFeature.IgnoreNonFieldGetter);
            for (int i = 0; i < getters.length; ++i) {
                Class<?> fieldCLass;
                Object propertyValue;
                FieldSerializer fieldSerializer = getters[i];
                Field field = fieldSerializer.fieldInfo.field;
                FieldInfo fieldInfo = fieldSerializer.fieldInfo;
                String fieldInfoName = fieldInfo.name;
                Class<?> fieldClass = fieldInfo.fieldClass;
                if (skipTransient && field != null && fieldInfo.fieldTransient || ignoreNonFieldGetter && field == null || !serializer.applyName(this, object, fieldInfo.name) || !serializer.applyLabel(this, fieldInfo.label)) continue;
                try {
                    propertyValue = fieldSerializer.getPropertyValue(object);
                }
                catch (InvocationTargetException ex) {
                    if (out.isEnabled(SerializerFeature.IgnoreErrorGetter)) {
                        propertyValue = null;
                    }
                    throw ex;
                }
                if (!serializer.apply(this, object, fieldInfoName, propertyValue)) continue;
                String key = fieldInfoName;
                key = serializer.processKey(this, object, key, propertyValue);
                Object originalValue = propertyValue;
                if ((propertyValue = serializer.processValue(this, fieldSerializer.fieldContext, object, fieldInfoName, propertyValue)) == null && !writeAsArray && !fieldSerializer.writeNull && !out.isEnabled(SerializerFeature.WriteMapNullValue) || propertyValue != null && out.notWriteDefaultValue && ((fieldCLass = fieldInfo.fieldClass) == Byte.TYPE && propertyValue instanceof Byte && (Byte)propertyValue == 0 || fieldCLass == Short.TYPE && propertyValue instanceof Short && (Short)propertyValue == 0 || fieldCLass == Integer.TYPE && propertyValue instanceof Integer && (Integer)propertyValue == 0 || fieldCLass == Long.TYPE && propertyValue instanceof Long && (Long)propertyValue == 0L || fieldCLass == Float.TYPE && propertyValue instanceof Float && ((Float)propertyValue).floatValue() == 0.0f || fieldCLass == Double.TYPE && propertyValue instanceof Double && (Double)propertyValue == 0.0 || fieldCLass == Boolean.TYPE && propertyValue instanceof Boolean && !((Boolean)propertyValue).booleanValue())) continue;
                if (commaFlag) {
                    out.write(44);
                    if (out.isEnabled(SerializerFeature.PrettyFormat)) {
                        serializer.println();
                    }
                }
                if (key != fieldInfoName) {
                    if (!writeAsArray) {
                        out.writeFieldName(key, true);
                    }
                    serializer.write(propertyValue);
                } else if (originalValue != propertyValue) {
                    if (!writeAsArray) {
                        fieldSerializer.writePrefix(serializer);
                    }
                    serializer.write(propertyValue);
                } else {
                    if (!writeAsArray) {
                        if (directWritePrefix) {
                            out.write(fieldInfo.name_chars, 0, fieldInfo.name_chars.length);
                        } else {
                            fieldSerializer.writePrefix(serializer);
                        }
                    }
                    if (!writeAsArray) {
                        if (fieldClass == String.class) {
                            if (propertyValue == null) {
                                if ((out.features & SerializerFeature.WriteNullStringAsEmpty.mask) != 0 || (fieldSerializer.features & SerializerFeature.WriteNullStringAsEmpty.mask) != 0) {
                                    out.writeString("");
                                } else {
                                    out.writeNull();
                                }
                            } else {
                                String propertyValueString = (String)propertyValue;
                                if (out.useSingleQuotes) {
                                    out.writeStringWithSingleQuote(propertyValueString);
                                } else {
                                    out.writeStringWithDoubleQuote(propertyValueString, '\u0000');
                                }
                            }
                        } else {
                            fieldSerializer.writeValue(serializer, propertyValue);
                        }
                    } else {
                        fieldSerializer.writeValue(serializer, propertyValue);
                    }
                }
                commaFlag = true;
            }
            serializer.writeAfter(this, object, commaFlag ? (char)',' : '\u0000');
            if (getters.length > 0 && out.isEnabled(SerializerFeature.PrettyFormat)) {
                serializer.decrementIdent();
                serializer.println();
            }
            out.append(endSeperator);
        }
        catch (Exception e) {
            String errorMessage = "write javaBean error";
            if (object != null) {
                errorMessage = errorMessage + ", class " + object.getClass().getName();
            }
            if (fieldName != null) {
                errorMessage = errorMessage + ", fieldName : " + fieldName;
            }
            if (e.getMessage() != null) {
                errorMessage = errorMessage + ", " + e.getMessage();
            }
            throw new JSONException(errorMessage, e);
        }
        finally {
            serializer.context = parent;
        }
    }

    public boolean writeReference(JSONSerializer serializer, Object object, int fieldFeatures) {
        SerialContext context = serializer.context;
        int mask = SerializerFeature.DisableCircularReferenceDetect.mask;
        if (context == null || (context.features & mask) != 0 || (fieldFeatures & mask) != 0) {
            return false;
        }
        if (serializer.references != null && serializer.references.containsKey(object)) {
            serializer.writeReference(object);
            return true;
        }
        return false;
    }

    public boolean isWriteAsArray(JSONSerializer serializer) {
        return (this.features & SerializerFeature.BeanToArray.mask) != 0 || serializer.out.beanToArray;
    }

    public FieldSerializer getFieldSerializer(String key) {
        if (key == null) {
            return null;
        }
        int low = 0;
        int high = this.sortedGetters.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            String fieldName = this.sortedGetters[mid].fieldInfo.name;
            int cmp = fieldName.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return this.sortedGetters[mid];
        }
        return null;
    }

    public List<Object> getFieldValues(Object object) throws Exception {
        ArrayList<Object> fieldValues = new ArrayList<Object>(this.sortedGetters.length);
        for (FieldSerializer getter : this.sortedGetters) {
            fieldValues.add(getter.getPropertyValue(object));
        }
        return fieldValues;
    }

    public int getSize(Object object) throws Exception {
        int size = 0;
        for (FieldSerializer getter : this.sortedGetters) {
            Object value = getter.getPropertyValue(object);
            if (value == null) continue;
            ++size;
        }
        return size;
    }

    public Map<String, Object> getFieldValuesMap(Object object) throws Exception {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(this.sortedGetters.length);
        for (FieldSerializer getter : this.sortedGetters) {
            map.put(getter.fieldInfo.name, getter.getPropertyValue(object));
        }
        return map;
    }

    protected BeanContext getBeanContext(int orinal) {
        return this.sortedGetters[orinal].fieldContext;
    }

    protected Type getFieldType(int ordinal) {
        return this.sortedGetters[ordinal].fieldInfo.fieldType;
    }
}

