/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONStreamAware;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.deserializer.Jdk8DateCodec;
import com.alibaba.fastjson.serializer.ASMSerializerFactory;
import com.alibaba.fastjson.serializer.AppendableSerializer;
import com.alibaba.fastjson.serializer.ArraySerializer;
import com.alibaba.fastjson.serializer.AtomicBooleanSerializer;
import com.alibaba.fastjson.serializer.AtomicIntegerArrayCodec;
import com.alibaba.fastjson.serializer.AtomicIntegerSerializer;
import com.alibaba.fastjson.serializer.AtomicLongArrayCodec;
import com.alibaba.fastjson.serializer.AtomicLongSerializer;
import com.alibaba.fastjson.serializer.AutowiredObjectSerializer;
import com.alibaba.fastjson.serializer.BigDecimalCodec;
import com.alibaba.fastjson.serializer.BigIntegerCodec;
import com.alibaba.fastjson.serializer.BooleanArraySerializer;
import com.alibaba.fastjson.serializer.BooleanCodec;
import com.alibaba.fastjson.serializer.ByteArraySerializer;
import com.alibaba.fastjson.serializer.CalendarCodec;
import com.alibaba.fastjson.serializer.CharArraySerializer;
import com.alibaba.fastjson.serializer.CharacterCodec;
import com.alibaba.fastjson.serializer.CharsetCodec;
import com.alibaba.fastjson.serializer.ClassSerializer;
import com.alibaba.fastjson.serializer.ClobSeriliazer;
import com.alibaba.fastjson.serializer.CollectionSerializer;
import com.alibaba.fastjson.serializer.ColorCodec;
import com.alibaba.fastjson.serializer.CurrencyCodec;
import com.alibaba.fastjson.serializer.DateFormatSerializer;
import com.alibaba.fastjson.serializer.DateSerializer;
import com.alibaba.fastjson.serializer.DoubleArraySerializer;
import com.alibaba.fastjson.serializer.DoubleSerializer;
import com.alibaba.fastjson.serializer.EnumSerializer;
import com.alibaba.fastjson.serializer.EnumerationSeriliazer;
import com.alibaba.fastjson.serializer.ExceptionSerializer;
import com.alibaba.fastjson.serializer.FileCodec;
import com.alibaba.fastjson.serializer.FloatArraySerializer;
import com.alibaba.fastjson.serializer.FloatCodec;
import com.alibaba.fastjson.serializer.FontCodec;
import com.alibaba.fastjson.serializer.InetAddressCodec;
import com.alibaba.fastjson.serializer.InetSocketAddressCodec;
import com.alibaba.fastjson.serializer.IntArraySerializer;
import com.alibaba.fastjson.serializer.IntegerCodec;
import com.alibaba.fastjson.serializer.JSONAwareSerializer;
import com.alibaba.fastjson.serializer.JSONSerializable;
import com.alibaba.fastjson.serializer.JSONSerializableSerializer;
import com.alibaba.fastjson.serializer.JSONStreamAwareSerializer;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.ListSerializer;
import com.alibaba.fastjson.serializer.LocaleCodec;
import com.alibaba.fastjson.serializer.LongArraySerializer;
import com.alibaba.fastjson.serializer.LongCodec;
import com.alibaba.fastjson.serializer.MapSerializer;
import com.alibaba.fastjson.serializer.ObjectArraySerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PatternCodec;
import com.alibaba.fastjson.serializer.PointCodec;
import com.alibaba.fastjson.serializer.RectangleCodec;
import com.alibaba.fastjson.serializer.ReferenceCodec;
import com.alibaba.fastjson.serializer.ShortArraySerializer;
import com.alibaba.fastjson.serializer.StringCodec;
import com.alibaba.fastjson.serializer.TimeZoneCodec;
import com.alibaba.fastjson.serializer.URICodec;
import com.alibaba.fastjson.serializer.URLCodec;
import com.alibaba.fastjson.serializer.UUIDCodec;
import com.alibaba.fastjson.util.ASMUtils;
import com.alibaba.fastjson.util.IdentityHashMap;
import com.alibaba.fastjson.util.ServiceLoader;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializeConfig
extends IdentityHashMap<Type, ObjectSerializer> {
    private static final SerializeConfig globalInstance = new SerializeConfig();
    private boolean asm = !ASMUtils.isAndroid();
    private ASMSerializerFactory asmFactory;
    private String typeKey = JSON.DEFAULT_TYPE_KEY;

    public String getTypeKey() {
        return this.typeKey;
    }

    public void setTypeKey(String typeKey) {
        this.typeKey = typeKey;
    }

    public final ObjectSerializer createASMSerializer(Class<?> clazz) throws Exception {
        return this.asmFactory.createJavaBeanSerializer(clazz, null);
    }

    public ObjectSerializer createJavaBeanSerializer(Class<?> clazz) {
        JSONType annotation;
        if (!Modifier.isPublic(clazz.getModifiers())) {
            return new JavaBeanSerializer(clazz);
        }
        boolean asm = this.asm;
        if (asm && this.asmFactory.isExternalClass(clazz) || clazz == Serializable.class || clazz == Object.class) {
            asm = false;
        }
        if ((annotation = clazz.getAnnotation(JSONType.class)) != null && !annotation.asm()) {
            asm = false;
        }
        if (asm && !ASMUtils.checkName(clazz.getName())) {
            asm = false;
        }
        if (asm) {
            try {
                ObjectSerializer asmSerializer = this.createASMSerializer(clazz);
                if (asmSerializer != null) {
                    return asmSerializer;
                }
            }
            catch (ClassCastException e) {
            }
            catch (Throwable e) {
                throw new JSONException("create asm serializer error, class " + clazz, e);
            }
        }
        return new JavaBeanSerializer(clazz);
    }

    public boolean isAsmEnable() {
        return this.asm;
    }

    public void setAsmEnable(boolean asmEnable) {
        this.asm = asmEnable;
    }

    public static final SerializeConfig getGlobalInstance() {
        return globalInstance;
    }

    public SerializeConfig() {
        this(1024);
    }

    public SerializeConfig(int tableSize) {
        super(tableSize);
        try {
            this.asmFactory = new ASMSerializerFactory();
        }
        catch (NoClassDefFoundError eror) {
            this.asm = false;
        }
        catch (ExceptionInInitializerError error) {
            this.asm = false;
        }
        this.put(Boolean.class, BooleanCodec.instance);
        this.put(Character.class, CharacterCodec.instance);
        this.put(Byte.class, IntegerCodec.instance);
        this.put(Short.class, IntegerCodec.instance);
        this.put(Integer.class, IntegerCodec.instance);
        this.put(Long.class, LongCodec.instance);
        this.put(Float.class, FloatCodec.instance);
        this.put(Double.class, DoubleSerializer.instance);
        this.put(BigDecimal.class, BigDecimalCodec.instance);
        this.put(BigInteger.class, BigIntegerCodec.instance);
        this.put(String.class, StringCodec.instance);
        this.put(byte[].class, ByteArraySerializer.instance);
        this.put(short[].class, ShortArraySerializer.instance);
        this.put(int[].class, IntArraySerializer.instance);
        this.put(long[].class, LongArraySerializer.instance);
        this.put(float[].class, FloatArraySerializer.instance);
        this.put(double[].class, DoubleArraySerializer.instance);
        this.put(boolean[].class, BooleanArraySerializer.instance);
        this.put(char[].class, CharArraySerializer.instance);
        this.put(Object[].class, ObjectArraySerializer.instance);
        this.put(Class.class, ClassSerializer.instance);
        this.put(SimpleDateFormat.class, DateFormatSerializer.instance);
        this.put(Locale.class, LocaleCodec.instance);
        this.put(Currency.class, CurrencyCodec.instance);
        this.put(TimeZone.class, TimeZoneCodec.instance);
        this.put(UUID.class, UUIDCodec.instance);
        this.put(InetAddress.class, InetAddressCodec.instance);
        this.put(Inet4Address.class, InetAddressCodec.instance);
        this.put(Inet6Address.class, InetAddressCodec.instance);
        this.put(InetSocketAddress.class, InetSocketAddressCodec.instance);
        this.put(File.class, FileCodec.instance);
        this.put(URI.class, URICodec.instance);
        this.put(URL.class, URLCodec.instance);
        this.put(Appendable.class, AppendableSerializer.instance);
        this.put(StringBuffer.class, AppendableSerializer.instance);
        this.put(StringBuilder.class, AppendableSerializer.instance);
        this.put(Pattern.class, PatternCodec.instance);
        this.put(Charset.class, CharsetCodec.instance);
        this.put(AtomicBoolean.class, AtomicBooleanSerializer.instance);
        this.put(AtomicInteger.class, AtomicIntegerSerializer.instance);
        this.put(AtomicLong.class, AtomicLongSerializer.instance);
        this.put(AtomicReference.class, ReferenceCodec.instance);
        this.put(AtomicIntegerArray.class, AtomicIntegerArrayCodec.instance);
        this.put(AtomicLongArray.class, AtomicLongArrayCodec.instance);
        this.put(WeakReference.class, ReferenceCodec.instance);
        this.put(SoftReference.class, ReferenceCodec.instance);
        try {
            this.put(Class.forName("java.awt.Color"), ColorCodec.instance);
            this.put(Class.forName("java.awt.Font"), FontCodec.instance);
            this.put(Class.forName("java.awt.Point"), PointCodec.instance);
            this.put(Class.forName("java.awt.Rectangle"), RectangleCodec.instance);
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.put(Class.forName("java.time.LocalDateTime"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.LocalDate"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.LocalTime"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.ZonedDateTime"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.OffsetDateTime"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.OffsetTime"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.ZoneOffset"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.ZoneRegion"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.Period"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.Duration"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.Instant"), Jdk8DateCodec.instance);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ObjectSerializer getObjectWriter(Class<?> clazz) {
        AutowiredObjectSerializer autowired;
        ClassLoader classLoader;
        ObjectSerializer writer = (ObjectSerializer)this.get(clazz);
        if (writer == null) {
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
                for (AutowiredObjectSerializer autowiredObjectSerializer : ServiceLoader.load(AutowiredObjectSerializer.class, classLoader)) {
                    if (!(autowiredObjectSerializer instanceof AutowiredObjectSerializer)) continue;
                    autowired = autowiredObjectSerializer;
                    for (Type forType : autowired.getAutowiredFor()) {
                        this.put(forType, autowired);
                    }
                }
            }
            catch (ClassCastException ex) {
                // empty catch block
            }
            writer = (ObjectSerializer)this.get(clazz);
        }
        if (writer == null && (classLoader = JSON.class.getClassLoader()) != Thread.currentThread().getContextClassLoader()) {
            try {
                for (AutowiredObjectSerializer autowiredObjectSerializer : ServiceLoader.load(AutowiredObjectSerializer.class, classLoader)) {
                    if (!(autowiredObjectSerializer instanceof AutowiredObjectSerializer)) continue;
                    autowired = autowiredObjectSerializer;
                    for (Type forType : autowired.getAutowiredFor()) {
                        this.put(forType, autowired);
                    }
                }
            }
            catch (ClassCastException ex) {
                // empty catch block
            }
            writer = (ObjectSerializer)this.get(clazz);
        }
        if (writer == null) {
            if (Map.class.isAssignableFrom(clazz)) {
                this.put(clazz, MapSerializer.instance);
            } else if (List.class.isAssignableFrom(clazz)) {
                this.put(clazz, ListSerializer.instance);
            } else if (Collection.class.isAssignableFrom(clazz)) {
                this.put(clazz, CollectionSerializer.instance);
            } else if (Date.class.isAssignableFrom(clazz)) {
                this.put(clazz, DateSerializer.instance);
            } else if (JSONAware.class.isAssignableFrom(clazz)) {
                this.put(clazz, JSONAwareSerializer.instance);
            } else if (JSONSerializable.class.isAssignableFrom(clazz)) {
                this.put(clazz, JSONSerializableSerializer.instance);
            } else if (JSONStreamAware.class.isAssignableFrom(clazz)) {
                this.put(clazz, JSONStreamAwareSerializer.instance);
            } else if (clazz.isEnum() || clazz.getSuperclass() != null && clazz.getSuperclass().isEnum()) {
                this.put(clazz, EnumSerializer.instance);
            } else if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                ObjectSerializer compObjectSerializer = this.getObjectWriter(componentType);
                this.put(clazz, new ArraySerializer(componentType, compObjectSerializer));
            } else if (Throwable.class.isAssignableFrom(clazz)) {
                this.put(clazz, new ExceptionSerializer(clazz));
            } else if (TimeZone.class.isAssignableFrom(clazz)) {
                this.put(clazz, TimeZoneCodec.instance);
            } else if (Appendable.class.isAssignableFrom(clazz)) {
                this.put(clazz, AppendableSerializer.instance);
            } else if (Charset.class.isAssignableFrom(clazz)) {
                this.put(clazz, CharsetCodec.instance);
            } else if (Enumeration.class.isAssignableFrom(clazz)) {
                this.put(clazz, EnumerationSeriliazer.instance);
            } else if (Calendar.class.isAssignableFrom(clazz)) {
                this.put(clazz, CalendarCodec.instance);
            } else if (Clob.class.isAssignableFrom(clazz)) {
                this.put(clazz, ClobSeriliazer.instance);
            } else {
                boolean isCglibProxy = false;
                boolean isJavassistProxy = false;
                for (Class<?> item : clazz.getInterfaces()) {
                    if (item.getName().equals("net.sf.cglib.proxy.Factory") || item.getName().equals("org.springframework.cglib.proxy.Factory")) {
                        isCglibProxy = true;
                        break;
                    }
                    if (!item.getName().equals("javassist.util.proxy.ProxyObject")) continue;
                    isJavassistProxy = true;
                    break;
                }
                if (isCglibProxy || isJavassistProxy) {
                    Class<?> clazz2 = clazz.getSuperclass();
                    ObjectSerializer superWriter = this.getObjectWriter(clazz2);
                    this.put(clazz, superWriter);
                    return superWriter;
                }
                if (Proxy.isProxyClass(clazz)) {
                    this.put(clazz, this.createJavaBeanSerializer(clazz));
                } else {
                    this.put(clazz, this.createJavaBeanSerializer(clazz));
                }
            }
            writer = (ObjectSerializer)this.get(clazz);
        }
        return writer;
    }
}

