/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson2.JSONReader;
import java.io.Closeable;
import java.lang.reflect.Type;
import java.util.List;

public class DefaultJSONParser
implements Closeable {
    private final JSONReader reader;
    private final ParserConfig config;
    private final JSONScanner lexer;

    public DefaultJSONParser(String text) {
        this(JSONReader.of((String)text), ParserConfig.global);
    }

    public ParserConfig getConfig() {
        return this.config;
    }

    public DefaultJSONParser(String text, ParserConfig config) {
        this(JSONReader.of((String)text), config);
    }

    public DefaultJSONParser(JSONReader reader, ParserConfig config) {
        this.reader = reader;
        this.config = config;
        this.lexer = new JSONScanner(this.reader);
    }

    public JSONLexer getLexer() {
        return this.lexer;
    }

    public JSONReader getRawReader() {
        return this.reader;
    }

    public Object parse() {
        return this.reader.readAny();
    }

    public <T> List<T> parseArray(Class<T> clazz) {
        return this.reader.readArray(clazz);
    }

    public <T> T parseObject(Class<T> clazz) {
        return (T)this.reader.read(clazz);
    }

    public <T> T parseObject(Type type) {
        return (T)this.reader.read(type);
    }

    @Override
    public void close() {
        this.reader.close();
    }
}

