/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.JSONException;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class IOUtils {
    public static final Charset UTF8;
    public static final char[] DIGITS;
    public static final boolean[] firstIdentifierFlags;
    public static final boolean[] identifierFlags;
    public static final byte[] specicalFlags_doubleQuotes;
    public static final byte[] specicalFlags_singleQuotes;
    public static final boolean[] specicalFlags_doubleQuotesFlags;
    public static final boolean[] specicalFlags_singleQuotesFlags;
    public static final char[] replaceChars;
    public static final char[] CA;
    public static final int[] IA;

    public static void decode(CharsetDecoder charsetDecoder, ByteBuffer byteBuf, CharBuffer charByte) {
        try {
            CoderResult cr = charsetDecoder.decode(byteBuf, charByte, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = charsetDecoder.flush(charByte)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new JSONException("utf8 decode error, " + x.getMessage(), x);
        }
    }

    public static byte[] decodeBase64(String s) {
        int sIx;
        int sLen = s.length();
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[s.charAt(sIx) & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[s.charAt(eIx) & 0xFF] < 0) {
            --eIx;
        }
        int pad = s.charAt(eIx) == '=' ? (s.charAt(eIx - 1) == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (s.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[s.charAt(sIx++)] << 18 | IA[s.charAt(sIx++)] << 12 | IA[s.charAt(sIx++)] << 6 | IA[s.charAt(sIx++)];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[s.charAt(sIx++)] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    public static void close(Closeable x) {
        if (x != null) {
            try {
                x.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        int i;
        int c;
        UTF8 = StandardCharsets.UTF_8;
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        firstIdentifierFlags = new boolean[256];
        identifierFlags = new boolean[256];
        specicalFlags_doubleQuotes = new byte[161];
        specicalFlags_singleQuotes = new byte[161];
        specicalFlags_doubleQuotesFlags = new boolean[161];
        specicalFlags_singleQuotesFlags = new boolean[161];
        replaceChars = new char[93];
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        IA = new int[256];
        for (c = 0; c < firstIdentifierFlags.length; c = (int)((char)(c + 1))) {
            if (c >= 65 && c <= 90) {
                IOUtils.firstIdentifierFlags[c] = true;
                continue;
            }
            if (c >= 97 && c <= 122) {
                IOUtils.firstIdentifierFlags[c] = true;
                continue;
            }
            if (c != 95 && c != 36) continue;
            IOUtils.firstIdentifierFlags[c] = true;
        }
        for (c = 0; c < identifierFlags.length; c = (int)((char)(c + 1))) {
            if (c >= 65 && c <= 90) {
                IOUtils.identifierFlags[c] = true;
                continue;
            }
            if (c >= 97 && c <= 122) {
                IOUtils.identifierFlags[c] = true;
                continue;
            }
            if (c == 95) {
                IOUtils.identifierFlags[c] = true;
                continue;
            }
            if (c < 48 || c > 57) continue;
            IOUtils.identifierFlags[c] = true;
        }
        IOUtils.specicalFlags_doubleQuotes[0] = 4;
        IOUtils.specicalFlags_doubleQuotes[1] = 4;
        IOUtils.specicalFlags_doubleQuotes[2] = 4;
        IOUtils.specicalFlags_doubleQuotes[3] = 4;
        IOUtils.specicalFlags_doubleQuotes[4] = 4;
        IOUtils.specicalFlags_doubleQuotes[5] = 4;
        IOUtils.specicalFlags_doubleQuotes[6] = 4;
        IOUtils.specicalFlags_doubleQuotes[7] = 4;
        IOUtils.specicalFlags_doubleQuotes[8] = 1;
        IOUtils.specicalFlags_doubleQuotes[9] = 1;
        IOUtils.specicalFlags_doubleQuotes[10] = 1;
        IOUtils.specicalFlags_doubleQuotes[11] = 4;
        IOUtils.specicalFlags_doubleQuotes[12] = 1;
        IOUtils.specicalFlags_doubleQuotes[13] = 1;
        IOUtils.specicalFlags_doubleQuotes[34] = 1;
        IOUtils.specicalFlags_doubleQuotes[92] = 1;
        IOUtils.specicalFlags_singleQuotes[0] = 4;
        IOUtils.specicalFlags_singleQuotes[1] = 4;
        IOUtils.specicalFlags_singleQuotes[2] = 4;
        IOUtils.specicalFlags_singleQuotes[3] = 4;
        IOUtils.specicalFlags_singleQuotes[4] = 4;
        IOUtils.specicalFlags_singleQuotes[5] = 4;
        IOUtils.specicalFlags_singleQuotes[6] = 4;
        IOUtils.specicalFlags_singleQuotes[7] = 4;
        IOUtils.specicalFlags_singleQuotes[8] = 1;
        IOUtils.specicalFlags_singleQuotes[9] = 1;
        IOUtils.specicalFlags_singleQuotes[10] = 1;
        IOUtils.specicalFlags_singleQuotes[11] = 4;
        IOUtils.specicalFlags_singleQuotes[12] = 1;
        IOUtils.specicalFlags_singleQuotes[13] = 1;
        IOUtils.specicalFlags_singleQuotes[92] = 1;
        IOUtils.specicalFlags_singleQuotes[39] = 1;
        for (i = 14; i <= 31; ++i) {
            IOUtils.specicalFlags_doubleQuotes[i] = 4;
            IOUtils.specicalFlags_singleQuotes[i] = 4;
        }
        for (i = 127; i < 160; ++i) {
            IOUtils.specicalFlags_doubleQuotes[i] = 4;
            IOUtils.specicalFlags_singleQuotes[i] = 4;
        }
        for (i = 0; i < 161; ++i) {
            IOUtils.specicalFlags_doubleQuotesFlags[i] = specicalFlags_doubleQuotes[i] != 0;
            IOUtils.specicalFlags_singleQuotesFlags[i] = specicalFlags_singleQuotes[i] != 0;
        }
        IOUtils.replaceChars[0] = 48;
        IOUtils.replaceChars[1] = 49;
        IOUtils.replaceChars[2] = 50;
        IOUtils.replaceChars[3] = 51;
        IOUtils.replaceChars[4] = 52;
        IOUtils.replaceChars[5] = 53;
        IOUtils.replaceChars[6] = 54;
        IOUtils.replaceChars[7] = 55;
        IOUtils.replaceChars[8] = 98;
        IOUtils.replaceChars[9] = 116;
        IOUtils.replaceChars[10] = 110;
        IOUtils.replaceChars[11] = 118;
        IOUtils.replaceChars[12] = 102;
        IOUtils.replaceChars[13] = 114;
        IOUtils.replaceChars[34] = 34;
        IOUtils.replaceChars[39] = 39;
        IOUtils.replaceChars[47] = 47;
        IOUtils.replaceChars[92] = 92;
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (i = 0; i < iS; ++i) {
            IOUtils.IA[IOUtils.CA[i]] = i;
        }
        IOUtils.IA[61] = 0;
    }
}

