/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexerBase;
import com.alibaba.fastjson2.JSONReader;

public class JSONScanner
extends JSONLexerBase {
    private final JSONReader reader;
    private boolean orderedField;
    private String strVal;

    public JSONScanner(JSONReader reader) {
        this.reader = reader;
    }

    public JSONScanner(String str) {
        this.reader = JSONReader.of((String)str);
    }

    public JSONScanner(String str, int features) {
        this.reader = JSONReader.of((String)str, (JSONReader.Context)JSON.createReadContext(features, new Feature[0]));
    }

    @Override
    public JSONReader getReader() {
        return this.reader;
    }

    public boolean isOrderedField() {
        return this.orderedField;
    }

    @Override
    public String stringVal() {
        return this.strVal;
    }

    public void config(Feature feature, boolean state) {
        JSONReader.Feature rawFeature = null;
        boolean not = false;
        switch (feature) {
            case AllowUnQuotedFieldNames: {
                rawFeature = JSONReader.Feature.AllowUnQuotedFieldNames;
                break;
            }
            case SupportArrayToBean: {
                rawFeature = JSONReader.Feature.SupportArrayToBean;
                break;
            }
            case DisableFieldSmartMatch: {
                rawFeature = JSONReader.Feature.SupportSmartMatch;
                not = true;
                break;
            }
            case SupportAutoType: {
                rawFeature = JSONReader.Feature.SupportAutoType;
                break;
            }
            case NonStringKeyAsString: {
                rawFeature = JSONReader.Feature.NonStringKeyAsString;
                break;
            }
            case ErrorOnEnumNotMatch: {
                rawFeature = JSONReader.Feature.ErrorOnEnumNotMatch;
                break;
            }
            case SupportClassForName: {
                rawFeature = JSONReader.Feature.SupportClassForName;
                break;
            }
            case ErrorOnNotSupportAutoType: {
                rawFeature = JSONReader.Feature.ErrorOnNotSupportAutoType;
                break;
            }
            case UseNativeJavaObject: {
                rawFeature = JSONReader.Feature.UseNativeObject;
                break;
            }
            case UseBigDecimal: {
                rawFeature = JSONReader.Feature.UseBigDecimalForDoubles;
                not = true;
                break;
            }
            case OrderedField: {
                this.orderedField = state;
                break;
            }
        }
        if (rawFeature == null) {
            return;
        }
        if (not) {
            state = !state;
        }
        JSONReader.Context context = this.reader.getContext();
        context.config(rawFeature, state);
    }

    public boolean isEnabled(Feature feature) {
        JSONReader.Feature rawFeature = null;
        switch (feature) {
            case AllowUnQuotedFieldNames: {
                rawFeature = JSONReader.Feature.AllowUnQuotedFieldNames;
                break;
            }
            case SupportArrayToBean: {
                rawFeature = JSONReader.Feature.SupportArrayToBean;
                break;
            }
            case DisableFieldSmartMatch: {
                rawFeature = JSONReader.Feature.SupportSmartMatch;
                break;
            }
            case SupportAutoType: {
                rawFeature = JSONReader.Feature.SupportAutoType;
                break;
            }
            case NonStringKeyAsString: {
                rawFeature = JSONReader.Feature.NonStringKeyAsString;
                break;
            }
            case ErrorOnEnumNotMatch: {
                rawFeature = JSONReader.Feature.ErrorOnEnumNotMatch;
                break;
            }
            case SupportClassForName: {
                rawFeature = JSONReader.Feature.SupportClassForName;
                break;
            }
            case ErrorOnNotSupportAutoType: {
                rawFeature = JSONReader.Feature.ErrorOnNotSupportAutoType;
                break;
            }
            case UseNativeJavaObject: {
                rawFeature = JSONReader.Feature.UseNativeObject;
                break;
            }
            case UseBigDecimal: {
                return !this.reader.isEnabled(JSONReader.Feature.UseBigDecimalForDoubles);
            }
        }
        if (rawFeature == null) {
            return true;
        }
        return this.reader.isEnabled(rawFeature);
    }

    @Override
    public boolean isBlankInput() {
        return this.reader.isEnd();
    }

    @Override
    public int intValue() {
        return this.reader.getInt32Value();
    }

    @Override
    public long longValue() {
        return this.reader.getInt64Value();
    }

    @Override
    public final void nextToken() {
        this.strVal = null;
        char ch = this.reader.current();
        switch (ch) {
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                this.reader.next();
                return;
            }
            case '\"': 
            case '\'': {
                this.strVal = this.reader.readString();
                return;
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.reader.readNumber();
                return;
            }
            case 'f': 
            case 't': {
                this.reader.readBoolValue();
                return;
            }
            case 'n': {
                this.reader.readNull();
                return;
            }
        }
        if (this.reader.nextIfNull()) {
            return;
        }
        throw new JSONException("not support operation");
    }

    @Override
    public char getCurrent() {
        return this.reader.current();
    }

    @Override
    public final void nextToken(int expect) {
        this.strVal = null;
        boolean match = true;
        switch (expect) {
            case 17: {
                match = this.reader.nextIfMatch(':');
                break;
            }
            case 12: {
                match = this.reader.nextIfMatch('{');
                break;
            }
            case 14: {
                match = this.reader.nextIfMatch('[');
                break;
            }
            case 13: {
                match = this.reader.nextIfMatch('}');
                break;
            }
            case 15: {
                match = this.reader.nextIfMatch(']');
                break;
            }
            case 21: {
                match = this.reader.nextIfSet();
                break;
            }
            case 8: {
                match = this.reader.nextIfNull();
                break;
            }
            default: {
                throw new JSONException("not support operation");
            }
        }
        if (!match) {
            throw new JSONException("not support operation");
        }
    }

    @Override
    public boolean isEOF() {
        return this.reader.isEnd();
    }
}

