/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.plugin;

import com.alipay.sofa.ark.api.ArkConfigs;
import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.ClassLoaderUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.container.model.PluginContextImpl;
import com.alipay.sofa.ark.container.model.PluginModel;
import com.alipay.sofa.ark.container.service.classloader.PluginClassLoader;
import com.alipay.sofa.ark.loader.JarPluginArchive;
import com.alipay.sofa.ark.loader.archive.JarFileArchive;
import com.alipay.sofa.ark.loader.jar.JarFile;
import com.alipay.sofa.ark.spi.archive.Archive;
import com.alipay.sofa.ark.spi.archive.PluginArchive;
import com.alipay.sofa.ark.spi.model.Plugin;
import com.alipay.sofa.ark.spi.service.plugin.PluginFactoryService;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.jar.Attributes;

@Singleton
public class PluginFactoryServiceImpl
implements PluginFactoryService {
    public Plugin createPlugin(PluginArchive pluginArchive) throws IOException, IllegalArgumentException {
        AssertUtils.isTrue((boolean)this.isArkPlugin(pluginArchive), (String)"Archive must be a ark plugin!", (Object[])new Object[0]);
        PluginModel plugin = new PluginModel();
        Attributes manifestMainAttributes = pluginArchive.getManifest().getMainAttributes();
        plugin.setPluginName(manifestMainAttributes.getValue("pluginName")).setGroupId(manifestMainAttributes.getValue("groupId")).setArtifactId(manifestMainAttributes.getValue("artifactId")).setVersion(manifestMainAttributes.getValue("version")).setPriority(manifestMainAttributes.getValue("priority")).setPluginActivator(manifestMainAttributes.getValue("activator")).setClassPath(pluginArchive.getUrls()).setPluginUrl(pluginArchive.getUrl()).setExportClasses(manifestMainAttributes.getValue("export-classes")).setExportPackages(manifestMainAttributes.getValue("export-packages")).setImportClasses(manifestMainAttributes.getValue("import-classes")).setImportPackages(manifestMainAttributes.getValue("import-packages")).setImportResources(manifestMainAttributes.getValue("import-resources")).setExportResources(manifestMainAttributes.getValue("export-resources")).setPluginClassLoader(new PluginClassLoader(plugin.getPluginName(), plugin.getClassPath())).setPluginContext(new PluginContextImpl(plugin));
        return plugin;
    }

    public Plugin createPlugin(PluginArchive pluginArchive, URL[] extensions, Set<String> exportPackages) throws IOException, IllegalArgumentException {
        AssertUtils.isTrue((boolean)this.isArkPlugin(pluginArchive), (String)"Archive must be a ark plugin!", (Object[])new Object[0]);
        if (extensions == null || extensions.length == 0) {
            return this.createPlugin(pluginArchive);
        }
        PluginModel plugin = new PluginModel();
        Attributes manifestMainAttributes = pluginArchive.getManifest().getMainAttributes();
        plugin.setPluginName(manifestMainAttributes.getValue("pluginName")).setGroupId(manifestMainAttributes.getValue("groupId")).setArtifactId(manifestMainAttributes.getValue("artifactId")).setVersion(manifestMainAttributes.getValue("version")).setPriority(manifestMainAttributes.getValue("priority")).setPluginActivator(manifestMainAttributes.getValue("activator")).setClassPath(this.getFinalPluginUrls(pluginArchive, extensions, plugin.getPluginName())).setPluginUrl(pluginArchive.getUrl()).setExportMode(manifestMainAttributes.getValue("export-mode")).setExportClasses(manifestMainAttributes.getValue("export-classes")).setExportPackages(manifestMainAttributes.getValue("export-packages"), exportPackages).setImportClasses(manifestMainAttributes.getValue("import-classes")).setImportPackages(manifestMainAttributes.getValue("import-packages")).setImportResources(manifestMainAttributes.getValue("import-resources")).setExportResources(manifestMainAttributes.getValue("export-resources")).setPluginClassLoader(new PluginClassLoader(plugin.getPluginName(), plugin.getClassPath())).setPluginContext(new PluginContextImpl(plugin));
        return plugin;
    }

    public URL[] getFinalPluginUrls(PluginArchive pluginArchive, URL[] extensions, String pluginName) throws IOException {
        URL[] extensionUrls;
        URL[] urls = pluginArchive.getUrls();
        String excludeArtifact = ArkConfigs.getStringValue((String)String.format("PLUGIN-EXPORT[%s]", pluginName));
        if (StringUtils.isEmpty((String)excludeArtifact) || extensions == null) {
            return urls;
        }
        pluginArchive.setExtensionUrls(extensions);
        ArrayList<URL> urlList = new ArrayList<URL>(Arrays.asList(urls));
        ArrayList<URL> preRemoveList = new ArrayList<URL>();
        urlList.remove(null);
        block0: for (URL url : urlList) {
            String[] dependencies;
            for (String dependency : dependencies = excludeArtifact.split(";")) {
                String artifactId = dependency.split(":")[0];
                String version = dependency.split(":")[1];
                if (!url.getPath().endsWith(artifactId + "-" + version + ".jar!/")) continue;
                preRemoveList.add(url);
                continue block0;
            }
        }
        urlList.removeAll(preRemoveList);
        if (pluginArchive instanceof JarPluginArchive && (extensionUrls = ((JarPluginArchive)pluginArchive).getExtensionUrls()) != null) {
            urlList.addAll(Arrays.asList(extensionUrls));
        }
        Object[] objects = urlList.toArray();
        urls = new URL[objects.length];
        return urlList.toArray(urls);
    }

    public Plugin createPlugin(File file) throws IOException {
        JarFile pluginFile = new JarFile(file);
        JarFileArchive jarFileArchive = new JarFileArchive(pluginFile);
        JarPluginArchive jarPluginArchive = new JarPluginArchive((Archive)jarFileArchive);
        return this.createPlugin((PluginArchive)jarPluginArchive);
    }

    public Plugin createEmbedPlugin(PluginArchive pluginArchive, ClassLoader masterClassLoader) throws IOException {
        AssertUtils.isTrue((boolean)this.isArkPlugin(pluginArchive), (String)"Archive must be a ark plugin!", (Object[])new Object[0]);
        PluginModel plugin = new PluginModel();
        Attributes manifestMainAttributes = pluginArchive.getManifest().getMainAttributes();
        boolean enableExportClass = "true".equals(System.getProperty("sofa.ark.plugin.export.class.enable"));
        boolean overrideExportMode = "override".equals(manifestMainAttributes.getValue("export-mode"));
        plugin.setPluginName(manifestMainAttributes.getValue("pluginName")).setGroupId(manifestMainAttributes.getValue("groupId")).setArtifactId(manifestMainAttributes.getValue("artifactId")).setVersion(manifestMainAttributes.getValue("version")).setPriority(manifestMainAttributes.getValue("priority")).setPluginActivator(manifestMainAttributes.getValue("activator")).setClassPath(overrideExportMode ? pluginArchive.getUrls() : ClassLoaderUtils.getURLs((ClassLoader)masterClassLoader)).setPluginUrl(pluginArchive.getUrl()).setExportMode(manifestMainAttributes.getValue("export-mode")).setExportClasses(enableExportClass ? manifestMainAttributes.getValue("export-classes") : null).setExportPackages(enableExportClass ? manifestMainAttributes.getValue("export-packages") : null).setImportClasses(manifestMainAttributes.getValue("import-classes")).setImportPackages(manifestMainAttributes.getValue("import-packages")).setImportResources(manifestMainAttributes.getValue("import-resources")).setExportResources(manifestMainAttributes.getValue("export-resources")).setPluginClassLoader(overrideExportMode ? new PluginClassLoader(plugin.getPluginName(), plugin.getClassPath()) : masterClassLoader).setPluginContext(new PluginContextImpl(plugin));
        return plugin;
    }

    private boolean isArkPlugin(PluginArchive pluginArchive) {
        return pluginArchive.isEntryExist(new Archive.EntryFilter(){

            public boolean matches(Archive.Entry entry) {
                return !entry.isDirectory() && entry.getName().equals("com/alipay/sofa/ark/plugin/mark");
            }
        });
    }
}

