/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.acmpca.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.acmpca.model.ASN1Subject;
import com.amazonaws.services.acmpca.model.KeyAlgorithm;
import com.amazonaws.services.acmpca.model.SigningAlgorithm;
import com.amazonaws.services.acmpca.model.transform.CertificateAuthorityConfigurationMarshaller;
import java.io.Serializable;

public class CertificateAuthorityConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String keyAlgorithm;
    private String signingAlgorithm;
    private ASN1Subject subject;

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public CertificateAuthorityConfiguration withKeyAlgorithm(String keyAlgorithm) {
        this.setKeyAlgorithm(keyAlgorithm);
        return this;
    }

    public CertificateAuthorityConfiguration withKeyAlgorithm(KeyAlgorithm keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm.toString();
        return this;
    }

    public void setSigningAlgorithm(String signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public CertificateAuthorityConfiguration withSigningAlgorithm(String signingAlgorithm) {
        this.setSigningAlgorithm(signingAlgorithm);
        return this;
    }

    public CertificateAuthorityConfiguration withSigningAlgorithm(SigningAlgorithm signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm.toString();
        return this;
    }

    public void setSubject(ASN1Subject subject) {
        this.subject = subject;
    }

    public ASN1Subject getSubject() {
        return this.subject;
    }

    public CertificateAuthorityConfiguration withSubject(ASN1Subject subject) {
        this.setSubject(subject);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyAlgorithm() != null) {
            sb.append("KeyAlgorithm: ").append(this.getKeyAlgorithm()).append(",");
        }
        if (this.getSigningAlgorithm() != null) {
            sb.append("SigningAlgorithm: ").append(this.getSigningAlgorithm()).append(",");
        }
        if (this.getSubject() != null) {
            sb.append("Subject: ").append(this.getSubject());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateAuthorityConfiguration)) {
            return false;
        }
        CertificateAuthorityConfiguration other = (CertificateAuthorityConfiguration)obj;
        if (other.getKeyAlgorithm() == null ^ this.getKeyAlgorithm() == null) {
            return false;
        }
        if (other.getKeyAlgorithm() != null && !other.getKeyAlgorithm().equals(this.getKeyAlgorithm())) {
            return false;
        }
        if (other.getSigningAlgorithm() == null ^ this.getSigningAlgorithm() == null) {
            return false;
        }
        if (other.getSigningAlgorithm() != null && !other.getSigningAlgorithm().equals(this.getSigningAlgorithm())) {
            return false;
        }
        if (other.getSubject() == null ^ this.getSubject() == null) {
            return false;
        }
        return other.getSubject() == null || other.getSubject().equals(this.getSubject());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyAlgorithm() == null ? 0 : this.getKeyAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getSigningAlgorithm() == null ? 0 : this.getSigningAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getSubject() == null ? 0 : this.getSubject().hashCode());
        return hashCode;
    }

    public CertificateAuthorityConfiguration clone() {
        try {
            return (CertificateAuthorityConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CertificateAuthorityConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

