/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.athena.model.transform.QueryStagePlanNodeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QueryStagePlanNode
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String identifier;
    private List<QueryStagePlanNode> children;
    private List<String> remoteSources;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public QueryStagePlanNode withName(String name) {
        this.setName(name);
        return this;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public QueryStagePlanNode withIdentifier(String identifier) {
        this.setIdentifier(identifier);
        return this;
    }

    public List<QueryStagePlanNode> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<QueryStagePlanNode> children) {
        if (children == null) {
            this.children = null;
            return;
        }
        this.children = new ArrayList<QueryStagePlanNode>(children);
    }

    public QueryStagePlanNode withChildren(QueryStagePlanNode ... children) {
        if (this.children == null) {
            this.setChildren(new ArrayList<QueryStagePlanNode>(children.length));
        }
        for (QueryStagePlanNode ele : children) {
            this.children.add(ele);
        }
        return this;
    }

    public QueryStagePlanNode withChildren(Collection<QueryStagePlanNode> children) {
        this.setChildren(children);
        return this;
    }

    public List<String> getRemoteSources() {
        return this.remoteSources;
    }

    public void setRemoteSources(Collection<String> remoteSources) {
        if (remoteSources == null) {
            this.remoteSources = null;
            return;
        }
        this.remoteSources = new ArrayList<String>(remoteSources);
    }

    public QueryStagePlanNode withRemoteSources(String ... remoteSources) {
        if (this.remoteSources == null) {
            this.setRemoteSources(new ArrayList<String>(remoteSources.length));
        }
        for (String ele : remoteSources) {
            this.remoteSources.add(ele);
        }
        return this;
    }

    public QueryStagePlanNode withRemoteSources(Collection<String> remoteSources) {
        this.setRemoteSources(remoteSources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getIdentifier() != null) {
            sb.append("Identifier: ").append(this.getIdentifier()).append(",");
        }
        if (this.getChildren() != null) {
            sb.append("Children: ").append(this.getChildren()).append(",");
        }
        if (this.getRemoteSources() != null) {
            sb.append("RemoteSources: ").append(this.getRemoteSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStagePlanNode)) {
            return false;
        }
        QueryStagePlanNode other = (QueryStagePlanNode)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getIdentifier() == null ^ this.getIdentifier() == null) {
            return false;
        }
        if (other.getIdentifier() != null && !other.getIdentifier().equals(this.getIdentifier())) {
            return false;
        }
        if (other.getChildren() == null ^ this.getChildren() == null) {
            return false;
        }
        if (other.getChildren() != null && !other.getChildren().equals(this.getChildren())) {
            return false;
        }
        if (other.getRemoteSources() == null ^ this.getRemoteSources() == null) {
            return false;
        }
        return other.getRemoteSources() == null || other.getRemoteSources().equals(this.getRemoteSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getChildren() == null ? 0 : this.getChildren().hashCode());
        hashCode = 31 * hashCode + (this.getRemoteSources() == null ? 0 : this.getRemoteSources().hashCode());
        return hashCode;
    }

    public QueryStagePlanNode clone() {
        try {
            return (QueryStagePlanNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueryStagePlanNodeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

