/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.athena.model.EncryptionConfiguration;
import com.amazonaws.services.athena.model.transform.SessionConfigurationMarshaller;
import java.io.Serializable;

public class SessionConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String executionRole;
    private String workingDirectory;
    private Long idleTimeoutSeconds;
    private EncryptionConfiguration encryptionConfiguration;

    public void setExecutionRole(String executionRole) {
        this.executionRole = executionRole;
    }

    public String getExecutionRole() {
        return this.executionRole;
    }

    public SessionConfiguration withExecutionRole(String executionRole) {
        this.setExecutionRole(executionRole);
        return this;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public SessionConfiguration withWorkingDirectory(String workingDirectory) {
        this.setWorkingDirectory(workingDirectory);
        return this;
    }

    public void setIdleTimeoutSeconds(Long idleTimeoutSeconds) {
        this.idleTimeoutSeconds = idleTimeoutSeconds;
    }

    public Long getIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public SessionConfiguration withIdleTimeoutSeconds(Long idleTimeoutSeconds) {
        this.setIdleTimeoutSeconds(idleTimeoutSeconds);
        return this;
    }

    public void setEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        this.encryptionConfiguration = encryptionConfiguration;
    }

    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public SessionConfiguration withEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        this.setEncryptionConfiguration(encryptionConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExecutionRole() != null) {
            sb.append("ExecutionRole: ").append(this.getExecutionRole()).append(",");
        }
        if (this.getWorkingDirectory() != null) {
            sb.append("WorkingDirectory: ").append(this.getWorkingDirectory()).append(",");
        }
        if (this.getIdleTimeoutSeconds() != null) {
            sb.append("IdleTimeoutSeconds: ").append(this.getIdleTimeoutSeconds()).append(",");
        }
        if (this.getEncryptionConfiguration() != null) {
            sb.append("EncryptionConfiguration: ").append(this.getEncryptionConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionConfiguration)) {
            return false;
        }
        SessionConfiguration other = (SessionConfiguration)obj;
        if (other.getExecutionRole() == null ^ this.getExecutionRole() == null) {
            return false;
        }
        if (other.getExecutionRole() != null && !other.getExecutionRole().equals(this.getExecutionRole())) {
            return false;
        }
        if (other.getWorkingDirectory() == null ^ this.getWorkingDirectory() == null) {
            return false;
        }
        if (other.getWorkingDirectory() != null && !other.getWorkingDirectory().equals(this.getWorkingDirectory())) {
            return false;
        }
        if (other.getIdleTimeoutSeconds() == null ^ this.getIdleTimeoutSeconds() == null) {
            return false;
        }
        if (other.getIdleTimeoutSeconds() != null && !other.getIdleTimeoutSeconds().equals(this.getIdleTimeoutSeconds())) {
            return false;
        }
        if (other.getEncryptionConfiguration() == null ^ this.getEncryptionConfiguration() == null) {
            return false;
        }
        return other.getEncryptionConfiguration() == null || other.getEncryptionConfiguration().equals(this.getEncryptionConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExecutionRole() == null ? 0 : this.getExecutionRole().hashCode());
        hashCode = 31 * hashCode + (this.getWorkingDirectory() == null ? 0 : this.getWorkingDirectory().hashCode());
        hashCode = 31 * hashCode + (this.getIdleTimeoutSeconds() == null ? 0 : this.getIdleTimeoutSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionConfiguration() == null ? 0 : this.getEncryptionConfiguration().hashCode());
        return hashCode;
    }

    public SessionConfiguration clone() {
        try {
            return (SessionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SessionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

