/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.transform.SecurityProfileMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecurityProfile
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String organizationResourceId;
    private String arn;
    private String securityProfileName;
    private String description;
    private Map<String, String> tags;
    private Map<String, String> allowedAccessControlTags;
    private List<String> tagRestrictedResources;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public SecurityProfile withId(String id) {
        this.setId(id);
        return this;
    }

    public void setOrganizationResourceId(String organizationResourceId) {
        this.organizationResourceId = organizationResourceId;
    }

    public String getOrganizationResourceId() {
        return this.organizationResourceId;
    }

    public SecurityProfile withOrganizationResourceId(String organizationResourceId) {
        this.setOrganizationResourceId(organizationResourceId);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public SecurityProfile withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setSecurityProfileName(String securityProfileName) {
        this.securityProfileName = securityProfileName;
    }

    public String getSecurityProfileName() {
        return this.securityProfileName;
    }

    public SecurityProfile withSecurityProfileName(String securityProfileName) {
        this.setSecurityProfileName(securityProfileName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public SecurityProfile withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public SecurityProfile withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public SecurityProfile addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public SecurityProfile clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public Map<String, String> getAllowedAccessControlTags() {
        return this.allowedAccessControlTags;
    }

    public void setAllowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
        this.allowedAccessControlTags = allowedAccessControlTags;
    }

    public SecurityProfile withAllowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
        this.setAllowedAccessControlTags(allowedAccessControlTags);
        return this;
    }

    public SecurityProfile addAllowedAccessControlTagsEntry(String key, String value) {
        if (null == this.allowedAccessControlTags) {
            this.allowedAccessControlTags = new HashMap<String, String>();
        }
        if (this.allowedAccessControlTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.allowedAccessControlTags.put(key, value);
        return this;
    }

    public SecurityProfile clearAllowedAccessControlTagsEntries() {
        this.allowedAccessControlTags = null;
        return this;
    }

    public List<String> getTagRestrictedResources() {
        return this.tagRestrictedResources;
    }

    public void setTagRestrictedResources(Collection<String> tagRestrictedResources) {
        if (tagRestrictedResources == null) {
            this.tagRestrictedResources = null;
            return;
        }
        this.tagRestrictedResources = new ArrayList<String>(tagRestrictedResources);
    }

    public SecurityProfile withTagRestrictedResources(String ... tagRestrictedResources) {
        if (this.tagRestrictedResources == null) {
            this.setTagRestrictedResources(new ArrayList<String>(tagRestrictedResources.length));
        }
        for (String ele : tagRestrictedResources) {
            this.tagRestrictedResources.add(ele);
        }
        return this;
    }

    public SecurityProfile withTagRestrictedResources(Collection<String> tagRestrictedResources) {
        this.setTagRestrictedResources(tagRestrictedResources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getOrganizationResourceId() != null) {
            sb.append("OrganizationResourceId: ").append(this.getOrganizationResourceId()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getSecurityProfileName() != null) {
            sb.append("SecurityProfileName: ").append(this.getSecurityProfileName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAllowedAccessControlTags() != null) {
            sb.append("AllowedAccessControlTags: ").append(this.getAllowedAccessControlTags()).append(",");
        }
        if (this.getTagRestrictedResources() != null) {
            sb.append("TagRestrictedResources: ").append(this.getTagRestrictedResources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityProfile)) {
            return false;
        }
        SecurityProfile other = (SecurityProfile)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getOrganizationResourceId() == null ^ this.getOrganizationResourceId() == null) {
            return false;
        }
        if (other.getOrganizationResourceId() != null && !other.getOrganizationResourceId().equals(this.getOrganizationResourceId())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getSecurityProfileName() == null ^ this.getSecurityProfileName() == null) {
            return false;
        }
        if (other.getSecurityProfileName() != null && !other.getSecurityProfileName().equals(this.getSecurityProfileName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAllowedAccessControlTags() == null ^ this.getAllowedAccessControlTags() == null) {
            return false;
        }
        if (other.getAllowedAccessControlTags() != null && !other.getAllowedAccessControlTags().equals(this.getAllowedAccessControlTags())) {
            return false;
        }
        if (other.getTagRestrictedResources() == null ^ this.getTagRestrictedResources() == null) {
            return false;
        }
        return other.getTagRestrictedResources() == null || other.getTagRestrictedResources().equals(this.getTagRestrictedResources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getOrganizationResourceId() == null ? 0 : this.getOrganizationResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityProfileName() == null ? 0 : this.getSecurityProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedAccessControlTags() == null ? 0 : this.getAllowedAccessControlTags().hashCode());
        hashCode = 31 * hashCode + (this.getTagRestrictedResources() == null ? 0 : this.getTagRestrictedResources().hashCode());
        return hashCode;
    }

    public SecurityProfile clone() {
        try {
            return (SecurityProfile)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SecurityProfileMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

