/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateTaskProtectionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private SdkInternalList<String> tasks;
    private Boolean protectionEnabled;
    private Integer expiresInMinutes;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public UpdateTaskProtectionRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public List<String> getTasks() {
        if (this.tasks == null) {
            this.tasks = new SdkInternalList();
        }
        return this.tasks;
    }

    public void setTasks(Collection<String> tasks) {
        if (tasks == null) {
            this.tasks = null;
            return;
        }
        this.tasks = new SdkInternalList(tasks);
    }

    public UpdateTaskProtectionRequest withTasks(String ... tasks) {
        if (this.tasks == null) {
            this.setTasks((Collection<String>)new SdkInternalList(tasks.length));
        }
        for (String ele : tasks) {
            this.tasks.add((Object)ele);
        }
        return this;
    }

    public UpdateTaskProtectionRequest withTasks(Collection<String> tasks) {
        this.setTasks(tasks);
        return this;
    }

    public void setProtectionEnabled(Boolean protectionEnabled) {
        this.protectionEnabled = protectionEnabled;
    }

    public Boolean getProtectionEnabled() {
        return this.protectionEnabled;
    }

    public UpdateTaskProtectionRequest withProtectionEnabled(Boolean protectionEnabled) {
        this.setProtectionEnabled(protectionEnabled);
        return this;
    }

    public Boolean isProtectionEnabled() {
        return this.protectionEnabled;
    }

    public void setExpiresInMinutes(Integer expiresInMinutes) {
        this.expiresInMinutes = expiresInMinutes;
    }

    public Integer getExpiresInMinutes() {
        return this.expiresInMinutes;
    }

    public UpdateTaskProtectionRequest withExpiresInMinutes(Integer expiresInMinutes) {
        this.setExpiresInMinutes(expiresInMinutes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getTasks() != null) {
            sb.append("Tasks: ").append(this.getTasks()).append(",");
        }
        if (this.getProtectionEnabled() != null) {
            sb.append("ProtectionEnabled: ").append(this.getProtectionEnabled()).append(",");
        }
        if (this.getExpiresInMinutes() != null) {
            sb.append("ExpiresInMinutes: ").append(this.getExpiresInMinutes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTaskProtectionRequest)) {
            return false;
        }
        UpdateTaskProtectionRequest other = (UpdateTaskProtectionRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getTasks() == null ^ this.getTasks() == null) {
            return false;
        }
        if (other.getTasks() != null && !other.getTasks().equals(this.getTasks())) {
            return false;
        }
        if (other.getProtectionEnabled() == null ^ this.getProtectionEnabled() == null) {
            return false;
        }
        if (other.getProtectionEnabled() != null && !other.getProtectionEnabled().equals(this.getProtectionEnabled())) {
            return false;
        }
        if (other.getExpiresInMinutes() == null ^ this.getExpiresInMinutes() == null) {
            return false;
        }
        return other.getExpiresInMinutes() == null || other.getExpiresInMinutes().equals(this.getExpiresInMinutes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getTasks() == null ? 0 : this.getTasks().hashCode());
        hashCode = 31 * hashCode + (this.getProtectionEnabled() == null ? 0 : this.getProtectionEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getExpiresInMinutes() == null ? 0 : this.getExpiresInMinutes().hashCode());
        return hashCode;
    }

    public UpdateTaskProtectionRequest clone() {
        return (UpdateTaskProtectionRequest)super.clone();
    }
}

