/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glacier.model.CSVOutput;

@SdkInternalApi
public class CSVOutputMarshaller {
    private static final MarshallingInfo<String> QUOTEFIELDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QuoteFields").build();
    private static final MarshallingInfo<String> QUOTEESCAPECHARACTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QuoteEscapeCharacter").build();
    private static final MarshallingInfo<String> RECORDDELIMITER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordDelimiter").build();
    private static final MarshallingInfo<String> FIELDDELIMITER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FieldDelimiter").build();
    private static final MarshallingInfo<String> QUOTECHARACTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QuoteCharacter").build();
    private static final CSVOutputMarshaller instance = new CSVOutputMarshaller();

    public static CSVOutputMarshaller getInstance() {
        return instance;
    }

    public void marshall(CSVOutput cSVOutput, ProtocolMarshaller protocolMarshaller) {
        if (cSVOutput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cSVOutput.getQuoteFields(), QUOTEFIELDS_BINDING);
            protocolMarshaller.marshall((Object)cSVOutput.getQuoteEscapeCharacter(), QUOTEESCAPECHARACTER_BINDING);
            protocolMarshaller.marshall((Object)cSVOutput.getRecordDelimiter(), RECORDDELIMITER_BINDING);
            protocolMarshaller.marshall((Object)cSVOutput.getFieldDelimiter(), FIELDDELIMITER_BINDING);
            protocolMarshaller.marshall((Object)cSVOutput.getQuoteCharacter(), QUOTECHARACTER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

