/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.JobRunState;
import com.amazonaws.services.glue.model.Predecessor;
import com.amazonaws.services.glue.model.transform.JobRunMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobRun
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private Integer attempt;
    private String previousRunId;
    private String triggerName;
    private String jobName;
    private Date startedOn;
    private Date lastModifiedOn;
    private Date completedOn;
    private String jobRunState;
    private Map<String, String> arguments;
    private String errorMessage;
    private List<Predecessor> predecessorRuns;
    private Integer allocatedCapacity;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public JobRun withId(String id) {
        this.setId(id);
        return this;
    }

    public void setAttempt(Integer attempt) {
        this.attempt = attempt;
    }

    public Integer getAttempt() {
        return this.attempt;
    }

    public JobRun withAttempt(Integer attempt) {
        this.setAttempt(attempt);
        return this;
    }

    public void setPreviousRunId(String previousRunId) {
        this.previousRunId = previousRunId;
    }

    public String getPreviousRunId() {
        return this.previousRunId;
    }

    public JobRun withPreviousRunId(String previousRunId) {
        this.setPreviousRunId(previousRunId);
        return this;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public JobRun withTriggerName(String triggerName) {
        this.setTriggerName(triggerName);
        return this;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public JobRun withJobName(String jobName) {
        this.setJobName(jobName);
        return this;
    }

    public void setStartedOn(Date startedOn) {
        this.startedOn = startedOn;
    }

    public Date getStartedOn() {
        return this.startedOn;
    }

    public JobRun withStartedOn(Date startedOn) {
        this.setStartedOn(startedOn);
        return this;
    }

    public void setLastModifiedOn(Date lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    public Date getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public JobRun withLastModifiedOn(Date lastModifiedOn) {
        this.setLastModifiedOn(lastModifiedOn);
        return this;
    }

    public void setCompletedOn(Date completedOn) {
        this.completedOn = completedOn;
    }

    public Date getCompletedOn() {
        return this.completedOn;
    }

    public JobRun withCompletedOn(Date completedOn) {
        this.setCompletedOn(completedOn);
        return this;
    }

    public void setJobRunState(String jobRunState) {
        this.jobRunState = jobRunState;
    }

    public String getJobRunState() {
        return this.jobRunState;
    }

    public JobRun withJobRunState(String jobRunState) {
        this.setJobRunState(jobRunState);
        return this;
    }

    public JobRun withJobRunState(JobRunState jobRunState) {
        this.jobRunState = jobRunState.toString();
        return this;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<String, String> arguments) {
        this.arguments = arguments;
    }

    public JobRun withArguments(Map<String, String> arguments) {
        this.setArguments(arguments);
        return this;
    }

    public JobRun addArgumentsEntry(String key, String value) {
        if (null == this.arguments) {
            this.arguments = new HashMap<String, String>();
        }
        if (this.arguments.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.arguments.put(key, value);
        return this;
    }

    public JobRun clearArgumentsEntries() {
        this.arguments = null;
        return this;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public JobRun withErrorMessage(String errorMessage) {
        this.setErrorMessage(errorMessage);
        return this;
    }

    public List<Predecessor> getPredecessorRuns() {
        return this.predecessorRuns;
    }

    public void setPredecessorRuns(Collection<Predecessor> predecessorRuns) {
        if (predecessorRuns == null) {
            this.predecessorRuns = null;
            return;
        }
        this.predecessorRuns = new ArrayList<Predecessor>(predecessorRuns);
    }

    public JobRun withPredecessorRuns(Predecessor ... predecessorRuns) {
        if (this.predecessorRuns == null) {
            this.setPredecessorRuns(new ArrayList<Predecessor>(predecessorRuns.length));
        }
        for (Predecessor ele : predecessorRuns) {
            this.predecessorRuns.add(ele);
        }
        return this;
    }

    public JobRun withPredecessorRuns(Collection<Predecessor> predecessorRuns) {
        this.setPredecessorRuns(predecessorRuns);
        return this;
    }

    public void setAllocatedCapacity(Integer allocatedCapacity) {
        this.allocatedCapacity = allocatedCapacity;
    }

    public Integer getAllocatedCapacity() {
        return this.allocatedCapacity;
    }

    public JobRun withAllocatedCapacity(Integer allocatedCapacity) {
        this.setAllocatedCapacity(allocatedCapacity);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getAttempt() != null) {
            sb.append("Attempt: ").append(this.getAttempt()).append(",");
        }
        if (this.getPreviousRunId() != null) {
            sb.append("PreviousRunId: ").append(this.getPreviousRunId()).append(",");
        }
        if (this.getTriggerName() != null) {
            sb.append("TriggerName: ").append(this.getTriggerName()).append(",");
        }
        if (this.getJobName() != null) {
            sb.append("JobName: ").append(this.getJobName()).append(",");
        }
        if (this.getStartedOn() != null) {
            sb.append("StartedOn: ").append(this.getStartedOn()).append(",");
        }
        if (this.getLastModifiedOn() != null) {
            sb.append("LastModifiedOn: ").append(this.getLastModifiedOn()).append(",");
        }
        if (this.getCompletedOn() != null) {
            sb.append("CompletedOn: ").append(this.getCompletedOn()).append(",");
        }
        if (this.getJobRunState() != null) {
            sb.append("JobRunState: ").append(this.getJobRunState()).append(",");
        }
        if (this.getArguments() != null) {
            sb.append("Arguments: ").append(this.getArguments()).append(",");
        }
        if (this.getErrorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.getErrorMessage()).append(",");
        }
        if (this.getPredecessorRuns() != null) {
            sb.append("PredecessorRuns: ").append(this.getPredecessorRuns()).append(",");
        }
        if (this.getAllocatedCapacity() != null) {
            sb.append("AllocatedCapacity: ").append(this.getAllocatedCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobRun)) {
            return false;
        }
        JobRun other = (JobRun)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getAttempt() == null ^ this.getAttempt() == null) {
            return false;
        }
        if (other.getAttempt() != null && !other.getAttempt().equals(this.getAttempt())) {
            return false;
        }
        if (other.getPreviousRunId() == null ^ this.getPreviousRunId() == null) {
            return false;
        }
        if (other.getPreviousRunId() != null && !other.getPreviousRunId().equals(this.getPreviousRunId())) {
            return false;
        }
        if (other.getTriggerName() == null ^ this.getTriggerName() == null) {
            return false;
        }
        if (other.getTriggerName() != null && !other.getTriggerName().equals(this.getTriggerName())) {
            return false;
        }
        if (other.getJobName() == null ^ this.getJobName() == null) {
            return false;
        }
        if (other.getJobName() != null && !other.getJobName().equals(this.getJobName())) {
            return false;
        }
        if (other.getStartedOn() == null ^ this.getStartedOn() == null) {
            return false;
        }
        if (other.getStartedOn() != null && !other.getStartedOn().equals(this.getStartedOn())) {
            return false;
        }
        if (other.getLastModifiedOn() == null ^ this.getLastModifiedOn() == null) {
            return false;
        }
        if (other.getLastModifiedOn() != null && !other.getLastModifiedOn().equals(this.getLastModifiedOn())) {
            return false;
        }
        if (other.getCompletedOn() == null ^ this.getCompletedOn() == null) {
            return false;
        }
        if (other.getCompletedOn() != null && !other.getCompletedOn().equals(this.getCompletedOn())) {
            return false;
        }
        if (other.getJobRunState() == null ^ this.getJobRunState() == null) {
            return false;
        }
        if (other.getJobRunState() != null && !other.getJobRunState().equals(this.getJobRunState())) {
            return false;
        }
        if (other.getArguments() == null ^ this.getArguments() == null) {
            return false;
        }
        if (other.getArguments() != null && !other.getArguments().equals(this.getArguments())) {
            return false;
        }
        if (other.getErrorMessage() == null ^ this.getErrorMessage() == null) {
            return false;
        }
        if (other.getErrorMessage() != null && !other.getErrorMessage().equals(this.getErrorMessage())) {
            return false;
        }
        if (other.getPredecessorRuns() == null ^ this.getPredecessorRuns() == null) {
            return false;
        }
        if (other.getPredecessorRuns() != null && !other.getPredecessorRuns().equals(this.getPredecessorRuns())) {
            return false;
        }
        if (other.getAllocatedCapacity() == null ^ this.getAllocatedCapacity() == null) {
            return false;
        }
        return other.getAllocatedCapacity() == null || other.getAllocatedCapacity().equals(this.getAllocatedCapacity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getAttempt() == null ? 0 : this.getAttempt().hashCode());
        hashCode = 31 * hashCode + (this.getPreviousRunId() == null ? 0 : this.getPreviousRunId().hashCode());
        hashCode = 31 * hashCode + (this.getTriggerName() == null ? 0 : this.getTriggerName().hashCode());
        hashCode = 31 * hashCode + (this.getJobName() == null ? 0 : this.getJobName().hashCode());
        hashCode = 31 * hashCode + (this.getStartedOn() == null ? 0 : this.getStartedOn().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedOn() == null ? 0 : this.getLastModifiedOn().hashCode());
        hashCode = 31 * hashCode + (this.getCompletedOn() == null ? 0 : this.getCompletedOn().hashCode());
        hashCode = 31 * hashCode + (this.getJobRunState() == null ? 0 : this.getJobRunState().hashCode());
        hashCode = 31 * hashCode + (this.getArguments() == null ? 0 : this.getArguments().hashCode());
        hashCode = 31 * hashCode + (this.getErrorMessage() == null ? 0 : this.getErrorMessage().hashCode());
        hashCode = 31 * hashCode + (this.getPredecessorRuns() == null ? 0 : this.getPredecessorRuns().hashCode());
        hashCode = 31 * hashCode + (this.getAllocatedCapacity() == null ? 0 : this.getAllocatedCapacity().hashCode());
        return hashCode;
    }

    public JobRun clone() {
        try {
            return (JobRun)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobRunMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

