/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.AccessControlListConfiguration;
import com.amazonaws.services.kendra.model.DocumentsMetadataConfiguration;
import com.amazonaws.services.kendra.model.transform.S3DataSourceConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class S3DataSourceConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketName;
    private List<String> inclusionPrefixes;
    private List<String> exclusionPatterns;
    private DocumentsMetadataConfiguration documentsMetadataConfiguration;
    private AccessControlListConfiguration accessControlListConfiguration;

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public S3DataSourceConfiguration withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public List<String> getInclusionPrefixes() {
        return this.inclusionPrefixes;
    }

    public void setInclusionPrefixes(Collection<String> inclusionPrefixes) {
        if (inclusionPrefixes == null) {
            this.inclusionPrefixes = null;
            return;
        }
        this.inclusionPrefixes = new ArrayList<String>(inclusionPrefixes);
    }

    public S3DataSourceConfiguration withInclusionPrefixes(String ... inclusionPrefixes) {
        if (this.inclusionPrefixes == null) {
            this.setInclusionPrefixes(new ArrayList<String>(inclusionPrefixes.length));
        }
        for (String ele : inclusionPrefixes) {
            this.inclusionPrefixes.add(ele);
        }
        return this;
    }

    public S3DataSourceConfiguration withInclusionPrefixes(Collection<String> inclusionPrefixes) {
        this.setInclusionPrefixes(inclusionPrefixes);
        return this;
    }

    public List<String> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public void setExclusionPatterns(Collection<String> exclusionPatterns) {
        if (exclusionPatterns == null) {
            this.exclusionPatterns = null;
            return;
        }
        this.exclusionPatterns = new ArrayList<String>(exclusionPatterns);
    }

    public S3DataSourceConfiguration withExclusionPatterns(String ... exclusionPatterns) {
        if (this.exclusionPatterns == null) {
            this.setExclusionPatterns(new ArrayList<String>(exclusionPatterns.length));
        }
        for (String ele : exclusionPatterns) {
            this.exclusionPatterns.add(ele);
        }
        return this;
    }

    public S3DataSourceConfiguration withExclusionPatterns(Collection<String> exclusionPatterns) {
        this.setExclusionPatterns(exclusionPatterns);
        return this;
    }

    public void setDocumentsMetadataConfiguration(DocumentsMetadataConfiguration documentsMetadataConfiguration) {
        this.documentsMetadataConfiguration = documentsMetadataConfiguration;
    }

    public DocumentsMetadataConfiguration getDocumentsMetadataConfiguration() {
        return this.documentsMetadataConfiguration;
    }

    public S3DataSourceConfiguration withDocumentsMetadataConfiguration(DocumentsMetadataConfiguration documentsMetadataConfiguration) {
        this.setDocumentsMetadataConfiguration(documentsMetadataConfiguration);
        return this;
    }

    public void setAccessControlListConfiguration(AccessControlListConfiguration accessControlListConfiguration) {
        this.accessControlListConfiguration = accessControlListConfiguration;
    }

    public AccessControlListConfiguration getAccessControlListConfiguration() {
        return this.accessControlListConfiguration;
    }

    public S3DataSourceConfiguration withAccessControlListConfiguration(AccessControlListConfiguration accessControlListConfiguration) {
        this.setAccessControlListConfiguration(accessControlListConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getInclusionPrefixes() != null) {
            sb.append("InclusionPrefixes: ").append(this.getInclusionPrefixes()).append(",");
        }
        if (this.getExclusionPatterns() != null) {
            sb.append("ExclusionPatterns: ").append(this.getExclusionPatterns()).append(",");
        }
        if (this.getDocumentsMetadataConfiguration() != null) {
            sb.append("DocumentsMetadataConfiguration: ").append(this.getDocumentsMetadataConfiguration()).append(",");
        }
        if (this.getAccessControlListConfiguration() != null) {
            sb.append("AccessControlListConfiguration: ").append(this.getAccessControlListConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataSourceConfiguration)) {
            return false;
        }
        S3DataSourceConfiguration other = (S3DataSourceConfiguration)obj;
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getInclusionPrefixes() == null ^ this.getInclusionPrefixes() == null) {
            return false;
        }
        if (other.getInclusionPrefixes() != null && !other.getInclusionPrefixes().equals(this.getInclusionPrefixes())) {
            return false;
        }
        if (other.getExclusionPatterns() == null ^ this.getExclusionPatterns() == null) {
            return false;
        }
        if (other.getExclusionPatterns() != null && !other.getExclusionPatterns().equals(this.getExclusionPatterns())) {
            return false;
        }
        if (other.getDocumentsMetadataConfiguration() == null ^ this.getDocumentsMetadataConfiguration() == null) {
            return false;
        }
        if (other.getDocumentsMetadataConfiguration() != null && !other.getDocumentsMetadataConfiguration().equals(this.getDocumentsMetadataConfiguration())) {
            return false;
        }
        if (other.getAccessControlListConfiguration() == null ^ this.getAccessControlListConfiguration() == null) {
            return false;
        }
        return other.getAccessControlListConfiguration() == null || other.getAccessControlListConfiguration().equals(this.getAccessControlListConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getInclusionPrefixes() == null ? 0 : this.getInclusionPrefixes().hashCode());
        hashCode = 31 * hashCode + (this.getExclusionPatterns() == null ? 0 : this.getExclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentsMetadataConfiguration() == null ? 0 : this.getDocumentsMetadataConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAccessControlListConfiguration() == null ? 0 : this.getAccessControlListConfiguration().hashCode());
        return hashCode;
    }

    public S3DataSourceConfiguration clone() {
        try {
            return (S3DataSourceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DataSourceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

