/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.DefaultDetection;
import com.amazonaws.services.macie2.model.SensitiveDataItemCategory;
import com.amazonaws.services.macie2.model.transform.SensitiveDataItemMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SensitiveDataItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String category;
    private List<DefaultDetection> detections;
    private Long totalCount;

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public SensitiveDataItem withCategory(String category) {
        this.setCategory(category);
        return this;
    }

    public SensitiveDataItem withCategory(SensitiveDataItemCategory category) {
        this.category = category.toString();
        return this;
    }

    public List<DefaultDetection> getDetections() {
        return this.detections;
    }

    public void setDetections(Collection<DefaultDetection> detections) {
        if (detections == null) {
            this.detections = null;
            return;
        }
        this.detections = new ArrayList<DefaultDetection>(detections);
    }

    public SensitiveDataItem withDetections(DefaultDetection ... detections) {
        if (this.detections == null) {
            this.setDetections(new ArrayList<DefaultDetection>(detections.length));
        }
        for (DefaultDetection ele : detections) {
            this.detections.add(ele);
        }
        return this;
    }

    public SensitiveDataItem withDetections(Collection<DefaultDetection> detections) {
        this.setDetections(detections);
        return this;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public SensitiveDataItem withTotalCount(Long totalCount) {
        this.setTotalCount(totalCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCategory() != null) {
            sb.append("Category: ").append(this.getCategory()).append(",");
        }
        if (this.getDetections() != null) {
            sb.append("Detections: ").append(this.getDetections()).append(",");
        }
        if (this.getTotalCount() != null) {
            sb.append("TotalCount: ").append(this.getTotalCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SensitiveDataItem)) {
            return false;
        }
        SensitiveDataItem other = (SensitiveDataItem)obj;
        if (other.getCategory() == null ^ this.getCategory() == null) {
            return false;
        }
        if (other.getCategory() != null && !other.getCategory().equals(this.getCategory())) {
            return false;
        }
        if (other.getDetections() == null ^ this.getDetections() == null) {
            return false;
        }
        if (other.getDetections() != null && !other.getDetections().equals(this.getDetections())) {
            return false;
        }
        if (other.getTotalCount() == null ^ this.getTotalCount() == null) {
            return false;
        }
        return other.getTotalCount() == null || other.getTotalCount().equals(this.getTotalCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCategory() == null ? 0 : this.getCategory().hashCode());
        hashCode = 31 * hashCode + (this.getDetections() == null ? 0 : this.getDetections().hashCode());
        hashCode = 31 * hashCode + (this.getTotalCount() == null ? 0 : this.getTotalCount().hashCode());
        return hashCode;
    }

    public SensitiveDataItem clone() {
        try {
            return (SensitiveDataItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SensitiveDataItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

