/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.services.macie2.model.S3Object;
import com.amazonaws.services.macie2.model.transform.KeyValuePairJsonUnmarshaller;
import com.amazonaws.services.macie2.model.transform.ServerSideEncryptionJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3ObjectJsonUnmarshaller
implements Unmarshaller<S3Object, JsonUnmarshallerContext> {
    private static S3ObjectJsonUnmarshaller instance;

    public S3Object unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Object s3Object = new S3Object();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("bucketArn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Object.setBucketArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("eTag", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Object.setETag((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("extension", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Object.setExtension((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("key", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Object.setKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("lastModified", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Object.setLastModified(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                }
                if (context.testExpression("path", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Object.setPath((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("publicAccess", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Object.setPublicAccess((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("serverSideEncryption", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Object.setServerSideEncryption(ServerSideEncryptionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("size", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Object.setSize((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("storageClass", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Object.setStorageClass((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("tags", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Object.setTags(new ListUnmarshaller((Unmarshaller)KeyValuePairJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("versionId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Object.setVersionId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3Object;
    }

    public static S3ObjectJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3ObjectJsonUnmarshaller();
        }
        return instance;
    }
}

