/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudsearchdomain.model.SuggestionMatch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SuggestModel
implements Serializable {
    private String query;
    private Long found;
    private ListWithAutoConstructFlag<SuggestionMatch> suggestions;

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public SuggestModel withQuery(String query) {
        this.query = query;
        return this;
    }

    public Long getFound() {
        return this.found;
    }

    public void setFound(Long found) {
        this.found = found;
    }

    public SuggestModel withFound(Long found) {
        this.found = found;
        return this;
    }

    public List<SuggestionMatch> getSuggestions() {
        if (this.suggestions == null) {
            this.suggestions = new ListWithAutoConstructFlag();
            this.suggestions.setAutoConstruct(true);
        }
        return this.suggestions;
    }

    public void setSuggestions(Collection<SuggestionMatch> suggestions) {
        if (suggestions == null) {
            this.suggestions = null;
            return;
        }
        ListWithAutoConstructFlag suggestionsCopy = new ListWithAutoConstructFlag(suggestions.size());
        suggestionsCopy.addAll(suggestions);
        this.suggestions = suggestionsCopy;
    }

    public SuggestModel withSuggestions(SuggestionMatch ... suggestions) {
        if (this.getSuggestions() == null) {
            this.setSuggestions(new ArrayList<SuggestionMatch>(suggestions.length));
        }
        for (SuggestionMatch value : suggestions) {
            this.getSuggestions().add(value);
        }
        return this;
    }

    public SuggestModel withSuggestions(Collection<SuggestionMatch> suggestions) {
        if (suggestions == null) {
            this.suggestions = null;
        } else {
            ListWithAutoConstructFlag suggestionsCopy = new ListWithAutoConstructFlag(suggestions.size());
            suggestionsCopy.addAll(suggestions);
            this.suggestions = suggestionsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQuery() != null) {
            sb.append("Query: " + this.getQuery() + ",");
        }
        if (this.getFound() != null) {
            sb.append("Found: " + this.getFound() + ",");
        }
        if (this.getSuggestions() != null) {
            sb.append("Suggestions: " + this.getSuggestions());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQuery() == null ? 0 : this.getQuery().hashCode());
        hashCode = 31 * hashCode + (this.getFound() == null ? 0 : this.getFound().hashCode());
        hashCode = 31 * hashCode + (this.getSuggestions() == null ? 0 : this.getSuggestions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestModel)) {
            return false;
        }
        SuggestModel other = (SuggestModel)obj;
        if (other.getQuery() == null ^ this.getQuery() == null) {
            return false;
        }
        if (other.getQuery() != null && !other.getQuery().equals(this.getQuery())) {
            return false;
        }
        if (other.getFound() == null ^ this.getFound() == null) {
            return false;
        }
        if (other.getFound() != null && !other.getFound().equals(this.getFound())) {
            return false;
        }
        if (other.getSuggestions() == null ^ this.getSuggestions() == null) {
            return false;
        }
        return other.getSuggestions() == null || other.getSuggestions().equals(this.getSuggestions());
    }
}

