/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeTrailsRequestMarshaller
implements Marshaller<Request<DescribeTrailsRequest>, DescribeTrailsRequest> {
    @Override
    public Request<DescribeTrailsRequest> marshall(DescribeTrailsRequest describeTrailsRequest) {
        if (describeTrailsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeTrailsRequest> request = new DefaultRequest<DescribeTrailsRequest>(describeTrailsRequest, "AWSCloudTrail");
        String target = "CloudTrail_20131101.DescribeTrails";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag trailNameListList = (ListWithAutoConstructFlag)describeTrailsRequest.getTrailNameList();
            if (!(trailNameListList == null || trailNameListList.isAutoConstruct() && trailNameListList.isEmpty())) {
                jsonWriter.key("trailNameList");
                jsonWriter.array();
                for (String trailNameListListValue : trailNameListList) {
                    if (trailNameListListValue == null) continue;
                    jsonWriter.value(trailNameListListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

