/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

public class GetOpenIdTokenForDeveloperIdentityRequestMarshaller
implements Marshaller<Request<GetOpenIdTokenForDeveloperIdentityRequest>, GetOpenIdTokenForDeveloperIdentityRequest> {
    @Override
    public Request<GetOpenIdTokenForDeveloperIdentityRequest> marshall(GetOpenIdTokenForDeveloperIdentityRequest getOpenIdTokenForDeveloperIdentityRequest) {
        if (getOpenIdTokenForDeveloperIdentityRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetOpenIdTokenForDeveloperIdentityRequest> request = new DefaultRequest<GetOpenIdTokenForDeveloperIdentityRequest>(getOpenIdTokenForDeveloperIdentityRequest, "AmazonCognitoIdentity");
        String target = "AWSCognitoIdentityService.GetOpenIdTokenForDeveloperIdentity";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (getOpenIdTokenForDeveloperIdentityRequest.getIdentityPoolId() != null) {
                jsonWriter.key("IdentityPoolId").value(getOpenIdTokenForDeveloperIdentityRequest.getIdentityPoolId());
            }
            if (getOpenIdTokenForDeveloperIdentityRequest.getIdentityId() != null) {
                jsonWriter.key("IdentityId").value(getOpenIdTokenForDeveloperIdentityRequest.getIdentityId());
            }
            if (getOpenIdTokenForDeveloperIdentityRequest.getLogins() != null) {
                jsonWriter.key("Logins");
                jsonWriter.object();
                for (Map.Entry<String, String> loginsListValue : getOpenIdTokenForDeveloperIdentityRequest.getLogins().entrySet()) {
                    if (loginsListValue.getValue() == null) continue;
                    jsonWriter.key(loginsListValue.getKey());
                    jsonWriter.value(loginsListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (getOpenIdTokenForDeveloperIdentityRequest.getTokenDuration() != null) {
                jsonWriter.key("TokenDuration").value(getOpenIdTokenForDeveloperIdentityRequest.getTokenDuration());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

