/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.datapipeline.model.DescribePipelinesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribePipelinesRequestMarshaller
implements Marshaller<Request<DescribePipelinesRequest>, DescribePipelinesRequest> {
    @Override
    public Request<DescribePipelinesRequest> marshall(DescribePipelinesRequest describePipelinesRequest) {
        if (describePipelinesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribePipelinesRequest> request = new DefaultRequest<DescribePipelinesRequest>(describePipelinesRequest, "DataPipeline");
        String target = "DataPipeline.DescribePipelines";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag pipelineIdsList = (ListWithAutoConstructFlag)describePipelinesRequest.getPipelineIds();
            if (!(pipelineIdsList == null || pipelineIdsList.isAutoConstruct() && pipelineIdsList.isEmpty())) {
                jsonWriter.key("pipelineIds");
                jsonWriter.array();
                for (String pipelineIdsListValue : pipelineIdsList) {
                    if (pipelineIdsListValue == null) continue;
                    jsonWriter.value(pipelineIdsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

