/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RegisterTaskDefinitionRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String family;
    private ListWithAutoConstructFlag<ContainerDefinition> containerDefinitions;

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public RegisterTaskDefinitionRequest withFamily(String family) {
        this.family = family;
        return this;
    }

    public List<ContainerDefinition> getContainerDefinitions() {
        if (this.containerDefinitions == null) {
            this.containerDefinitions = new ListWithAutoConstructFlag();
            this.containerDefinitions.setAutoConstruct(true);
        }
        return this.containerDefinitions;
    }

    public void setContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        if (containerDefinitions == null) {
            this.containerDefinitions = null;
            return;
        }
        ListWithAutoConstructFlag containerDefinitionsCopy = new ListWithAutoConstructFlag(containerDefinitions.size());
        containerDefinitionsCopy.addAll(containerDefinitions);
        this.containerDefinitions = containerDefinitionsCopy;
    }

    public RegisterTaskDefinitionRequest withContainerDefinitions(ContainerDefinition ... containerDefinitions) {
        if (this.getContainerDefinitions() == null) {
            this.setContainerDefinitions(new ArrayList<ContainerDefinition>(containerDefinitions.length));
        }
        for (ContainerDefinition value : containerDefinitions) {
            this.getContainerDefinitions().add(value);
        }
        return this;
    }

    public RegisterTaskDefinitionRequest withContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        if (containerDefinitions == null) {
            this.containerDefinitions = null;
        } else {
            ListWithAutoConstructFlag containerDefinitionsCopy = new ListWithAutoConstructFlag(containerDefinitions.size());
            containerDefinitionsCopy.addAll(containerDefinitions);
            this.containerDefinitions = containerDefinitionsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFamily() != null) {
            sb.append("Family: " + this.getFamily() + ",");
        }
        if (this.getContainerDefinitions() != null) {
            sb.append("ContainerDefinitions: " + this.getContainerDefinitions());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFamily() == null ? 0 : this.getFamily().hashCode());
        hashCode = 31 * hashCode + (this.getContainerDefinitions() == null ? 0 : this.getContainerDefinitions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTaskDefinitionRequest)) {
            return false;
        }
        RegisterTaskDefinitionRequest other = (RegisterTaskDefinitionRequest)obj;
        if (other.getFamily() == null ^ this.getFamily() == null) {
            return false;
        }
        if (other.getFamily() != null && !other.getFamily().equals(this.getFamily())) {
            return false;
        }
        if (other.getContainerDefinitions() == null ^ this.getContainerDefinitions() == null) {
            return false;
        }
        return other.getContainerDefinitions() == null || other.getContainerDefinitions().equals(this.getContainerDefinitions());
    }
}

