/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.Container;
import com.amazonaws.services.ecs.model.TaskOverride;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Task
implements Serializable {
    private String taskArn;
    private String clusterArn;
    private String taskDefinitionArn;
    private String containerInstanceArn;
    private TaskOverride overrides;
    private String lastStatus;
    private String desiredStatus;
    private ListWithAutoConstructFlag<Container> containers;

    public String getTaskArn() {
        return this.taskArn;
    }

    public void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    public Task withTaskArn(String taskArn) {
        this.taskArn = taskArn;
        return this;
    }

    public String getClusterArn() {
        return this.clusterArn;
    }

    public void setClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
    }

    public Task withClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
        return this;
    }

    public String getTaskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public void setTaskDefinitionArn(String taskDefinitionArn) {
        this.taskDefinitionArn = taskDefinitionArn;
    }

    public Task withTaskDefinitionArn(String taskDefinitionArn) {
        this.taskDefinitionArn = taskDefinitionArn;
        return this;
    }

    public String getContainerInstanceArn() {
        return this.containerInstanceArn;
    }

    public void setContainerInstanceArn(String containerInstanceArn) {
        this.containerInstanceArn = containerInstanceArn;
    }

    public Task withContainerInstanceArn(String containerInstanceArn) {
        this.containerInstanceArn = containerInstanceArn;
        return this;
    }

    public TaskOverride getOverrides() {
        return this.overrides;
    }

    public void setOverrides(TaskOverride overrides) {
        this.overrides = overrides;
    }

    public Task withOverrides(TaskOverride overrides) {
        this.overrides = overrides;
        return this;
    }

    public String getLastStatus() {
        return this.lastStatus;
    }

    public void setLastStatus(String lastStatus) {
        this.lastStatus = lastStatus;
    }

    public Task withLastStatus(String lastStatus) {
        this.lastStatus = lastStatus;
        return this;
    }

    public String getDesiredStatus() {
        return this.desiredStatus;
    }

    public void setDesiredStatus(String desiredStatus) {
        this.desiredStatus = desiredStatus;
    }

    public Task withDesiredStatus(String desiredStatus) {
        this.desiredStatus = desiredStatus;
        return this;
    }

    public List<Container> getContainers() {
        if (this.containers == null) {
            this.containers = new ListWithAutoConstructFlag();
            this.containers.setAutoConstruct(true);
        }
        return this.containers;
    }

    public void setContainers(Collection<Container> containers) {
        if (containers == null) {
            this.containers = null;
            return;
        }
        ListWithAutoConstructFlag containersCopy = new ListWithAutoConstructFlag(containers.size());
        containersCopy.addAll(containers);
        this.containers = containersCopy;
    }

    public Task withContainers(Container ... containers) {
        if (this.getContainers() == null) {
            this.setContainers(new ArrayList<Container>(containers.length));
        }
        for (Container value : containers) {
            this.getContainers().add(value);
        }
        return this;
    }

    public Task withContainers(Collection<Container> containers) {
        if (containers == null) {
            this.containers = null;
        } else {
            ListWithAutoConstructFlag containersCopy = new ListWithAutoConstructFlag(containers.size());
            containersCopy.addAll(containers);
            this.containers = containersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaskArn() != null) {
            sb.append("TaskArn: " + this.getTaskArn() + ",");
        }
        if (this.getClusterArn() != null) {
            sb.append("ClusterArn: " + this.getClusterArn() + ",");
        }
        if (this.getTaskDefinitionArn() != null) {
            sb.append("TaskDefinitionArn: " + this.getTaskDefinitionArn() + ",");
        }
        if (this.getContainerInstanceArn() != null) {
            sb.append("ContainerInstanceArn: " + this.getContainerInstanceArn() + ",");
        }
        if (this.getOverrides() != null) {
            sb.append("Overrides: " + this.getOverrides() + ",");
        }
        if (this.getLastStatus() != null) {
            sb.append("LastStatus: " + this.getLastStatus() + ",");
        }
        if (this.getDesiredStatus() != null) {
            sb.append("DesiredStatus: " + this.getDesiredStatus() + ",");
        }
        if (this.getContainers() != null) {
            sb.append("Containers: " + this.getContainers());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaskArn() == null ? 0 : this.getTaskArn().hashCode());
        hashCode = 31 * hashCode + (this.getClusterArn() == null ? 0 : this.getClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getTaskDefinitionArn() == null ? 0 : this.getTaskDefinitionArn().hashCode());
        hashCode = 31 * hashCode + (this.getContainerInstanceArn() == null ? 0 : this.getContainerInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getOverrides() == null ? 0 : this.getOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getLastStatus() == null ? 0 : this.getLastStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredStatus() == null ? 0 : this.getDesiredStatus().hashCode());
        hashCode = 31 * hashCode + (this.getContainers() == null ? 0 : this.getContainers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Task)) {
            return false;
        }
        Task other = (Task)obj;
        if (other.getTaskArn() == null ^ this.getTaskArn() == null) {
            return false;
        }
        if (other.getTaskArn() != null && !other.getTaskArn().equals(this.getTaskArn())) {
            return false;
        }
        if (other.getClusterArn() == null ^ this.getClusterArn() == null) {
            return false;
        }
        if (other.getClusterArn() != null && !other.getClusterArn().equals(this.getClusterArn())) {
            return false;
        }
        if (other.getTaskDefinitionArn() == null ^ this.getTaskDefinitionArn() == null) {
            return false;
        }
        if (other.getTaskDefinitionArn() != null && !other.getTaskDefinitionArn().equals(this.getTaskDefinitionArn())) {
            return false;
        }
        if (other.getContainerInstanceArn() == null ^ this.getContainerInstanceArn() == null) {
            return false;
        }
        if (other.getContainerInstanceArn() != null && !other.getContainerInstanceArn().equals(this.getContainerInstanceArn())) {
            return false;
        }
        if (other.getOverrides() == null ^ this.getOverrides() == null) {
            return false;
        }
        if (other.getOverrides() != null && !other.getOverrides().equals(this.getOverrides())) {
            return false;
        }
        if (other.getLastStatus() == null ^ this.getLastStatus() == null) {
            return false;
        }
        if (other.getLastStatus() != null && !other.getLastStatus().equals(this.getLastStatus())) {
            return false;
        }
        if (other.getDesiredStatus() == null ^ this.getDesiredStatus() == null) {
            return false;
        }
        if (other.getDesiredStatus() != null && !other.getDesiredStatus().equals(this.getDesiredStatus())) {
            return false;
        }
        if (other.getContainers() == null ^ this.getContainers() == null) {
            return false;
        }
        return other.getContainers() == null || other.getContainers().equals(this.getContainers());
    }
}

