/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.ParameterNameValue;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyCacheParameterGroupRequestMarshaller
implements Marshaller<Request<ModifyCacheParameterGroupRequest>, ModifyCacheParameterGroupRequest> {
    @Override
    public Request<ModifyCacheParameterGroupRequest> marshall(ModifyCacheParameterGroupRequest modifyCacheParameterGroupRequest) {
        if (modifyCacheParameterGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyCacheParameterGroupRequest> request = new DefaultRequest<ModifyCacheParameterGroupRequest>(modifyCacheParameterGroupRequest, "AmazonElastiCache");
        request.addParameter("Action", "ModifyCacheParameterGroup");
        request.addParameter("Version", "2014-09-30");
        if (modifyCacheParameterGroupRequest.getCacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString(modifyCacheParameterGroupRequest.getCacheParameterGroupName()));
        }
        List<ParameterNameValue> parameterNameValuesList = modifyCacheParameterGroupRequest.getParameterNameValues();
        int parameterNameValuesListIndex = 1;
        for (ParameterNameValue parameterNameValuesListValue : parameterNameValuesList) {
            ParameterNameValue parameterNameValueMember = parameterNameValuesListValue;
            if (parameterNameValueMember != null) {
                if (parameterNameValueMember.getParameterName() != null) {
                    request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterName", StringUtils.fromString(parameterNameValueMember.getParameterName()));
                }
                if (parameterNameValueMember.getParameterValue() != null) {
                    request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterValue", StringUtils.fromString(parameterNameValueMember.getParameterValue()));
                }
            }
            ++parameterNameValuesListIndex;
        }
        return request;
    }
}

