/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.glacier.model.DataRetrievalRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataRetrievalPolicy
implements Serializable {
    private ListWithAutoConstructFlag<DataRetrievalRule> rules;

    public List<DataRetrievalRule> getRules() {
        if (this.rules == null) {
            this.rules = new ListWithAutoConstructFlag();
            this.rules.setAutoConstruct(true);
        }
        return this.rules;
    }

    public void setRules(Collection<DataRetrievalRule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        ListWithAutoConstructFlag rulesCopy = new ListWithAutoConstructFlag(rules.size());
        rulesCopy.addAll(rules);
        this.rules = rulesCopy;
    }

    public DataRetrievalPolicy withRules(DataRetrievalRule ... rules) {
        if (this.getRules() == null) {
            this.setRules(new ArrayList<DataRetrievalRule>(rules.length));
        }
        for (DataRetrievalRule value : rules) {
            this.getRules().add(value);
        }
        return this;
    }

    public DataRetrievalPolicy withRules(Collection<DataRetrievalRule> rules) {
        if (rules == null) {
            this.rules = null;
        } else {
            ListWithAutoConstructFlag rulesCopy = new ListWithAutoConstructFlag(rules.size());
            rulesCopy.addAll(rules);
            this.rules = rulesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRules() != null) {
            sb.append("Rules: " + this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataRetrievalPolicy)) {
            return false;
        }
        DataRetrievalPolicy other = (DataRetrievalPolicy)obj;
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }
}

