/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.UploadFunctionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UploadFunctionRequestMarshaller
implements Marshaller<Request<UploadFunctionRequest>, UploadFunctionRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<UploadFunctionRequest> marshall(UploadFunctionRequest uploadFunctionRequest) {
        String value;
        String name;
        if (uploadFunctionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UploadFunctionRequest> request = new DefaultRequest<UploadFunctionRequest>(uploadFunctionRequest, "AWSLambda");
        String target = "AWSLambda.UploadFunction";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("FunctionName")) {
            name = DYNAMIC_QUERY_PARAMS.get("FunctionName");
            String string = value = uploadFunctionRequest.getFunctionName() == null ? null : StringUtils.fromString(uploadFunctionRequest.getFunctionName());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{FunctionName}", uploadFunctionRequest.getFunctionName() == null ? "" : StringUtils.fromString(uploadFunctionRequest.getFunctionName()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Runtime")) {
            name = DYNAMIC_QUERY_PARAMS.get("Runtime");
            String string = value = uploadFunctionRequest.getRuntime() == null ? null : StringUtils.fromString(uploadFunctionRequest.getRuntime());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Runtime}", uploadFunctionRequest.getRuntime() == null ? "" : StringUtils.fromString(uploadFunctionRequest.getRuntime()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Role")) {
            name = DYNAMIC_QUERY_PARAMS.get("Role");
            String string = value = uploadFunctionRequest.getRole() == null ? null : StringUtils.fromString(uploadFunctionRequest.getRole());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Role}", uploadFunctionRequest.getRole() == null ? "" : StringUtils.fromString(uploadFunctionRequest.getRole()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Handler")) {
            name = DYNAMIC_QUERY_PARAMS.get("Handler");
            String string = value = uploadFunctionRequest.getHandler() == null ? null : StringUtils.fromString(uploadFunctionRequest.getHandler());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Handler}", uploadFunctionRequest.getHandler() == null ? "" : StringUtils.fromString(uploadFunctionRequest.getHandler()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Mode")) {
            name = DYNAMIC_QUERY_PARAMS.get("Mode");
            String string = value = uploadFunctionRequest.getMode() == null ? null : StringUtils.fromString(uploadFunctionRequest.getMode());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Mode}", uploadFunctionRequest.getMode() == null ? "" : StringUtils.fromString(uploadFunctionRequest.getMode()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Description")) {
            name = DYNAMIC_QUERY_PARAMS.get("Description");
            String string = value = uploadFunctionRequest.getDescription() == null ? null : StringUtils.fromString(uploadFunctionRequest.getDescription());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Description}", uploadFunctionRequest.getDescription() == null ? "" : StringUtils.fromString(uploadFunctionRequest.getDescription()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Timeout")) {
            name = DYNAMIC_QUERY_PARAMS.get("Timeout");
            String string = value = uploadFunctionRequest.getTimeout() == null ? null : StringUtils.fromInteger(uploadFunctionRequest.getTimeout());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Timeout}", uploadFunctionRequest.getTimeout() == null ? "" : StringUtils.fromInteger(uploadFunctionRequest.getTimeout()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("MemorySize")) {
            name = DYNAMIC_QUERY_PARAMS.get("MemorySize");
            String string = value = uploadFunctionRequest.getMemorySize() == null ? null : StringUtils.fromInteger(uploadFunctionRequest.getMemorySize());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{MemorySize}", uploadFunctionRequest.getMemorySize() == null ? "" : StringUtils.fromInteger(uploadFunctionRequest.getMemorySize()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        request.setContent(uploadFunctionRequest.getFunctionZip());
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }

    static {
        String path = "/2014-11-13/functions/{FunctionName}?Description={Description}&Handler={Handler}&MemorySize={MemorySize}&Mode={Mode}&Role={Role}&Runtime={Runtime}&Timeout={Timeout}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

