/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.rds.model.DescribePendingMaintenanceActionsRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribePendingMaintenanceActionsRequestMarshaller
implements Marshaller<Request<DescribePendingMaintenanceActionsRequest>, DescribePendingMaintenanceActionsRequest> {
    @Override
    public Request<DescribePendingMaintenanceActionsRequest> marshall(DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) {
        if (describePendingMaintenanceActionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribePendingMaintenanceActionsRequest> request = new DefaultRequest<DescribePendingMaintenanceActionsRequest>(describePendingMaintenanceActionsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribePendingMaintenanceActions");
        request.addParameter("Version", "2014-10-31");
        if (describePendingMaintenanceActionsRequest.getResourceIdentifier() != null) {
            request.addParameter("ResourceIdentifier", StringUtils.fromString(describePendingMaintenanceActionsRequest.getResourceIdentifier()));
        }
        List<Filter> filtersList = describePendingMaintenanceActionsRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString(filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        if (describePendingMaintenanceActionsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describePendingMaintenanceActionsRequest.getMarker()));
        }
        if (describePendingMaintenanceActionsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describePendingMaintenanceActionsRequest.getMaxRecords()));
        }
        return request;
    }
}

